import { jsx } from 'react/jsx-runtime';
import { cx, css } from '@emotion/css';
import '@grafana/data';
import { useStyles2, Button } from '@grafana/ui';

const AccessoryButton = ({ className, ...props }) => {
  const styles = useStyles2(getButtonStyles);
  return /* @__PURE__ */ jsx(Button, { ...props, className: cx(className, styles.button) });
};
const getButtonStyles = (theme) => ({
  button: css({
    paddingLeft: theme.spacing(3 / 2),
    paddingRight: theme.spacing(3 / 2)
  })
});

export { AccessoryButton };
//# sourceMappingURL=AccessoryButton.js.map
