/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dashboard.browser;

import java.util.Date;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.dashboard.data.DashboardDataset;
import org.jkiss.dbeaver.model.dashboard.registry.DashboardItemConfiguration;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.ShellUtils;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.dashboard.browser.DashboardBrowserComposite;
import org.jkiss.dbeaver.ui.dashboard.control.DashboardRendererAbstract;
import org.jkiss.dbeaver.ui.dashboard.control.DashboardViewItem;
import org.jkiss.dbeaver.ui.dashboard.model.DashboardContainer;
import org.jkiss.dbeaver.ui.dashboard.model.DashboardItemContainer;
import org.jkiss.dbeaver.ui.dashboard.model.DashboardItemViewSettings;
import org.jkiss.utils.CommonUtils;

public class DashboardRendererBrowser
extends DashboardRendererAbstract {
    @Override
    public Composite createDashboard(@NotNull Composite composite, @NotNull DashboardItemContainer container, @NotNull DashboardContainer viewContainer, @NotNull Point preferredSize) {
        DashboardBrowserComposite browserComposite = new DashboardBrowserComposite(container, viewContainer, composite, 0, preferredSize);
        return browserComposite;
    }

    @Override
    public void fillDashboardToolbar(final @NotNull DashboardItemContainer itemContainer, @NotNull IContributionManager manager, @NotNull Composite chartComposite, final @NotNull DashboardItemViewSettings dashboardConfig) {
        manager.add((IAction)new Action(this, "Open in external browser", DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.LINK)){

            public void run() {
                DashboardItemConfiguration dashboard = dashboardConfig.getItemConfiguration();
                if (dashboard != null) {
                    String url = dashboard.getDashboardExternalURL();
                    if (CommonUtils.isEmpty((String)url)) {
                        url = dashboard.getDashboardURL();
                    }
                    if (CommonUtils.isEmpty((String)url)) {
                        return;
                    }
                    ShellUtils.launchProgram((String)dashboard.evaluateURL(url, itemContainer.getProject(), itemContainer.getDataSourceContainer()));
                }
            }
        });
        super.fillDashboardToolbar(itemContainer, manager, chartComposite, dashboardConfig);
    }

    @Override
    public void updateDashboardData(@NotNull DashboardItemContainer container, @Nullable Date lastUpdateTime, @NotNull DashboardDataset dataset) {
    }

    @Override
    public void resetDashboardData(@NotNull DashboardItemContainer dashboardItem, Date lastUpdateTime) {
    }

    @Override
    public void moveDashboardView(@NotNull DashboardViewItem toItem, @NotNull DashboardViewItem fromItem, boolean clearOriginal) {
    }

    @Override
    public void updateDashboardView(@NotNull DashboardViewItem dashboardItem) {
    }

    @Override
    public void disposeDashboard(@NotNull DashboardItemContainer container) {
    }

    protected DashboardBrowserComposite getBrowserComposite(DashboardItemContainer container) {
        return (DashboardBrowserComposite)container.getDashboardControl();
    }

    @Override
    protected void refreshChart(DashboardItemContainer itemContainer, Composite chartComposite, DashboardItemViewSettings dashboardConfig) {
        if (chartComposite instanceof DashboardBrowserComposite) {
            DashboardBrowserComposite bc = (DashboardBrowserComposite)chartComposite;
            DashboardItemConfiguration dashboard = dashboardConfig.getItemConfiguration();
            if (dashboard != null) {
                bc.getBrowser().setUrl(dashboard.evaluateURL(dashboard.getDashboardURL(), itemContainer.getProject(), itemContainer.getDataSourceContainer()));
                itemContainer.refreshInfo();
            }
        }
    }
}

