﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/securityhub/SecurityHub_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace SecurityHub {
namespace Model {

/**
 * <p>Information about the status of a read replica.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/AwsRdsDbStatusInfo">AWS
 * API Reference</a></p>
 */
class AwsRdsDbStatusInfo {
 public:
  AWS_SECURITYHUB_API AwsRdsDbStatusInfo() = default;
  AWS_SECURITYHUB_API AwsRdsDbStatusInfo(Aws::Utils::Json::JsonView jsonValue);
  AWS_SECURITYHUB_API AwsRdsDbStatusInfo& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_SECURITYHUB_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The type of status. For a read replica, the status type is read
   * replication.</p>
   */
  inline const Aws::String& GetStatusType() const { return m_statusType; }
  inline bool StatusTypeHasBeenSet() const { return m_statusTypeHasBeenSet; }
  template <typename StatusTypeT = Aws::String>
  void SetStatusType(StatusTypeT&& value) {
    m_statusTypeHasBeenSet = true;
    m_statusType = std::forward<StatusTypeT>(value);
  }
  template <typename StatusTypeT = Aws::String>
  AwsRdsDbStatusInfo& WithStatusType(StatusTypeT&& value) {
    SetStatusType(std::forward<StatusTypeT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Whether the read replica instance is operating normally.</p>
   */
  inline bool GetNormal() const { return m_normal; }
  inline bool NormalHasBeenSet() const { return m_normalHasBeenSet; }
  inline void SetNormal(bool value) {
    m_normalHasBeenSet = true;
    m_normal = value;
  }
  inline AwsRdsDbStatusInfo& WithNormal(bool value) {
    SetNormal(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The status of the read replica instance.</p>
   */
  inline const Aws::String& GetStatus() const { return m_status; }
  inline bool StatusHasBeenSet() const { return m_statusHasBeenSet; }
  template <typename StatusT = Aws::String>
  void SetStatus(StatusT&& value) {
    m_statusHasBeenSet = true;
    m_status = std::forward<StatusT>(value);
  }
  template <typename StatusT = Aws::String>
  AwsRdsDbStatusInfo& WithStatus(StatusT&& value) {
    SetStatus(std::forward<StatusT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>If the read replica is currently in an error state, provides the error
   * details.</p>
   */
  inline const Aws::String& GetMessage() const { return m_message; }
  inline bool MessageHasBeenSet() const { return m_messageHasBeenSet; }
  template <typename MessageT = Aws::String>
  void SetMessage(MessageT&& value) {
    m_messageHasBeenSet = true;
    m_message = std::forward<MessageT>(value);
  }
  template <typename MessageT = Aws::String>
  AwsRdsDbStatusInfo& WithMessage(MessageT&& value) {
    SetMessage(std::forward<MessageT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_statusType;

  bool m_normal{false};

  Aws::String m_status;

  Aws::String m_message;
  bool m_statusTypeHasBeenSet = false;
  bool m_normalHasBeenSet = false;
  bool m_statusHasBeenSet = false;
  bool m_messageHasBeenSet = false;
};

}  // namespace Model
}  // namespace SecurityHub
}  // namespace Aws
