﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/glue/Glue_EXPORTS.h>

namespace Aws {
namespace Glue {
namespace Model {
enum class PrincipalType { NOT_SET, USER, ROLE, GROUP };

namespace PrincipalTypeMapper {
AWS_GLUE_API PrincipalType GetPrincipalTypeForName(const Aws::String& name);

AWS_GLUE_API Aws::String GetNameForPrincipalType(PrincipalType value);
}  // namespace PrincipalTypeMapper
}  // namespace Model
}  // namespace Glue
}  // namespace Aws
