# SPDX-License-Identifier: GPL-3.0-or-later
# SPDX-FileCopyrightText: Copyright 2023-2025 kramo

"""The Showtime video player."""

import platform
from logging import getLogger
from pathlib import Path

from gi.repository import Gio, GLib

APP_ID = "org.gnome.Showtime"
VERSION = "50.rc"
PREFIX = "/org/gnome/Showtime"
PROFILE = "release"

system = platform.system()

app = None
logger = getLogger("showtime")

schema = Gio.Settings.new(APP_ID)
state_settings = Gio.Settings.new(APP_ID + ".State")

state_path = Path(GLib.get_user_state_dir(), "showtime")
state_path.mkdir(parents=True, exist_ok=True)
log_file = state_path / "showtime.log"

end_timestamp_type = state_settings.get_enum("end-timestamp-type")
