/*
 * Decompiled with CFR 0.152.
 */
package org.virtualbox_7_2;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

class VBoxTLSSocketFactory
extends SSLSocketFactory {
    private final SSLSocketFactory sf;

    private void setupSocket(SSLSocket sSLSocket) {
        String[] stringArray = sSLSocket.getEnabledProtocols();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].toUpperCase().startsWith("TLS")) continue;
            arrayList.add(stringArray[i]);
        }
        String[] stringArray2 = arrayList.toArray(new String[arrayList.size()]);
        sSLSocket.setEnabledProtocols(stringArray2);
    }

    public VBoxTLSSocketFactory() {
        SSLSocketFactory sSLSocketFactory = null;
        try {
            SSLContext sSLContext = SSLContext.getInstance("TLS");
            sSLContext.init(null, null, null);
            sSLSocketFactory = sSLContext.getSocketFactory();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.sf = sSLSocketFactory;
    }

    public static SocketFactory getDefault() {
        return new VBoxTLSSocketFactory();
    }

    public Socket createSocket(Socket socket, String string, int n, boolean bl) throws IOException, UnknownHostException {
        SSLSocket sSLSocket = (SSLSocket)this.sf.createSocket(socket, string, n, bl);
        this.setupSocket(sSLSocket);
        return sSLSocket;
    }

    public Socket createSocket() throws IOException {
        SSLSocket sSLSocket = (SSLSocket)this.sf.createSocket();
        this.setupSocket(sSLSocket);
        return sSLSocket;
    }

    public Socket createSocket(InetAddress inetAddress, int n) throws IOException {
        SSLSocket sSLSocket = (SSLSocket)this.sf.createSocket(inetAddress, n);
        this.setupSocket(sSLSocket);
        return sSLSocket;
    }

    public Socket createSocket(InetAddress inetAddress, int n, InetAddress inetAddress2, int n2) throws IOException {
        SSLSocket sSLSocket = (SSLSocket)this.sf.createSocket(inetAddress, n, inetAddress2, n2);
        this.setupSocket(sSLSocket);
        return sSLSocket;
    }

    public Socket createSocket(String string, int n) throws IOException, UnknownHostException {
        SSLSocket sSLSocket = (SSLSocket)this.sf.createSocket(string, n);
        this.setupSocket(sSLSocket);
        return sSLSocket;
    }

    public Socket createSocket(String string, int n, InetAddress inetAddress, int n2) throws IOException, UnknownHostException {
        SSLSocket sSLSocket = (SSLSocket)this.sf.createSocket(string, n, inetAddress, n2);
        this.setupSocket(sSLSocket);
        return sSLSocket;
    }

    public String[] getDefaultCipherSuites() {
        return this.sf.getDefaultCipherSuites();
    }

    public String[] getSupportedCipherSuites() {
        return this.sf.getSupportedCipherSuites();
    }
}

