/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.primitives;

import com.dickimawbooks.texparserlib.CatCodeChanger;
import com.dickimawbooks.texparserlib.CharObject;
import com.dickimawbooks.texparserlib.ControlSequence;
import com.dickimawbooks.texparserlib.InternalQuantity;
import com.dickimawbooks.texparserlib.NumericExpansion;
import com.dickimawbooks.texparserlib.Numerical;
import com.dickimawbooks.texparserlib.TeXNumber;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXSyntaxException;
import com.dickimawbooks.texparserlib.UserNumber;
import com.dickimawbooks.texparserlib.generic.GobbleNumber;
import com.dickimawbooks.texparserlib.primitives.Primitive;
import java.io.IOException;

public class CatCodeCs
extends Primitive
implements CatCodeChanger,
NumericExpansion,
InternalQuantity {
    public CatCodeCs() {
        this("catcode");
    }

    public CatCodeCs(String string) {
        super(string, true);
    }

    @Override
    public Object clone() {
        return new CatCodeCs(this.getName());
    }

    @Override
    public void setQuantity(TeXParser teXParser, TeXObject teXObject) throws TeXSyntaxException {
    }

    @Override
    public TeXObject getQuantity(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        return this.expandToNumber(teXParser, teXObjectList);
    }

    @Override
    public TeXNumber expandToNumber(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        Numerical numerical = teXObjectList.popNumerical(teXParser);
        return new UserNumber(teXParser.getCatCode(numerical.number(teXParser)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void applyCatCodeChange(TeXParser teXParser) throws IOException {
        Numerical numerical = teXParser.popNumerical();
        TeXObject teXObject = teXParser.peekStack();
        teXObject = teXObject instanceof CharObject && ((CharObject)teXObject).getCharCode() == 61 ? teXParser.popToken() : null;
        try {
            Numerical numerical2 = teXParser.popNumerical();
            teXParser.push(numerical2);
            teXParser.setCatCode(true, numerical.number(teXParser), numerical2.number(teXParser));
        }
        catch (TeXSyntaxException teXSyntaxException) {
        }
        finally {
            if (teXObject != null) {
                teXParser.push(teXObject);
            }
            teXParser.push(numerical);
        }
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        Numerical numerical = teXObjectList.popNumerical(teXParser);
        int n = numerical.number(teXParser);
        TeXObject teXObject = teXObjectList.peekStack();
        if (teXObject instanceof CharObject && ((CharObject)teXObject).getCharCode() == 61) {
            teXObjectList.popToken();
        }
        Numerical numerical2 = teXObjectList.popNumerical(teXParser);
        int n2 = numerical2.number(teXParser);
        teXParser.setCatCode(true, n, n2);
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        Numerical numerical = teXParser.popNumerical();
        int n = numerical.number(teXParser);
        TeXObject teXObject = teXParser.peekStack();
        if (teXObject instanceof CharObject && ((CharObject)teXObject).getCharCode() == 61) {
            teXParser.popToken();
        }
        Numerical numerical2 = teXParser.popNumerical();
        int n2 = numerical2.number(teXParser);
        teXParser.setCatCode(true, n, n2);
    }

    @Override
    public ControlSequence getNoOpCommand() {
        return new GobbleNumber(this.getName(), true);
    }
}

