/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.html;

import com.dickimawbooks.texparserlib.EndDeclaration;
import com.dickimawbooks.texparserlib.Expandable;
import com.dickimawbooks.texparserlib.Group;
import com.dickimawbooks.texparserlib.TeXMode;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXParserUtils;
import com.dickimawbooks.texparserlib.html.EndElement;
import com.dickimawbooks.texparserlib.html.HtmlTag;
import com.dickimawbooks.texparserlib.html.L2HConverter;
import com.dickimawbooks.texparserlib.html.StartElement;
import com.dickimawbooks.texparserlib.latex.End;
import com.dickimawbooks.texparserlib.latex.Label;
import com.dickimawbooks.texparserlib.latex.MathDeclaration;
import java.io.IOException;

public class L2HMathDeclaration
extends MathDeclaration {
    public L2HMathDeclaration() {
    }

    public L2HMathDeclaration(String string) {
        super(string);
    }

    @Deprecated
    public L2HMathDeclaration(String string, int n) {
        super(string, n);
    }

    @Deprecated
    public L2HMathDeclaration(String string, int n, boolean bl) {
        super(string, n, bl);
    }

    public L2HMathDeclaration(String string, TeXMode teXMode) {
        super(string, teXMode);
    }

    public L2HMathDeclaration(String string, TeXMode teXMode, boolean bl) {
        super(string, teXMode, bl);
    }

    @Override
    public Object clone() {
        return new L2HMathDeclaration(this.getName(), this.getMode(), this.isNumbered());
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        TeXObject teXObject;
        super.process(teXParser, teXObjectList);
        L2HConverter l2HConverter = (L2HConverter)teXParser.getListener();
        String string = null;
        if (this.isNumbered()) {
            teXObject = new TeXObjectList();
            while (!teXObjectList.isEmpty()) {
                TeXObject teXObject2;
                TeXObject teXObject3 = teXObjectList.popStack(teXParser);
                if ((teXObject3 = TeXParserUtils.resolve(teXObject3, teXParser)) instanceof Label) {
                    string = this.popLabelString(teXParser, teXObjectList);
                    break;
                }
                if (teXObject3.canExpand() && teXObject3 instanceof Expandable && (teXObject2 = ((Expandable)((Object)teXObject3)).expandonce(teXParser, teXObjectList)) != null) {
                    teXObject3 = teXObject2;
                }
                if (teXObject3 instanceof TeXObjectList) {
                    teXObjectList.push(teXObject3, true);
                    teXObject3 = teXObjectList.popStack(teXParser);
                }
                if ((teXObject3 = TeXParserUtils.resolve(teXObject3, teXParser)) instanceof End) {
                    teXObject2 = teXObjectList.peekStack();
                    if (teXObject2 instanceof Group) {
                        teXObject2 = ((Group)teXObject2).toList();
                    }
                    if (this.getName().equals(teXObject2.toString(teXParser))) {
                        ((TeXObjectList)teXObject).add(teXObject3);
                        break;
                    }
                } else if (teXObject3 instanceof EndDeclaration) {
                    if (((EndDeclaration)teXObject3).getDeclarationName().equals(this.getName())) {
                        ((TeXObjectList)teXObject).add(teXObject3);
                        break;
                    }
                } else if (teXObject3 instanceof Label) {
                    string = this.popLabelString(teXParser, teXObjectList);
                    break;
                }
                ((TeXObjectList)teXObject).add(teXObject3);
            }
            teXObjectList.push(teXObject, true);
        }
        if (l2HConverter.useMathJax()) {
            if (this.getMode() == TeXMode.DISPLAY_MATH) {
                teXObjectList.push(new HtmlTag(l2HConverter.mathJaxStartDisplay()));
            } else {
                teXObjectList.push(new HtmlTag(l2HConverter.mathJaxStartInline()));
            }
        }
        if (this.isNumbered()) {
            teXObjectList.push(new EndElement("span"));
            teXObjectList.push(l2HConverter.getOther(41));
            teXObjectList.push(l2HConverter.getControlSequence("theequation"));
            teXObjectList.push(l2HConverter.getOther(40));
            teXObject = new StartElement("span");
            ((StartElement)teXObject).putAttribute("class", "eqno");
            teXObjectList.push(teXObject);
        }
        if (this.getMode() == TeXMode.DISPLAY_MATH) {
            if (string == null) {
                l2HConverter.writeliteral("<div class=\"displaymath\">");
            } else {
                l2HConverter.writeliteral(String.format("<div class=\"displaymath\" id=\"%s\">", string));
            }
        }
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        super.process(teXParser);
        L2HConverter l2HConverter = (L2HConverter)teXParser.getListener();
        String string = null;
        if (this.isNumbered()) {
            TeXObjectList teXObjectList = new TeXObjectList();
            while (true) {
                TeXObject teXObject;
                TeXObject teXObject2 = teXParser.popStack();
                if ((teXObject2 = TeXParserUtils.resolve(teXObject2, teXParser)) instanceof Label) {
                    string = this.popLabelString(teXParser, teXParser);
                    break;
                }
                if (teXObject2.canExpand() && teXObject2 instanceof Expandable && (teXObject = ((Expandable)((Object)teXObject2)).expandonce(teXParser)) != null) {
                    teXObject2 = teXObject;
                }
                if (teXObject2 instanceof TeXObjectList) {
                    teXParser.push(teXObject2, true);
                    teXObject2 = teXParser.popStack();
                }
                if ((teXObject2 = TeXParserUtils.resolve(teXObject2, teXParser)) instanceof End) {
                    teXObject = teXParser.peekStack();
                    if (teXObject instanceof Group) {
                        teXObject = ((Group)teXObject).toList();
                    }
                    if (this.getName().equals(teXObject.toString(teXParser))) {
                        teXObjectList.add(teXObject2);
                        break;
                    }
                } else if (teXObject2 instanceof EndDeclaration) {
                    if (((EndDeclaration)teXObject2).getDeclarationName().equals(this.getName())) {
                        teXObjectList.add(teXObject2);
                        break;
                    }
                } else if (teXObject2 instanceof Label) {
                    string = this.popLabelString(teXParser, teXParser);
                    break;
                }
                teXObjectList.add(teXObject2);
            }
            teXParser.push(teXObjectList, true);
        }
        if (l2HConverter.useMathJax()) {
            if (this.getMode() == TeXMode.DISPLAY_MATH) {
                teXParser.push(new HtmlTag(l2HConverter.mathJaxStartDisplay()));
            } else {
                teXParser.push(new HtmlTag(l2HConverter.mathJaxStartInline()));
            }
        }
        if (this.isNumbered()) {
            teXParser.push(new HtmlTag("</span>"));
            teXParser.push(l2HConverter.getOther(41));
            teXParser.push(l2HConverter.getControlSequence("theequation"));
            teXParser.push(l2HConverter.getOther(40));
            teXParser.push(new HtmlTag("<span class=\"eqno\">"));
        }
        if (this.getMode() == TeXMode.DISPLAY_MATH) {
            if (string == null) {
                l2HConverter.writeliteral("<div class=\"displaymath\">");
            } else {
                l2HConverter.writeliteral(String.format("<div class=\"displaymath\" id=\"%s\">", string));
            }
        }
    }

    @Override
    public void end(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        super.end(teXParser, teXObjectList);
        L2HConverter l2HConverter = (L2HConverter)teXParser.getListener();
        if (l2HConverter.useMathJax()) {
            if (this.getMode() == TeXMode.DISPLAY_MATH) {
                l2HConverter.writeliteral(l2HConverter.mathJaxEndDisplay());
            } else {
                l2HConverter.writeliteral(l2HConverter.mathJaxEndInline());
            }
        }
        if (this.getMode() == TeXMode.DISPLAY_MATH) {
            l2HConverter.writeliteral("</div>");
        }
    }
}

