/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ebnf;

import net.sourceforge.plantuml.ebnf.ETile;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.color.HColorSet;
import net.sourceforge.plantuml.klimt.color.NoSuchColorException;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.FontConfiguration;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.shape.URectangle;
import net.sourceforge.plantuml.klimt.shape.UText;
import net.sourceforge.plantuml.style.ISkinParam;

public class ETileNamedGroup
extends ETile {
    private final ETile orig;
    private final ISkinParam skinParam;
    private String commentAbove;
    private String commentBelow;
    private final HColorSet colorSet;
    private final double deltax = 10.0;
    private final double deltay1 = 10.0;
    private final double deltay2 = 10.0;
    private final UText groupName;
    private final FontConfiguration fc;

    public ETileNamedGroup(ETile orig, FontConfiguration fc, HColorSet colorSet, ISkinParam skinParam, String name) {
        this.skinParam = skinParam;
        this.orig = orig;
        this.fc = fc;
        this.colorSet = colorSet;
        this.groupName = UText.build(name, fc);
    }

    @Override
    public double getH1(StringBounder stringBounder) {
        return 10.0 + this.orig.getH1(stringBounder);
    }

    @Override
    public double getH2(StringBounder stringBounder) {
        return this.orig.getH2(stringBounder) + 10.0;
    }

    @Override
    public double getWidth(StringBounder stringBounder) {
        return this.orig.getWidth(stringBounder) + 20.0;
    }

    @Override
    public void drawU(UGraphic ug) {
        StringBounder stringBounder = ug.getStringBounder();
        XDimension2D dim = this.calculateDimension(stringBounder);
        try {
            HColor background = this.colorSet.getColor("#E8E8FF");
            UGraphic ugBack = ug.apply(background).apply(background.bg());
            ugBack.draw(URectangle.build(dim));
            XDimension2D dimText = stringBounder.calculateDimension(this.fc.getFont(), this.groupName.getText());
            ugBack.apply(UTranslate.dy(-dimText.getHeight())).draw(URectangle.build(dimText.delta(10.0, 0.0)));
        }
        catch (NoSuchColorException e) {
            e.printStackTrace();
        }
        double linePos = this.getH1(stringBounder);
        this.drawHline(ug, linePos, 0.0, 10.0);
        this.drawHline(ug, linePos, dim.getWidth() - 10.0, dim.getWidth());
        this.orig.drawU(ug.apply(new UTranslate(10.0, 10.0)));
        ug.apply(UTranslate.dx(5.0)).draw(this.groupName);
    }

    @Override
    public void push(ETile tile) {
        throw new UnsupportedOperationException();
    }
}

