<p align="center">
<a href="https://pdoc.dev/"><img alt="pdoc" src="https://pdoc.dev/logo.svg" width="200" height="100" /></a>
<br><br>
<a href="https://pdoc.dev/docs/pdoc.html"><img height="20" alt="pdoc documentation" src="https://shields.mitmproxy.org/badge/docs-pdoc.dev-brightgreen.svg?logo=data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHdpZHRoPSIxOTIiIGhlaWdodD0iMTkyIj48cGF0aCBkPSJNNjcuODA3IDIzLjI0NGMtMTguMDMyIDUuNTIzLTI0LjI3MyA5LjQxMS0zMy4xOTMgMTYuMTY5UzE5LjQwNyA1MS4xMjUgOS4zNCA2OS43NkMzLjI3IDgwLjk5Ni44MjcgOTkuMjcxIDEgMTExLjY3OWMuMTE0IDguMTY5IDIuMTg4IDEzLjU1OSAyLjE4OCAxMy41NTlTNDIuMzI2IDI0Ny4yNyAyMC40MzUgMjc4LjEwNWMtMTAuNDg4IDE0Ljc3MyA4NC40MjIgMjcuMDA3IDgwLjA0NyAxMC40NS0xMC4zOTctMzkuMzQ4LTI3LjU5NS05Ny40MDktMzEuOTA4LTExMy42NjctMy4wNDctMTEuNDg0IDguMTYtMjEuOTk1IDE2LjI5NS0yNy4zNDMgMy4zODMtMi4yMjQgOC4wNTEtMy43ODYgOC4wNTEtMy43ODZsNTEuOTI0LTE1LjU5NXMyMy44MDktOC41NzkgMzQuMDYyLTI2LjU2NyAxMi42ODktMzcuNTg0IDEyLjY4OS0zNy41ODQuNDk1LTE2LjU4OC01LjkzOS0yMy4xNC0yLjczMi01Ljg2Ni0xOC42NDYtMTIuNDk4LTQ5LjEyMi0xMC4wNTMtNDkuMTIyLTEwLjA1My0zMi4wNDktLjYwMi01MC4wODEgNC45MjF6IiBmaWxsPSIjMjBhZDZjIi8+PGcgdHJhbnNmb3JtPSJyb3RhdGUoMzQzLjk5MykiPjxlbGxpcHNlIGN4PSI1Mi4yNzYiIGN5PSI5NC4wODkiIGZpbGw9IiNmZmYiIHJ4PSIyNy44NTIiIHJ5PSIyNy44MjMiLz48ZWxsaXBzZSBjeD0iNTIuNTM4IiBjeT0iOTQuNjg5IiByeD0iMTguNjg4IiByeT0iMTguMzMxIiBmaWxsPSIjMTA1YTQ4Ii8+PGVsbGlwc2UgY3g9IjYzLjMzMyIgY3k9Ijg2LjMiIGZpbGw9IiNmZmYiIHJ4PSI3LjU5NiIgcnk9IjcuNTg4Ii8+PC9nPjxnIGZpbGw9IiMxMDVhNDgiPjxlbGxpcHNlIGN4PSI5NC4xNTQiIGN5PSIxMzUuNzM0IiByeD0iNC41MDUiIHJ5PSI1LjI1NyIgdHJhbnNmb3JtPSJyb3RhdGUoMzI1LjAxNSkiLz48ZWxsaXBzZSBjeD0iMTY3Ljg2IiBjeT0iNTYuOTUxIiByeD0iNC40ODQiIHJ5PSI1LjIzMSIgdHJhbnNmb3JtPSJyb3RhdGUoMzU4Ljc3OSkiLz48L2c+PHBhdGggZD0iTTE4OC45NjIgNzcuNDU4bC0zNC4yNDggMTAuMTcxYy02Ljg3OCAxLjk3My05Ljk3NCAzLjM4OC0xNC44ODggMy42NnMtMTAuODY4LTEuODY5LTEwLjg2OC0xLjg2OWwtMi4zNDIgOC42MzNjMi4xOTcuOTQ0IDkuOTY5IDIuMzkgMTQuNzU2IDIuNTkyczE1LjU4Mi0yLjQ2IDE1LjU4Mi0yLjQ2bDI3LjQ3MS03LjUzNGMxLjk1MS00LjcwOSAzLjQzMi05LjIzOCA0LjUzNy0xMy4xOTN6IiBmaWxsPSIjZTc4MzYxIi8+PC9zdmc+"></a>
<a href="https://github.com/mitmproxy/pdoc/actions"><img height="20" alt="CI Status" src="https://shields.mitmproxy.org/github/actions/workflow/status/mitmproxy/pdoc/main.yml?label=CI&logo=github"></a>
<img height="20" alt="Code Coverage" src="https://shields.mitmproxy.org/badge/coverage-100%25-brightgreen">
<a href="https://autofix.ci"><img height="20" alt="autofix.ci: yes" src="https://shields.mitmproxy.org/badge/autofix.ci-yes-success?logo=data:image/svg+xml;base64,PHN2ZyBmaWxsPSIjZmZmIiB2aWV3Qm94PSIwIDAgMTI4IDEyOCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj48cGF0aCB0cmFuc2Zvcm09InNjYWxlKDAuMDYxLC0wLjA2MSkgdHJhbnNsYXRlKC0yNTAsLTE3NTApIiBkPSJNMTMyNSAtMzQwcS0xMTUgMCAtMTY0LjUgMzIuNXQtNDkuNSAxMTQuNXEwIDMyIDUgNzAuNXQxMC41IDcyLjV0NS41IDU0djIyMHEtMzQgLTkgLTY5LjUgLTE0dC03MS41IC01cS0xMzYgMCAtMjUxLjUgNjJ0LTE5MSAxNjl0LTkyLjUgMjQxcS05MCAxMjAgLTkwIDI2NnEwIDEwOCA0OC41IDIwMC41dDEzMiAxNTUuNXQxODguNSA4MXExNSA5OSAxMDAuNSAxODAuNXQyMTcgMTMwLjV0MjgyLjUgNDlxMTM2IDAgMjU2LjUgLTQ2IHQyMDkgLTEyNy41dDEyOC41IC0xODkuNXExNDkgLTgyIDIyNyAtMjEzLjV0NzggLTI5OS41cTAgLTEzNiAtNTggLTI0NnQtMTY1LjUgLTE4NC41dC0yNTYuNSAtMTAzLjVsLTI0MyAtMzAwdi01MnEwIC0yNyAzLjUgLTU2LjV0Ni41IC01Ny41dDMgLTUycTAgLTg1IC00MS41IC0xMTguNXQtMTU3LjUgLTMzLjV6TTEzMjUgLTI2MHE3NyAwIDk4IDE0LjV0MjEgNTcuNXEwIDI5IC0zIDY4dC02LjUgNzN0LTMuNSA0OHY2NGwyMDcgMjQ5IHEtMzEgMCAtNjAgNS41dC01NCAxMi41bC0xMDQgLTEyM3EtMSAzNCAtMiA2My41dC0xIDU0LjVxMCA2OSA5IDEyM2wzMSAyMDBsLTExNSAtMjhsLTQ2IC0yNzFsLTIwNSAyMjZxLTE5IC0xNSAtNDMgLTI4LjV0LTU1IC0yNi41bDIxOSAtMjQydi0yNzZxMCAtMjAgLTUuNSAtNjB0LTEwLjUgLTc5dC01IC01OHEwIC00MCAzMCAtNTMuNXQxMDQgLTEzLjV6TTEyNjIgNjE2cS0xMTkgMCAtMjI5LjUgMzQuNXQtMTkzLjUgOTYuNWw0OCA2NCBxNzMgLTU1IDE3MC41IC04NXQyMDQuNSAtMzBxMTM3IDAgMjQ5IDQ1LjV0MTc5IDEyMXQ2NyAxNjUuNWg4MHEwIC0xMTQgLTc3LjUgLTIwNy41dC0yMDggLTE0OXQtMjg5LjUgLTU1LjV6TTgwMyA1OTVxODAgMCAxNDkgMjkuNXQxMDggNzIuNWwyMjEgLTY3bDMwOSA4NnE0NyAtMzIgMTA0LjUgLTUwdDExNy41IC0xOHE5MSAwIDE2NSAzOHQxMTguNSAxMDMuNXQ0NC41IDE0Ni41cTAgNzYgLTM0LjUgMTQ5dC05NS41IDEzNHQtMTQzIDk5IHEtMzcgMTA3IC0xMTUuNSAxODMuNXQtMTg2IDExNy41dC0yMzAuNSA0MXEtMTAzIDAgLTE5Ny41IC0yNnQtMTY5IC03Mi41dC0xMTcuNSAtMTA4dC00MyAtMTMxLjVxMCAtMzQgMTQuNSAtNjIuNXQ0MC41IC01MC41bC01NSAtNTlxLTM0IDI5IC01NCA2NS41dC0yNSA4MS41cS04MSAtMTggLTE0NSAtNzB0LTEwMSAtMTI1LjV0LTM3IC0xNTguNXEwIC0xMDIgNDguNSAtMTgwLjV0MTI5LjUgLTEyM3QxNzkgLTQ0LjV6Ii8+PC9zdmc+"></a>
<a href="https://pypi.python.org/pypi/pdoc"><img height="20" alt="PyPI Version" src="https://shields.mitmproxy.org/pypi/v/pdoc.svg"></a>
<img height="20" alt="Supported Python Versions" src="https://shields.mitmproxy.org/pypi/pyversions/pdoc.svg">
</p>

API Documentation for Python Projects.


# Example

`pdoc -o ./html pdoc` generates this website: [pdoc.dev/docs](https://pdoc.dev/docs/pdoc.html).

# Installation
```shell
pip install pdoc
```

pdoc is compatible with Python 3.10 and newer.


# Usage

```shell
pdoc your_python_module
# or
pdoc ./my_project.py
```

Run `pdoc pdoc` to see pdoc's own documentation, 
run `pdoc --help` to view the command line flags, 
or check our [hosted copy of the documentation](https://pdoc.dev/docs/pdoc.html).


# Features

pdoc's main feature is a focus on simplicity: pdoc aims to do one thing and do it well.  


* Documentation is plain [Markdown](https://pdoc.dev/docs/pdoc.html#markdown-support).
* First-class support for type annotations and all other modern Python 3 features.
* Builtin web server with live reloading.
* Customizable HTML templates.
* Understands numpydoc and Google-style docstrings.
* Standalone HTML output without additional dependencies.
  
Under the hood...

* `pdoc` will automatically link identifiers in your docstrings to their corresponding documentation.
* `pdoc` respects your `__all__` variable when present.
* `pdoc` will traverse the abstract syntax tree to extract type annotations and docstrings from constructors as well.
* `pdoc` will automatically try to resolve type annotation string literals as forward references.
* `pdoc` will use inheritance to resolve type annotations and docstrings for class members. 
  
If you have substantially more complex documentation needs, we recommend using [Sphinx](https://www.sphinx-doc.org/)!


## Contributing

As an open source project, pdoc welcomes contributions of all forms.

[![Dev Guide](https://shields.mitmproxy.org/badge/dev_docs-CONTRIBUTING.md-blue)](https://github.com/mitmproxy/pdoc/blob/main/CONTRIBUTING.md)


## pdoc vs. pdoc3

This project is not associated with "pdoc3", which often falsely assumes our name.
Quoting [@BurntSushi](https://github.com/BurntSushi), the original author of pdoc:

> I'm pretty disgusted that someone has taken a project I built, relicensed it, 
> [attempted to erase its entry on the Python Wiki](https://wiki.python.org/moin/DocumentationTools?action=diff&rev1=36&rev2=37), 
> released it under effectively the same name and, worst of all, associated it with Nazi symbols.
> 
> *Source: https://github.com/pdoc3/pdoc/issues/64*

In contrast, the pdoc project strives to uphold a healthy community where everyone is treated with respect.
Everyone is welcome to contribute as long as they adhere to basic civility. We expressly distance ourselves from the use
of Nazi symbols and ideology.

----

The pdoc project was originally created by [Andrew Gallant](https://github.com/BurntSushi) 
and is currently maintained by [Maximilian Hils](https://github.com/mhils).
