/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticmapreduce.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.elasticmapreduce.model.EbsVolume;

@SdkInternalApi
public class EbsVolumeMarshaller {
    private static final MarshallingInfo<String> DEVICE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Device").build();
    private static final MarshallingInfo<String> VOLUMEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("VolumeId").build();
    private static final EbsVolumeMarshaller instance = new EbsVolumeMarshaller();

    public static EbsVolumeMarshaller getInstance() {
        return instance;
    }

    public void marshall(EbsVolume ebsVolume, ProtocolMarshaller protocolMarshaller) {
        if (ebsVolume == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)ebsVolume.getDevice(), DEVICE_BINDING);
            protocolMarshaller.marshall((Object)ebsVolume.getVolumeId(), VOLUMEID_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

