/*
 * Decompiled with CFR 0.152.
 */
package org.cryptacular.bean;

import java.security.KeyStore;
import org.bouncycastle.crypto.BufferedBlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.cryptacular.CiphertextHeader;
import org.cryptacular.CryptUtil;
import org.cryptacular.adapter.BufferedBlockCipherAdapter;
import org.cryptacular.bean.AbstractBlockCipherBean;
import org.cryptacular.generator.Nonce;
import org.cryptacular.spec.Spec;

public class BufferedBlockCipherBean
extends AbstractBlockCipherBean {
    private final Spec<BufferedBlockCipher> blockCipherSpec;

    public BufferedBlockCipherBean(Spec<BufferedBlockCipher> blockCipherSpec, KeyStore keyStore, String keyAlias, String keyPassword, Nonce nonce) {
        super(keyStore, keyAlias, keyPassword, nonce);
        this.blockCipherSpec = CryptUtil.assertNotNullArg(blockCipherSpec, "Block cipher spec cannot be null");
    }

    public Spec<BufferedBlockCipher> getBlockCipherSpec() {
        return this.blockCipherSpec;
    }

    @Override
    protected BufferedBlockCipherAdapter newCipher(CiphertextHeader header, boolean mode) {
        BufferedBlockCipher cipher = this.blockCipherSpec.newInstance();
        KeyParameter params = new KeyParameter(this.lookupKey(header.getKeyName()).getEncoded());
        String algName = cipher.getUnderlyingCipher().getAlgorithmName();
        if (algName.endsWith("CBC") || algName.endsWith("OFB") || algName.endsWith("CFB")) {
            params = new ParametersWithIV((CipherParameters)params, header.getNonce());
        }
        cipher.init(mode, (CipherParameters)params);
        return new BufferedBlockCipherAdapter(cipher);
    }
}

