/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.repositories.s3;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.Objects;
import org.opensearch.common.settings.SettingsException;
import org.opensearch.core.common.Strings;
import org.opensearch.repositories.s3.utils.Protocol;
import software.amazon.awssdk.core.exception.SdkException;

public class ProxySettings {
    public static final ProxySettings NO_PROXY_SETTINGS = new ProxySettings(ProxyType.DIRECT, null, -1, null, null);
    private final ProxyType type;
    private final String host;
    private final String username;
    private final String password;
    private final int port;

    public String getHost() {
        return this.host;
    }

    public ProxySettings(ProxyType type, String host, int port, String username, String password) {
        this.type = type;
        this.host = host;
        this.port = port;
        this.username = username;
        this.password = password;
    }

    public ProxyType getType() {
        return this.type;
    }

    public String getHostName() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public InetSocketAddress getAddress() {
        try {
            return new InetSocketAddress(InetAddress.getByName(this.host), this.port);
        }
        catch (UnknownHostException e) {
            throw SdkException.create((String)"Unknown host", (Throwable)e);
        }
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean isAuthenticated() {
        return !Strings.isNullOrEmpty((String)this.username) && !Strings.isNullOrEmpty((String)this.password);
    }

    public ProxySettings recreateWithNewHostAndPort(String host, int port) {
        return new ProxySettings(this.type, host, port, this.username, this.password);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProxySettings that = (ProxySettings)o;
        return this.port == that.port && this.type == that.type && Objects.equals(this.host, that.host) && Objects.equals(this.username, that.username) && Objects.equals(this.password, that.password);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.host, this.username, this.password, this.port});
    }

    public static enum ProxyType {
        HTTP(Protocol.HTTP.name()),
        HTTPS(Protocol.HTTPS.name()),
        SOCKS("SOCKS"),
        DIRECT("DIRECT");

        private final String name;

        private ProxyType(String name) {
            this.name = name;
        }

        public Protocol toProtocol() {
            if (this == DIRECT) {
                throw new SettingsException("Couldn't convert to S3 protocol");
            }
            if (this == SOCKS) {
                throw new SettingsException("Couldn't convert to S3 protocol. SOCKS is not supported");
            }
            return Protocol.valueOf(this.name());
        }
    }
}

