/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.commons.event_process;

import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.performanceanalyzer.commons.event_process.Event;
import org.opensearch.performanceanalyzer.commons.event_process.EventProcessor;

public class EventDispatcher {
    private static final Logger LOG = LogManager.getLogger(EventDispatcher.class);
    private List<EventProcessor> eventProcessors = new ArrayList<EventProcessor>();

    public void registerEventProcessor(EventProcessor processor) {
        this.eventProcessors.add(processor);
    }

    public void initializeProcessing(long startTime, long endTime) {
        for (EventProcessor p : this.eventProcessors) {
            p.initializeProcessing(startTime, endTime);
        }
    }

    public void finalizeProcessing() {
        for (EventProcessor p : this.eventProcessors) {
            p.finalizeProcessing();
        }
    }

    public void processEvent(Event event) {
        boolean eventProcessed = false;
        for (EventProcessor p : this.eventProcessors) {
            if (!p.shouldProcessEvent(event)) continue;
            p.processEvent(event);
            p.commitBatchIfRequired();
            eventProcessed = true;
            break;
        }
        if (!eventProcessed) {
            LOG.error("Event not processed - {}", (Object)event.key);
        }
    }
}

