/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.datamodeling.internal;

import com.amazonaws.services.dynamodbv2.datamodeling.internal.ByteBufferInputStream;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AttributeValueMarshaller {
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private static final int TRUE_FLAG = 1;
    private static final int FALSE_FLAG = 0;

    private AttributeValueMarshaller() {
    }

    /*
     * Exception decompiling
     */
    public static ByteBuffer marshall(AttributeValue attributeValue) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void marshall(AttributeValue attributeValue, DataOutputStream out) throws IOException {
        if (attributeValue.getB() != null) {
            out.writeChar(98);
            AttributeValueMarshaller.writeBytes(attributeValue.getB(), out);
        } else if (attributeValue.getBS() != null) {
            out.writeChar(66);
            AttributeValueMarshaller.writeBytesList(attributeValue.getBS(), out);
        } else if (attributeValue.getN() != null) {
            out.writeChar(110);
            AttributeValueMarshaller.writeString(AttributeValueMarshaller.trimZeros(attributeValue.getN()), out);
        } else if (attributeValue.getNS() != null) {
            out.writeChar(78);
            ArrayList<String> ns = new ArrayList<String>(attributeValue.getNS().size());
            for (String n : attributeValue.getNS()) {
                ns.add(AttributeValueMarshaller.trimZeros(n));
            }
            AttributeValueMarshaller.writeStringList(ns, out);
        } else if (attributeValue.getS() != null) {
            out.writeChar(115);
            AttributeValueMarshaller.writeString(attributeValue.getS(), out);
        } else if (attributeValue.getSS() != null) {
            out.writeChar(83);
            AttributeValueMarshaller.writeStringList(attributeValue.getSS(), out);
        } else if (attributeValue.getBOOL() != null) {
            out.writeChar(63);
            out.writeByte(attributeValue.getBOOL() != false ? 1 : 0);
        } else if (Boolean.TRUE.equals(attributeValue.getNULL())) {
            out.writeChar(0);
        } else if (attributeValue.getL() != null) {
            List l = attributeValue.getL();
            out.writeChar(76);
            out.writeInt(l.size());
            for (AttributeValue attr : l) {
                if (attr == null) {
                    throw new NullPointerException("Encountered null list entry value while marshalling attribute value " + attributeValue);
                }
                AttributeValueMarshaller.marshall(attr, out);
            }
        } else if (attributeValue.getM() != null) {
            Map m = attributeValue.getM();
            ArrayList mKeys = new ArrayList(m.keySet());
            Collections.sort(mKeys);
            out.writeChar(77);
            out.writeInt(m.size());
            for (String mKey : mKeys) {
                AttributeValueMarshaller.marshall(new AttributeValue().withS(mKey), out);
                AttributeValue mValue = (AttributeValue)m.get(mKey);
                if (mValue == null) {
                    throw new NullPointerException("Encountered null map value for key " + mKey + " while marshalling attribute value " + attributeValue);
                }
                AttributeValueMarshaller.marshall(mValue, out);
            }
        } else {
            throw new IllegalArgumentException("A seemingly empty AttributeValue is indicative of invalid input or potential errors");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static AttributeValue unmarshall(ByteBuffer plainText) {
        try (DataInputStream in = new DataInputStream(new ByteBufferInputStream(plainText.asReadOnlyBuffer()));){
            AttributeValue attributeValue = AttributeValueMarshaller.unmarshall(in);
            return attributeValue;
        }
        catch (IOException ex) {
            throw new RuntimeException("Unexpected exception", ex);
        }
    }

    private static AttributeValue unmarshall(DataInputStream in) throws IOException {
        char type = in.readChar();
        AttributeValue result = new AttributeValue();
        switch (type) {
            case '\u0000': {
                result.setNULL(Boolean.TRUE);
                break;
            }
            case 'b': {
                result.setB(AttributeValueMarshaller.readBytes(in));
                break;
            }
            case 'B': {
                result.setBS(AttributeValueMarshaller.readBytesList(in));
                break;
            }
            case 'n': {
                result.setN(AttributeValueMarshaller.readString(in));
                break;
            }
            case 'N': {
                result.setNS(AttributeValueMarshaller.readStringList(in));
                break;
            }
            case 's': {
                result.setS(AttributeValueMarshaller.readString(in));
                break;
            }
            case 'S': {
                result.setSS(AttributeValueMarshaller.readStringList(in));
                break;
            }
            case '?': {
                byte boolValue = in.readByte();
                if (boolValue == 1) {
                    result.setBOOL(Boolean.TRUE);
                    break;
                }
                if (boolValue == 0) {
                    result.setBOOL(Boolean.FALSE);
                    break;
                }
                throw new IllegalArgumentException("Improperly formatted data");
            }
            case 'L': {
                int lCount = in.readInt();
                ArrayList<AttributeValue> l = new ArrayList<AttributeValue>(lCount);
                for (int lIdx = 0; lIdx < lCount; ++lIdx) {
                    l.add(AttributeValueMarshaller.unmarshall(in));
                }
                result.setL(l);
                break;
            }
            case 'M': {
                int mCount = in.readInt();
                HashMap<String, AttributeValue> m = new HashMap<String, AttributeValue>();
                for (int mIdx = 0; mIdx < mCount; ++mIdx) {
                    AttributeValue key = AttributeValueMarshaller.unmarshall(in);
                    if (key.getS() == null) {
                        throw new IllegalArgumentException("Improperly formatted data");
                    }
                    AttributeValue value = AttributeValueMarshaller.unmarshall(in);
                    m.put(key.getS(), value);
                }
                result.setM(m);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported data encoding");
            }
        }
        return result;
    }

    private static String trimZeros(String n) {
        BigDecimal number = new BigDecimal(n);
        if (number.compareTo(BigDecimal.ZERO) == 0) {
            return "0";
        }
        return number.stripTrailingZeros().toPlainString();
    }

    private static void writeStringList(List<String> values, DataOutputStream out) throws IOException {
        ArrayList<String> sorted = new ArrayList<String>(values);
        Collections.sort(sorted);
        out.writeInt(sorted.size());
        for (String v : sorted) {
            AttributeValueMarshaller.writeString(v, out);
        }
    }

    private static List<String> readStringList(DataInputStream in) throws IOException, IllegalArgumentException {
        int nCount = in.readInt();
        ArrayList<String> ns = new ArrayList<String>(nCount);
        for (int nIdx = 0; nIdx < nCount; ++nIdx) {
            ns.add(AttributeValueMarshaller.readString(in));
        }
        return ns;
    }

    private static void writeString(String value, DataOutputStream out) throws IOException {
        byte[] bytes = value.getBytes(UTF8);
        out.writeInt(bytes.length);
        out.write(bytes);
    }

    private static String readString(DataInputStream in) throws IOException, IllegalArgumentException {
        int length = in.readInt();
        byte[] bytes = new byte[length];
        if (in.read(bytes) != length) {
            throw new IllegalArgumentException("Improperly formatted data");
        }
        String tmp = new String(bytes, UTF8);
        return tmp;
    }

    private static void writeBytesList(List<ByteBuffer> values, DataOutputStream out) throws IOException {
        ArrayList<ByteBuffer> sorted = new ArrayList<ByteBuffer>(values);
        Collections.sort(sorted);
        out.writeInt(sorted.size());
        for (ByteBuffer v : sorted) {
            AttributeValueMarshaller.writeBytes(v, out);
        }
    }

    private static List<ByteBuffer> readBytesList(DataInputStream in) throws IOException {
        int bCount = in.readInt();
        ArrayList<ByteBuffer> bs = new ArrayList<ByteBuffer>(bCount);
        for (int bIdx = 0; bIdx < bCount; ++bIdx) {
            bs.add(AttributeValueMarshaller.readBytes(in));
        }
        return bs;
    }

    private static void writeBytes(ByteBuffer value, DataOutputStream out) throws IOException {
        value = value.asReadOnlyBuffer();
        value.rewind();
        out.writeInt(value.remaining());
        while (value.hasRemaining()) {
            out.writeByte(value.get());
        }
    }

    private static ByteBuffer readBytes(DataInputStream in) throws IOException {
        int length = in.readInt();
        byte[] buf = new byte[length];
        in.readFully(buf);
        return ByteBuffer.wrap(buf);
    }
}

