/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.ingestion;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch.ingestion.IngestionStateShardFailure;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class ResumeResponse
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, ResumeResponse> {
    private final boolean acknowledged;
    @Nullable
    private final String error;
    @Nonnull
    private final List<IngestionStateShardFailure> failures;
    private final boolean shardsAcknowledged;
    public static final JsonpDeserializer<ResumeResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ResumeResponse::setupResumeResponseDeserializer);

    private ResumeResponse(Builder builder) {
        this.acknowledged = ApiTypeHelper.requireNonNull(builder.acknowledged, this, "acknowledged");
        this.error = builder.error;
        this.failures = ApiTypeHelper.unmodifiable(builder.failures);
        this.shardsAcknowledged = ApiTypeHelper.requireNonNull(builder.shardsAcknowledged, this, "shardsAcknowledged");
    }

    public static ResumeResponse of(Function<Builder, ObjectBuilder<ResumeResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final boolean acknowledged() {
        return this.acknowledged;
    }

    @Nullable
    public final String error() {
        return this.error;
    }

    @Nonnull
    public final List<IngestionStateShardFailure> failures() {
        return this.failures;
    }

    public final boolean shardsAcknowledged() {
        return this.shardsAcknowledged;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("acknowledged");
        generator.write(this.acknowledged);
        if (this.error != null) {
            generator.writeKey("error");
            generator.write(this.error);
        }
        if (ApiTypeHelper.isDefined(this.failures)) {
            generator.writeKey("failures");
            generator.writeStartArray();
            for (IngestionStateShardFailure item0 : this.failures) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeKey("shards_acknowledged");
        generator.write(this.shardsAcknowledged);
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupResumeResponseDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::acknowledged, JsonpDeserializer.booleanDeserializer(), "acknowledged");
        op.add(Builder::error, JsonpDeserializer.stringDeserializer(), "error");
        op.add(Builder::failures, JsonpDeserializer.arrayDeserializer(IngestionStateShardFailure._DESERIALIZER), "failures");
        op.add(Builder::shardsAcknowledged, JsonpDeserializer.booleanDeserializer(), "shards_acknowledged");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Boolean.hashCode(this.acknowledged);
        result = 31 * result + Objects.hashCode(this.error);
        result = 31 * result + Objects.hashCode(this.failures);
        result = 31 * result + Boolean.hashCode(this.shardsAcknowledged);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResumeResponse other = (ResumeResponse)o;
        return this.acknowledged == other.acknowledged && Objects.equals(this.error, other.error) && Objects.equals(this.failures, other.failures) && this.shardsAcknowledged == other.shardsAcknowledged;
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, ResumeResponse> {
        private Boolean acknowledged;
        @Nullable
        private String error;
        @Nullable
        private List<IngestionStateShardFailure> failures;
        private Boolean shardsAcknowledged;

        public Builder() {
        }

        private Builder(ResumeResponse o) {
            this.acknowledged = o.acknowledged;
            this.error = o.error;
            this.failures = Builder._listCopy(o.failures);
            this.shardsAcknowledged = o.shardsAcknowledged;
        }

        private Builder(Builder o) {
            this.acknowledged = o.acknowledged;
            this.error = o.error;
            this.failures = Builder._listCopy(o.failures);
            this.shardsAcknowledged = o.shardsAcknowledged;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder acknowledged(boolean value) {
            this.acknowledged = value;
            return this;
        }

        @Nonnull
        public final Builder error(@Nullable String value) {
            this.error = value;
            return this;
        }

        @Nonnull
        public final Builder failures(List<IngestionStateShardFailure> list) {
            this.failures = Builder._listAddAll(this.failures, list);
            return this;
        }

        @Nonnull
        public final Builder failures(IngestionStateShardFailure value, IngestionStateShardFailure ... values) {
            this.failures = Builder._listAdd(this.failures, value, values);
            return this;
        }

        @Nonnull
        public final Builder failures(Function<IngestionStateShardFailure.Builder, ObjectBuilder<IngestionStateShardFailure>> fn) {
            return this.failures(fn.apply(new IngestionStateShardFailure.Builder()).build(), new IngestionStateShardFailure[0]);
        }

        @Nonnull
        public final Builder shardsAcknowledged(boolean value) {
            this.shardsAcknowledged = value;
            return this;
        }

        @Override
        @Nonnull
        public ResumeResponse build() {
            this._checkSingleUse();
            return new ResumeResponse(this);
        }
    }
}

