/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.aggregations;

import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.opensearch.client.json.ExternallyTaggedUnion;
import org.opensearch.client.json.JsonEnum;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.aggregations.AdjacencyMatrixAggregate;
import org.opensearch.client.opensearch._types.aggregations.AggregateVariant;
import org.opensearch.client.opensearch._types.aggregations.AutoDateHistogramAggregate;
import org.opensearch.client.opensearch._types.aggregations.AvgAggregate;
import org.opensearch.client.opensearch._types.aggregations.BoxPlotAggregate;
import org.opensearch.client.opensearch._types.aggregations.BucketMetricValueAggregate;
import org.opensearch.client.opensearch._types.aggregations.CardinalityAggregate;
import org.opensearch.client.opensearch._types.aggregations.ChildrenAggregate;
import org.opensearch.client.opensearch._types.aggregations.CompositeAggregate;
import org.opensearch.client.opensearch._types.aggregations.CumulativeCardinalityAggregate;
import org.opensearch.client.opensearch._types.aggregations.DateHistogramAggregate;
import org.opensearch.client.opensearch._types.aggregations.DateRangeAggregate;
import org.opensearch.client.opensearch._types.aggregations.DerivativeAggregate;
import org.opensearch.client.opensearch._types.aggregations.DoubleTermsAggregate;
import org.opensearch.client.opensearch._types.aggregations.ExtendedStatsAggregate;
import org.opensearch.client.opensearch._types.aggregations.ExtendedStatsBucketAggregate;
import org.opensearch.client.opensearch._types.aggregations.FilterAggregate;
import org.opensearch.client.opensearch._types.aggregations.FiltersAggregate;
import org.opensearch.client.opensearch._types.aggregations.GeoBoundsAggregate;
import org.opensearch.client.opensearch._types.aggregations.GeoCentroidAggregate;
import org.opensearch.client.opensearch._types.aggregations.GeoDistanceAggregate;
import org.opensearch.client.opensearch._types.aggregations.GeoHashGridAggregate;
import org.opensearch.client.opensearch._types.aggregations.GeoTileGridAggregate;
import org.opensearch.client.opensearch._types.aggregations.GlobalAggregate;
import org.opensearch.client.opensearch._types.aggregations.HdrPercentileRanksAggregate;
import org.opensearch.client.opensearch._types.aggregations.HdrPercentilesAggregate;
import org.opensearch.client.opensearch._types.aggregations.HistogramAggregate;
import org.opensearch.client.opensearch._types.aggregations.IpRangeAggregate;
import org.opensearch.client.opensearch._types.aggregations.LongRareTermsAggregate;
import org.opensearch.client.opensearch._types.aggregations.LongTermsAggregate;
import org.opensearch.client.opensearch._types.aggregations.MatrixStatsAggregate;
import org.opensearch.client.opensearch._types.aggregations.MaxAggregate;
import org.opensearch.client.opensearch._types.aggregations.MedianAbsoluteDeviationAggregate;
import org.opensearch.client.opensearch._types.aggregations.MinAggregate;
import org.opensearch.client.opensearch._types.aggregations.MissingAggregate;
import org.opensearch.client.opensearch._types.aggregations.MultiTermsAggregate;
import org.opensearch.client.opensearch._types.aggregations.NestedAggregate;
import org.opensearch.client.opensearch._types.aggregations.ParentAggregate;
import org.opensearch.client.opensearch._types.aggregations.PercentilesBucketAggregate;
import org.opensearch.client.opensearch._types.aggregations.RangeAggregate;
import org.opensearch.client.opensearch._types.aggregations.RateAggregate;
import org.opensearch.client.opensearch._types.aggregations.ReverseNestedAggregate;
import org.opensearch.client.opensearch._types.aggregations.SamplerAggregate;
import org.opensearch.client.opensearch._types.aggregations.ScriptedMetricAggregate;
import org.opensearch.client.opensearch._types.aggregations.SignificantLongTermsAggregate;
import org.opensearch.client.opensearch._types.aggregations.SignificantStringTermsAggregate;
import org.opensearch.client.opensearch._types.aggregations.SimpleValueAggregate;
import org.opensearch.client.opensearch._types.aggregations.StatsAggregate;
import org.opensearch.client.opensearch._types.aggregations.StatsBucketAggregate;
import org.opensearch.client.opensearch._types.aggregations.StringRareTermsAggregate;
import org.opensearch.client.opensearch._types.aggregations.StringTermsAggregate;
import org.opensearch.client.opensearch._types.aggregations.SumAggregate;
import org.opensearch.client.opensearch._types.aggregations.TDigestPercentileRanksAggregate;
import org.opensearch.client.opensearch._types.aggregations.TDigestPercentilesAggregate;
import org.opensearch.client.opensearch._types.aggregations.TTestAggregate;
import org.opensearch.client.opensearch._types.aggregations.TopHitsAggregate;
import org.opensearch.client.opensearch._types.aggregations.UnmappedRareTermsAggregate;
import org.opensearch.client.opensearch._types.aggregations.UnmappedSignificantTermsAggregate;
import org.opensearch.client.opensearch._types.aggregations.UnmappedTermsAggregate;
import org.opensearch.client.opensearch._types.aggregations.ValueCountAggregate;
import org.opensearch.client.opensearch._types.aggregations.VariableWidthHistogramAggregate;
import org.opensearch.client.opensearch._types.aggregations.WeightedAvgAggregate;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.TaggedUnion;
import org.opensearch.client.util.TaggedUnionUtils;

public class Aggregate
implements TaggedUnion<Kind, AggregateVariant>,
PlainJsonSerializable {
    private final Kind _kind;
    private final AggregateVariant _value;
    public static final ExternallyTaggedUnion.TypedKeysDeserializer<Aggregate> _TYPED_KEYS_DESERIALIZER;

    @Override
    public final Kind _kind() {
        return this._kind;
    }

    @Override
    public final AggregateVariant _get() {
        return this._value;
    }

    public Aggregate(AggregateVariant value) {
        this._kind = ApiTypeHelper.requireNonNull(value._aggregateKind(), this, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(value, this, "<variant value>");
    }

    private Aggregate(Builder builder) {
        this._kind = ApiTypeHelper.requireNonNull(builder._kind, builder, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(builder._value, builder, "<variant value>");
    }

    public static Aggregate of(Function<Builder, ObjectBuilder<Aggregate>> fn) {
        return fn.apply(new Builder()).build();
    }

    public boolean isAdjacencyMatrix() {
        return this._kind == Kind.AdjacencyMatrix;
    }

    public AdjacencyMatrixAggregate adjacencyMatrix() {
        return (AdjacencyMatrixAggregate)TaggedUnionUtils.get(this, Kind.AdjacencyMatrix);
    }

    public boolean isAutoDateHistogram() {
        return this._kind == Kind.AutoDateHistogram;
    }

    public AutoDateHistogramAggregate autoDateHistogram() {
        return (AutoDateHistogramAggregate)TaggedUnionUtils.get(this, Kind.AutoDateHistogram);
    }

    public boolean isAvg() {
        return this._kind == Kind.Avg;
    }

    public AvgAggregate avg() {
        return (AvgAggregate)TaggedUnionUtils.get(this, Kind.Avg);
    }

    public boolean isBoxPlot() {
        return this._kind == Kind.BoxPlot;
    }

    public BoxPlotAggregate boxPlot() {
        return (BoxPlotAggregate)TaggedUnionUtils.get(this, Kind.BoxPlot);
    }

    public boolean isBucketMetricValue() {
        return this._kind == Kind.BucketMetricValue;
    }

    public BucketMetricValueAggregate bucketMetricValue() {
        return (BucketMetricValueAggregate)TaggedUnionUtils.get(this, Kind.BucketMetricValue);
    }

    public boolean isCardinality() {
        return this._kind == Kind.Cardinality;
    }

    public CardinalityAggregate cardinality() {
        return (CardinalityAggregate)TaggedUnionUtils.get(this, Kind.Cardinality);
    }

    public boolean isChildren() {
        return this._kind == Kind.Children;
    }

    public ChildrenAggregate children() {
        return (ChildrenAggregate)TaggedUnionUtils.get(this, Kind.Children);
    }

    public boolean isComposite() {
        return this._kind == Kind.Composite;
    }

    public CompositeAggregate composite() {
        return (CompositeAggregate)TaggedUnionUtils.get(this, Kind.Composite);
    }

    public boolean isDateHistogram() {
        return this._kind == Kind.DateHistogram;
    }

    public DateHistogramAggregate dateHistogram() {
        return (DateHistogramAggregate)TaggedUnionUtils.get(this, Kind.DateHistogram);
    }

    public boolean isDateRange() {
        return this._kind == Kind.DateRange;
    }

    public DateRangeAggregate dateRange() {
        return (DateRangeAggregate)TaggedUnionUtils.get(this, Kind.DateRange);
    }

    public boolean isDerivative() {
        return this._kind == Kind.Derivative;
    }

    public DerivativeAggregate derivative() {
        return (DerivativeAggregate)TaggedUnionUtils.get(this, Kind.Derivative);
    }

    public boolean isDterms() {
        return this._kind == Kind.Dterms;
    }

    public DoubleTermsAggregate dterms() {
        return (DoubleTermsAggregate)TaggedUnionUtils.get(this, Kind.Dterms);
    }

    public boolean isExtendedStats() {
        return this._kind == Kind.ExtendedStats;
    }

    public ExtendedStatsAggregate extendedStats() {
        return (ExtendedStatsAggregate)TaggedUnionUtils.get(this, Kind.ExtendedStats);
    }

    public boolean isExtendedStatsBucket() {
        return this._kind == Kind.ExtendedStatsBucket;
    }

    public ExtendedStatsBucketAggregate extendedStatsBucket() {
        return (ExtendedStatsBucketAggregate)TaggedUnionUtils.get(this, Kind.ExtendedStatsBucket);
    }

    public boolean isFilter() {
        return this._kind == Kind.Filter;
    }

    public FilterAggregate filter() {
        return (FilterAggregate)TaggedUnionUtils.get(this, Kind.Filter);
    }

    public boolean isFilters() {
        return this._kind == Kind.Filters;
    }

    public FiltersAggregate filters() {
        return (FiltersAggregate)TaggedUnionUtils.get(this, Kind.Filters);
    }

    public boolean isGeoBounds() {
        return this._kind == Kind.GeoBounds;
    }

    public GeoBoundsAggregate geoBounds() {
        return (GeoBoundsAggregate)TaggedUnionUtils.get(this, Kind.GeoBounds);
    }

    public boolean isGeoCentroid() {
        return this._kind == Kind.GeoCentroid;
    }

    public GeoCentroidAggregate geoCentroid() {
        return (GeoCentroidAggregate)TaggedUnionUtils.get(this, Kind.GeoCentroid);
    }

    public boolean isGeoDistance() {
        return this._kind == Kind.GeoDistance;
    }

    public GeoDistanceAggregate geoDistance() {
        return (GeoDistanceAggregate)TaggedUnionUtils.get(this, Kind.GeoDistance);
    }

    public boolean isGeohashGrid() {
        return this._kind == Kind.GeohashGrid;
    }

    public GeoHashGridAggregate geohashGrid() {
        return (GeoHashGridAggregate)TaggedUnionUtils.get(this, Kind.GeohashGrid);
    }

    public boolean isGeotileGrid() {
        return this._kind == Kind.GeotileGrid;
    }

    public GeoTileGridAggregate geotileGrid() {
        return (GeoTileGridAggregate)TaggedUnionUtils.get(this, Kind.GeotileGrid);
    }

    public boolean isGlobal() {
        return this._kind == Kind.Global;
    }

    public GlobalAggregate global() {
        return (GlobalAggregate)TaggedUnionUtils.get(this, Kind.Global);
    }

    public boolean isHdrPercentileRanks() {
        return this._kind == Kind.HdrPercentileRanks;
    }

    public HdrPercentileRanksAggregate hdrPercentileRanks() {
        return (HdrPercentileRanksAggregate)TaggedUnionUtils.get(this, Kind.HdrPercentileRanks);
    }

    public boolean isHdrPercentiles() {
        return this._kind == Kind.HdrPercentiles;
    }

    public HdrPercentilesAggregate hdrPercentiles() {
        return (HdrPercentilesAggregate)TaggedUnionUtils.get(this, Kind.HdrPercentiles);
    }

    public boolean isHistogram() {
        return this._kind == Kind.Histogram;
    }

    public HistogramAggregate histogram() {
        return (HistogramAggregate)TaggedUnionUtils.get(this, Kind.Histogram);
    }

    public boolean isIpRange() {
        return this._kind == Kind.IpRange;
    }

    public IpRangeAggregate ipRange() {
        return (IpRangeAggregate)TaggedUnionUtils.get(this, Kind.IpRange);
    }

    public boolean isLrareterms() {
        return this._kind == Kind.Lrareterms;
    }

    public LongRareTermsAggregate lrareterms() {
        return (LongRareTermsAggregate)TaggedUnionUtils.get(this, Kind.Lrareterms);
    }

    public boolean isLterms() {
        return this._kind == Kind.Lterms;
    }

    public LongTermsAggregate lterms() {
        return (LongTermsAggregate)TaggedUnionUtils.get(this, Kind.Lterms);
    }

    public boolean isMatrixStats() {
        return this._kind == Kind.MatrixStats;
    }

    public MatrixStatsAggregate matrixStats() {
        return (MatrixStatsAggregate)TaggedUnionUtils.get(this, Kind.MatrixStats);
    }

    public boolean isMax() {
        return this._kind == Kind.Max;
    }

    public MaxAggregate max() {
        return (MaxAggregate)TaggedUnionUtils.get(this, Kind.Max);
    }

    public boolean isMedianAbsoluteDeviation() {
        return this._kind == Kind.MedianAbsoluteDeviation;
    }

    public MedianAbsoluteDeviationAggregate medianAbsoluteDeviation() {
        return (MedianAbsoluteDeviationAggregate)TaggedUnionUtils.get(this, Kind.MedianAbsoluteDeviation);
    }

    public boolean isMin() {
        return this._kind == Kind.Min;
    }

    public MinAggregate min() {
        return (MinAggregate)TaggedUnionUtils.get(this, Kind.Min);
    }

    public boolean isMissing() {
        return this._kind == Kind.Missing;
    }

    public MissingAggregate missing() {
        return (MissingAggregate)TaggedUnionUtils.get(this, Kind.Missing);
    }

    public boolean isMultiTerms() {
        return this._kind == Kind.MultiTerms;
    }

    public MultiTermsAggregate multiTerms() {
        return (MultiTermsAggregate)TaggedUnionUtils.get(this, Kind.MultiTerms);
    }

    public boolean isNested() {
        return this._kind == Kind.Nested;
    }

    public NestedAggregate nested() {
        return (NestedAggregate)TaggedUnionUtils.get(this, Kind.Nested);
    }

    public boolean isParent() {
        return this._kind == Kind.Parent;
    }

    public ParentAggregate parent() {
        return (ParentAggregate)TaggedUnionUtils.get(this, Kind.Parent);
    }

    public boolean isPercentilesBucket() {
        return this._kind == Kind.PercentilesBucket;
    }

    public PercentilesBucketAggregate percentilesBucket() {
        return (PercentilesBucketAggregate)TaggedUnionUtils.get(this, Kind.PercentilesBucket);
    }

    public boolean isRange() {
        return this._kind == Kind.Range;
    }

    public RangeAggregate range() {
        return (RangeAggregate)TaggedUnionUtils.get(this, Kind.Range);
    }

    public boolean isRate() {
        return this._kind == Kind.Rate;
    }

    public RateAggregate rate() {
        return (RateAggregate)TaggedUnionUtils.get(this, Kind.Rate);
    }

    public boolean isReverseNested() {
        return this._kind == Kind.ReverseNested;
    }

    public ReverseNestedAggregate reverseNested() {
        return (ReverseNestedAggregate)TaggedUnionUtils.get(this, Kind.ReverseNested);
    }

    public boolean isSampler() {
        return this._kind == Kind.Sampler;
    }

    public SamplerAggregate sampler() {
        return (SamplerAggregate)TaggedUnionUtils.get(this, Kind.Sampler);
    }

    public boolean isScriptedMetric() {
        return this._kind == Kind.ScriptedMetric;
    }

    public ScriptedMetricAggregate scriptedMetric() {
        return (ScriptedMetricAggregate)TaggedUnionUtils.get(this, Kind.ScriptedMetric);
    }

    public boolean isSiglterms() {
        return this._kind == Kind.Siglterms;
    }

    public SignificantLongTermsAggregate siglterms() {
        return (SignificantLongTermsAggregate)TaggedUnionUtils.get(this, Kind.Siglterms);
    }

    public boolean isSigsterms() {
        return this._kind == Kind.Sigsterms;
    }

    public SignificantStringTermsAggregate sigsterms() {
        return (SignificantStringTermsAggregate)TaggedUnionUtils.get(this, Kind.Sigsterms);
    }

    public boolean isSimpleLongValue() {
        return this._kind == Kind.SimpleLongValue;
    }

    public CumulativeCardinalityAggregate simpleLongValue() {
        return (CumulativeCardinalityAggregate)TaggedUnionUtils.get(this, Kind.SimpleLongValue);
    }

    public boolean isSimpleValue() {
        return this._kind == Kind.SimpleValue;
    }

    public SimpleValueAggregate simpleValue() {
        return (SimpleValueAggregate)TaggedUnionUtils.get(this, Kind.SimpleValue);
    }

    public boolean isSrareterms() {
        return this._kind == Kind.Srareterms;
    }

    public StringRareTermsAggregate srareterms() {
        return (StringRareTermsAggregate)TaggedUnionUtils.get(this, Kind.Srareterms);
    }

    public boolean isStats() {
        return this._kind == Kind.Stats;
    }

    public StatsAggregate stats() {
        return (StatsAggregate)TaggedUnionUtils.get(this, Kind.Stats);
    }

    public boolean isStatsBucket() {
        return this._kind == Kind.StatsBucket;
    }

    public StatsBucketAggregate statsBucket() {
        return (StatsBucketAggregate)TaggedUnionUtils.get(this, Kind.StatsBucket);
    }

    public boolean isSterms() {
        return this._kind == Kind.Sterms;
    }

    public StringTermsAggregate sterms() {
        return (StringTermsAggregate)TaggedUnionUtils.get(this, Kind.Sterms);
    }

    public boolean isSum() {
        return this._kind == Kind.Sum;
    }

    public SumAggregate sum() {
        return (SumAggregate)TaggedUnionUtils.get(this, Kind.Sum);
    }

    public boolean isTTest() {
        return this._kind == Kind.TTest;
    }

    public TTestAggregate tTest() {
        return (TTestAggregate)TaggedUnionUtils.get(this, Kind.TTest);
    }

    public boolean isTdigestPercentileRanks() {
        return this._kind == Kind.TdigestPercentileRanks;
    }

    public TDigestPercentileRanksAggregate tdigestPercentileRanks() {
        return (TDigestPercentileRanksAggregate)TaggedUnionUtils.get(this, Kind.TdigestPercentileRanks);
    }

    public boolean isTdigestPercentiles() {
        return this._kind == Kind.TdigestPercentiles;
    }

    public TDigestPercentilesAggregate tdigestPercentiles() {
        return (TDigestPercentilesAggregate)TaggedUnionUtils.get(this, Kind.TdigestPercentiles);
    }

    public boolean isTopHits() {
        return this._kind == Kind.TopHits;
    }

    public TopHitsAggregate topHits() {
        return (TopHitsAggregate)TaggedUnionUtils.get(this, Kind.TopHits);
    }

    public boolean isUmrareterms() {
        return this._kind == Kind.Umrareterms;
    }

    public UnmappedRareTermsAggregate umrareterms() {
        return (UnmappedRareTermsAggregate)TaggedUnionUtils.get(this, Kind.Umrareterms);
    }

    public boolean isUmsigterms() {
        return this._kind == Kind.Umsigterms;
    }

    public UnmappedSignificantTermsAggregate umsigterms() {
        return (UnmappedSignificantTermsAggregate)TaggedUnionUtils.get(this, Kind.Umsigterms);
    }

    public boolean isUmterms() {
        return this._kind == Kind.Umterms;
    }

    public UnmappedTermsAggregate umterms() {
        return (UnmappedTermsAggregate)TaggedUnionUtils.get(this, Kind.Umterms);
    }

    public boolean isValueCount() {
        return this._kind == Kind.ValueCount;
    }

    public ValueCountAggregate valueCount() {
        return (ValueCountAggregate)TaggedUnionUtils.get(this, Kind.ValueCount);
    }

    public boolean isVariableWidthHistogram() {
        return this._kind == Kind.VariableWidthHistogram;
    }

    public VariableWidthHistogramAggregate variableWidthHistogram() {
        return (VariableWidthHistogramAggregate)TaggedUnionUtils.get(this, Kind.VariableWidthHistogram);
    }

    public boolean isWeightedAvg() {
        return this._kind == Kind.WeightedAvg;
    }

    public WeightedAvgAggregate weightedAvg() {
        return (WeightedAvgAggregate)TaggedUnionUtils.get(this, Kind.WeightedAvg);
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        mapper.serialize(this._value, generator);
    }

    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this._kind);
        result = 31 * result + Objects.hashCode(this._value);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Aggregate other = (Aggregate)o;
        return Objects.equals(this._kind, other._kind) && Objects.equals(this._value, other._value);
    }

    static {
        HashMap deserializers = new HashMap();
        deserializers.put("adjacency_matrix", AdjacencyMatrixAggregate._DESERIALIZER);
        deserializers.put("auto_date_histogram", AutoDateHistogramAggregate._DESERIALIZER);
        deserializers.put("avg", AvgAggregate._DESERIALIZER);
        deserializers.put("box_plot", BoxPlotAggregate._DESERIALIZER);
        deserializers.put("bucket_metric_value", BucketMetricValueAggregate._DESERIALIZER);
        deserializers.put("cardinality", CardinalityAggregate._DESERIALIZER);
        deserializers.put("children", ChildrenAggregate._DESERIALIZER);
        deserializers.put("composite", CompositeAggregate._DESERIALIZER);
        deserializers.put("date_histogram", DateHistogramAggregate._DESERIALIZER);
        deserializers.put("date_range", DateRangeAggregate._DESERIALIZER);
        deserializers.put("derivative", DerivativeAggregate._DESERIALIZER);
        deserializers.put("dterms", DoubleTermsAggregate._DESERIALIZER);
        deserializers.put("extended_stats", ExtendedStatsAggregate._DESERIALIZER);
        deserializers.put("extended_stats_bucket", ExtendedStatsBucketAggregate._DESERIALIZER);
        deserializers.put("filter", FilterAggregate._DESERIALIZER);
        deserializers.put("filters", FiltersAggregate._DESERIALIZER);
        deserializers.put("geo_bounds", GeoBoundsAggregate._DESERIALIZER);
        deserializers.put("geo_centroid", GeoCentroidAggregate._DESERIALIZER);
        deserializers.put("geo_distance", GeoDistanceAggregate._DESERIALIZER);
        deserializers.put("geohash_grid", GeoHashGridAggregate._DESERIALIZER);
        deserializers.put("geotile_grid", GeoTileGridAggregate._DESERIALIZER);
        deserializers.put("global", GlobalAggregate._DESERIALIZER);
        deserializers.put("hdr_percentile_ranks", HdrPercentileRanksAggregate._DESERIALIZER);
        deserializers.put("hdr_percentiles", HdrPercentilesAggregate._DESERIALIZER);
        deserializers.put("histogram", HistogramAggregate._DESERIALIZER);
        deserializers.put("ip_range", IpRangeAggregate._DESERIALIZER);
        deserializers.put("lrareterms", LongRareTermsAggregate._DESERIALIZER);
        deserializers.put("lterms", LongTermsAggregate._DESERIALIZER);
        deserializers.put("matrix_stats", MatrixStatsAggregate._DESERIALIZER);
        deserializers.put("max", MaxAggregate._DESERIALIZER);
        deserializers.put("median_absolute_deviation", MedianAbsoluteDeviationAggregate._DESERIALIZER);
        deserializers.put("min", MinAggregate._DESERIALIZER);
        deserializers.put("missing", MissingAggregate._DESERIALIZER);
        deserializers.put("multi_terms", MultiTermsAggregate._DESERIALIZER);
        deserializers.put("nested", NestedAggregate._DESERIALIZER);
        deserializers.put("parent", ParentAggregate._DESERIALIZER);
        deserializers.put("percentiles_bucket", PercentilesBucketAggregate._DESERIALIZER);
        deserializers.put("range", RangeAggregate._DESERIALIZER);
        deserializers.put("rate", RateAggregate._DESERIALIZER);
        deserializers.put("reverse_nested", ReverseNestedAggregate._DESERIALIZER);
        deserializers.put("sampler", SamplerAggregate._DESERIALIZER);
        deserializers.put("scripted_metric", ScriptedMetricAggregate._DESERIALIZER);
        deserializers.put("siglterms", SignificantLongTermsAggregate._DESERIALIZER);
        deserializers.put("sigsterms", SignificantStringTermsAggregate._DESERIALIZER);
        deserializers.put("simple_long_value", CumulativeCardinalityAggregate._DESERIALIZER);
        deserializers.put("simple_value", SimpleValueAggregate._DESERIALIZER);
        deserializers.put("srareterms", StringRareTermsAggregate._DESERIALIZER);
        deserializers.put("stats", StatsAggregate._DESERIALIZER);
        deserializers.put("stats_bucket", StatsBucketAggregate._DESERIALIZER);
        deserializers.put("sterms", StringTermsAggregate._DESERIALIZER);
        deserializers.put("sum", SumAggregate._DESERIALIZER);
        deserializers.put("t_test", TTestAggregate._DESERIALIZER);
        deserializers.put("tdigest_percentile_ranks", TDigestPercentileRanksAggregate._DESERIALIZER);
        deserializers.put("tdigest_percentiles", TDigestPercentilesAggregate._DESERIALIZER);
        deserializers.put("top_hits", TopHitsAggregate._DESERIALIZER);
        deserializers.put("umrareterms", UnmappedRareTermsAggregate._DESERIALIZER);
        deserializers.put("umsigterms", UnmappedSignificantTermsAggregate._DESERIALIZER);
        deserializers.put("umterms", UnmappedTermsAggregate._DESERIALIZER);
        deserializers.put("value_count", ValueCountAggregate._DESERIALIZER);
        deserializers.put("variable_width_histogram", VariableWidthHistogramAggregate._DESERIALIZER);
        deserializers.put("weighted_avg", WeightedAvgAggregate._DESERIALIZER);
        _TYPED_KEYS_DESERIALIZER = new ExternallyTaggedUnion.Deserializer<Aggregate, AggregateVariant>(deserializers, Aggregate::new).typedKeys();
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<Aggregate> {
        private Kind _kind;
        private AggregateVariant _value;

        public Builder() {
        }

        private Builder(Aggregate o) {
            this._kind = o._kind;
            this._value = o._value;
        }

        public ObjectBuilder<Aggregate> adjacencyMatrix(AdjacencyMatrixAggregate v) {
            this._kind = Kind.AdjacencyMatrix;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Aggregate> adjacencyMatrix(Function<AdjacencyMatrixAggregate.Builder, ObjectBuilder<AdjacencyMatrixAggregate>> fn) {
            return this.adjacencyMatrix(fn.apply(new AdjacencyMatrixAggregate.Builder()).build());
        }

        public ObjectBuilder<Aggregate> autoDateHistogram(AutoDateHistogramAggregate v) {
            this._kind = Kind.AutoDateHistogram;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Aggregate> autoDateHistogram(Function<AutoDateHistogramAggregate.Builder, ObjectBuilder<AutoDateHistogramAggregate>> fn) {
            return this.autoDateHistogram(fn.apply(new AutoDateHistogramAggregate.Builder()).build());
        }

        public ObjectBuilder<Aggregate> avg(AvgAggregate v) {
            this._kind = Kind.Avg;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Aggregate> avg(Function<AvgAggregate.Builder, ObjectBuilder<AvgAggregate>> fn) {
            return this.avg(fn.apply(new AvgAggregate.Builder()).build());
        }

        public ObjectBuilder<Aggregate> boxPlot(BoxPlotAggregate v) {
            this._kind = Kind.BoxPlot;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Aggregate> boxPlot(Function<BoxPlotAggregate.Builder, ObjectBuilder<BoxPlotAggregate>> fn) {
            return this.boxPlot(fn.apply(new BoxPlotAggregate.Builder()).build());
        }

        public ObjectBuilder<Aggregate> bucketMetricValue(BucketMetricValueAggregate v) {
            this._kind = Kind.BucketMetricValue;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Aggregate> bucketMetricValue(Function<BucketMetricValueAggregate.Builder, ObjectBuilder<BucketMetricValueAggregate>> fn) {
            return this.bucketMetricValue(fn.apply(new BucketMetricValueAggregate.Builder()).build());
        }

        public ObjectBuilder<Aggregate> cardinality(CardinalityAggregate v) {
            this._kind = Kind.Cardinality;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Aggregate> cardinality(Function<CardinalityAggregate.Builder, ObjectBuilder<CardinalityAggregate>> fn) {
            return this.cardinality(fn.apply(new CardinalityAggregate.Builder()).build());
        }

        public ObjectBuilder<Aggregate> children(ChildrenAggregate v) {
            this._kind = Kind.Children;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Aggregate> children(Function<ChildrenAggregate.Builder, ObjectBuilder<ChildrenAggregate>> fn) {
            return this.children(fn.apply(new ChildrenAggregate.Builder()).build());
        }

        public ObjectBuilder<Aggregate> composite(CompositeAggregate v) {
            this._kind = Kind.Composite;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Aggregate> composite(Function<CompositeAggregate.Builder, ObjectBuilder<CompositeAggregate>> fn) {
            return this.composite(fn.apply(new CompositeAggregate.Builder()).build());
        }

        public ObjectBuilder<Aggregate> dateHistogram(DateHistogramAggregate v) {
            this._kind = Kind.DateHistogram;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Aggregate> dateHistogram(Function<DateHistogramAggregate.Builder, ObjectBuilder<DateHistogramAggregate>> fn) {
            return this.dateHistogram(fn.apply(new DateHistogramAggregate.Builder()).build());
        }

        public ObjectBuilder<Aggregate> dateRange(DateRangeAggregate v) {
            this._kind = Kind.DateRange;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Aggregate> dateRange(Function<DateRangeAggregate.Builder, ObjectBuilder<DateRangeAggregate>> fn) {
            return this.dateRange(fn.apply(new DateRangeAggregate.Builder()).build());
        }

        public ObjectBuilder<Aggregate> derivative(DerivativeAggregate v) {
            this._kind = Kind.Derivative;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Aggregate> derivative(Function<DerivativeAggregate.Builder, ObjectBuilder<DerivativeAggregate>> fn) {
            return this.derivative(fn.apply(new DerivativeAggregate.Builder()).build());
        }

        public ObjectBuilder<Aggregate> dterms(DoubleTermsAggregate v) {
            this._kind = Kind.Dterms;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Aggregate> dterms(Function<DoubleTermsAggregate.Builder, ObjectBuilder<DoubleTermsAggregate>> fn) {
            return this.dterms(fn.apply(new DoubleTermsAggregate.Builder()).build());
        }

        public ObjectBuilder<Aggregate> extendedStats(ExtendedStatsAggregate v) {
            this._kind = Kind.ExtendedStats;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Aggregate> extendedStats(Function<ExtendedStatsAggregate.Builder, ObjectBuilder<ExtendedStatsAggregate>> fn) {
            return this.extendedStats(fn.apply(new ExtendedStatsAggregate.Builder()).build());
        }

        public ObjectBuilder<Aggregate> extendedStatsBucket(ExtendedStatsBucketAggregate v) {
            this._kind = Kind.ExtendedStatsBucket;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Aggregate> extendedStatsBucket(Function<ExtendedStatsBucketAggregate.Builder, ObjectBuilder<ExtendedStatsBucketAggregate>> fn) {
            return this.extendedStatsBucket(fn.apply(new ExtendedStatsBucketAggregate.Builder()).build());
        }

        public ObjectBuilder<Aggregate> filter(FilterAggregate v) {
            this._kind = Kind.Filter;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Aggregate> filter(Function<FilterAggregate.Builder, ObjectBuilder<FilterAggregate>> fn) {
            return this.filter(fn.apply(new FilterAggregate.Builder()).build());
        }

        public ObjectBuilder<Aggregate> filters(FiltersAggregate v) {
            this._kind = Kind.Filters;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Aggregate> filters(Function<FiltersAggregate.Builder, ObjectBuilder<FiltersAggregate>> fn) {
            return this.filters(fn.apply(new FiltersAggregate.Builder()).build());
        }

        public ObjectBuilder<Aggregate> geoBounds(GeoBoundsAggregate v) {
            this._kind = Kind.GeoBounds;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Aggregate> geoBounds(Function<GeoBoundsAggregate.Builder, ObjectBuilder<GeoBoundsAggregate>> fn) {
            return this.geoBounds(fn.apply(new GeoBoundsAggregate.Builder()).build());
        }

        public ObjectBuilder<Aggregate> geoCentroid(GeoCentroidAggregate v) {
            this._kind = Kind.GeoCentroid;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Aggregate> geoCentroid(Function<GeoCentroidAggregate.Builder, ObjectBuilder<GeoCentroidAggregate>> fn) {
            return this.geoCentroid(fn.apply(new GeoCentroidAggregate.Builder()).build());
        }

        public ObjectBuilder<Aggregate> geoDistance(GeoDistanceAggregate v) {
            this._kind = Kind.GeoDistance;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Aggregate> geoDistance(Function<GeoDistanceAggregate.Builder, ObjectBuilder<GeoDistanceAggregate>> fn) {
            return this.geoDistance(fn.apply(new GeoDistanceAggregate.Builder()).build());
        }

        public ObjectBuilder<Aggregate> geohashGrid(GeoHashGridAggregate v) {
            this._kind = Kind.GeohashGrid;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Aggregate> geohashGrid(Function<GeoHashGridAggregate.Builder, ObjectBuilder<GeoHashGridAggregate>> fn) {
            return this.geohashGrid(fn.apply(new GeoHashGridAggregate.Builder()).build());
        }

        public ObjectBuilder<Aggregate> geotileGrid(GeoTileGridAggregate v) {
            this._kind = Kind.GeotileGrid;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Aggregate> geotileGrid(Function<GeoTileGridAggregate.Builder, ObjectBuilder<GeoTileGridAggregate>> fn) {
            return this.geotileGrid(fn.apply(new GeoTileGridAggregate.Builder()).build());
        }

        public ObjectBuilder<Aggregate> global(GlobalAggregate v) {
            this._kind = Kind.Global;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Aggregate> global(Function<GlobalAggregate.Builder, ObjectBuilder<GlobalAggregate>> fn) {
            return this.global(fn.apply(new GlobalAggregate.Builder()).build());
        }

        public ObjectBuilder<Aggregate> hdrPercentileRanks(HdrPercentileRanksAggregate v) {
            this._kind = Kind.HdrPercentileRanks;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Aggregate> hdrPercentileRanks(Function<HdrPercentileRanksAggregate.Builder, ObjectBuilder<HdrPercentileRanksAggregate>> fn) {
            return this.hdrPercentileRanks(fn.apply(new HdrPercentileRanksAggregate.Builder()).build());
        }

        public ObjectBuilder<Aggregate> hdrPercentiles(HdrPercentilesAggregate v) {
            this._kind = Kind.HdrPercentiles;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Aggregate> hdrPercentiles(Function<HdrPercentilesAggregate.Builder, ObjectBuilder<HdrPercentilesAggregate>> fn) {
            return this.hdrPercentiles(fn.apply(new HdrPercentilesAggregate.Builder()).build());
        }

        public ObjectBuilder<Aggregate> histogram(HistogramAggregate v) {
            this._kind = Kind.Histogram;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Aggregate> histogram(Function<HistogramAggregate.Builder, ObjectBuilder<HistogramAggregate>> fn) {
            return this.histogram(fn.apply(new HistogramAggregate.Builder()).build());
        }

        public ObjectBuilder<Aggregate> ipRange(IpRangeAggregate v) {
            this._kind = Kind.IpRange;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Aggregate> ipRange(Function<IpRangeAggregate.Builder, ObjectBuilder<IpRangeAggregate>> fn) {
            return this.ipRange(fn.apply(new IpRangeAggregate.Builder()).build());
        }

        public ObjectBuilder<Aggregate> lrareterms(LongRareTermsAggregate v) {
            this._kind = Kind.Lrareterms;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Aggregate> lrareterms(Function<LongRareTermsAggregate.Builder, ObjectBuilder<LongRareTermsAggregate>> fn) {
            return this.lrareterms(fn.apply(new LongRareTermsAggregate.Builder()).build());
        }

        public ObjectBuilder<Aggregate> lterms(LongTermsAggregate v) {
            this._kind = Kind.Lterms;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Aggregate> lterms(Function<LongTermsAggregate.Builder, ObjectBuilder<LongTermsAggregate>> fn) {
            return this.lterms(fn.apply(new LongTermsAggregate.Builder()).build());
        }

        public ObjectBuilder<Aggregate> matrixStats(MatrixStatsAggregate v) {
            this._kind = Kind.MatrixStats;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Aggregate> matrixStats(Function<MatrixStatsAggregate.Builder, ObjectBuilder<MatrixStatsAggregate>> fn) {
            return this.matrixStats(fn.apply(new MatrixStatsAggregate.Builder()).build());
        }

        public ObjectBuilder<Aggregate> max(MaxAggregate v) {
            this._kind = Kind.Max;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Aggregate> max(Function<MaxAggregate.Builder, ObjectBuilder<MaxAggregate>> fn) {
            return this.max(fn.apply(new MaxAggregate.Builder()).build());
        }

        public ObjectBuilder<Aggregate> medianAbsoluteDeviation(MedianAbsoluteDeviationAggregate v) {
            this._kind = Kind.MedianAbsoluteDeviation;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Aggregate> medianAbsoluteDeviation(Function<MedianAbsoluteDeviationAggregate.Builder, ObjectBuilder<MedianAbsoluteDeviationAggregate>> fn) {
            return this.medianAbsoluteDeviation(fn.apply(new MedianAbsoluteDeviationAggregate.Builder()).build());
        }

        public ObjectBuilder<Aggregate> min(MinAggregate v) {
            this._kind = Kind.Min;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Aggregate> min(Function<MinAggregate.Builder, ObjectBuilder<MinAggregate>> fn) {
            return this.min(fn.apply(new MinAggregate.Builder()).build());
        }

        public ObjectBuilder<Aggregate> missing(MissingAggregate v) {
            this._kind = Kind.Missing;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Aggregate> missing(Function<MissingAggregate.Builder, ObjectBuilder<MissingAggregate>> fn) {
            return this.missing(fn.apply(new MissingAggregate.Builder()).build());
        }

        public ObjectBuilder<Aggregate> multiTerms(MultiTermsAggregate v) {
            this._kind = Kind.MultiTerms;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Aggregate> multiTerms(Function<MultiTermsAggregate.Builder, ObjectBuilder<MultiTermsAggregate>> fn) {
            return this.multiTerms(fn.apply(new MultiTermsAggregate.Builder()).build());
        }

        public ObjectBuilder<Aggregate> nested(NestedAggregate v) {
            this._kind = Kind.Nested;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Aggregate> nested(Function<NestedAggregate.Builder, ObjectBuilder<NestedAggregate>> fn) {
            return this.nested(fn.apply(new NestedAggregate.Builder()).build());
        }

        public ObjectBuilder<Aggregate> parent(ParentAggregate v) {
            this._kind = Kind.Parent;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Aggregate> parent(Function<ParentAggregate.Builder, ObjectBuilder<ParentAggregate>> fn) {
            return this.parent(fn.apply(new ParentAggregate.Builder()).build());
        }

        public ObjectBuilder<Aggregate> percentilesBucket(PercentilesBucketAggregate v) {
            this._kind = Kind.PercentilesBucket;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Aggregate> percentilesBucket(Function<PercentilesBucketAggregate.Builder, ObjectBuilder<PercentilesBucketAggregate>> fn) {
            return this.percentilesBucket(fn.apply(new PercentilesBucketAggregate.Builder()).build());
        }

        public ObjectBuilder<Aggregate> range(RangeAggregate v) {
            this._kind = Kind.Range;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Aggregate> range(Function<RangeAggregate.Builder, ObjectBuilder<RangeAggregate>> fn) {
            return this.range(fn.apply(new RangeAggregate.Builder()).build());
        }

        public ObjectBuilder<Aggregate> rate(RateAggregate v) {
            this._kind = Kind.Rate;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Aggregate> rate(Function<RateAggregate.Builder, ObjectBuilder<RateAggregate>> fn) {
            return this.rate(fn.apply(new RateAggregate.Builder()).build());
        }

        public ObjectBuilder<Aggregate> reverseNested(ReverseNestedAggregate v) {
            this._kind = Kind.ReverseNested;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Aggregate> reverseNested(Function<ReverseNestedAggregate.Builder, ObjectBuilder<ReverseNestedAggregate>> fn) {
            return this.reverseNested(fn.apply(new ReverseNestedAggregate.Builder()).build());
        }

        public ObjectBuilder<Aggregate> sampler(SamplerAggregate v) {
            this._kind = Kind.Sampler;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Aggregate> sampler(Function<SamplerAggregate.Builder, ObjectBuilder<SamplerAggregate>> fn) {
            return this.sampler(fn.apply(new SamplerAggregate.Builder()).build());
        }

        public ObjectBuilder<Aggregate> scriptedMetric(ScriptedMetricAggregate v) {
            this._kind = Kind.ScriptedMetric;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Aggregate> scriptedMetric(Function<ScriptedMetricAggregate.Builder, ObjectBuilder<ScriptedMetricAggregate>> fn) {
            return this.scriptedMetric(fn.apply(new ScriptedMetricAggregate.Builder()).build());
        }

        public ObjectBuilder<Aggregate> siglterms(SignificantLongTermsAggregate v) {
            this._kind = Kind.Siglterms;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Aggregate> siglterms(Function<SignificantLongTermsAggregate.Builder, ObjectBuilder<SignificantLongTermsAggregate>> fn) {
            return this.siglterms(fn.apply(new SignificantLongTermsAggregate.Builder()).build());
        }

        public ObjectBuilder<Aggregate> sigsterms(SignificantStringTermsAggregate v) {
            this._kind = Kind.Sigsterms;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Aggregate> sigsterms(Function<SignificantStringTermsAggregate.Builder, ObjectBuilder<SignificantStringTermsAggregate>> fn) {
            return this.sigsterms(fn.apply(new SignificantStringTermsAggregate.Builder()).build());
        }

        public ObjectBuilder<Aggregate> simpleLongValue(CumulativeCardinalityAggregate v) {
            this._kind = Kind.SimpleLongValue;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Aggregate> simpleLongValue(Function<CumulativeCardinalityAggregate.Builder, ObjectBuilder<CumulativeCardinalityAggregate>> fn) {
            return this.simpleLongValue(fn.apply(new CumulativeCardinalityAggregate.Builder()).build());
        }

        public ObjectBuilder<Aggregate> simpleValue(SimpleValueAggregate v) {
            this._kind = Kind.SimpleValue;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Aggregate> simpleValue(Function<SimpleValueAggregate.Builder, ObjectBuilder<SimpleValueAggregate>> fn) {
            return this.simpleValue(fn.apply(new SimpleValueAggregate.Builder()).build());
        }

        public ObjectBuilder<Aggregate> srareterms(StringRareTermsAggregate v) {
            this._kind = Kind.Srareterms;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Aggregate> srareterms(Function<StringRareTermsAggregate.Builder, ObjectBuilder<StringRareTermsAggregate>> fn) {
            return this.srareterms(fn.apply(new StringRareTermsAggregate.Builder()).build());
        }

        public ObjectBuilder<Aggregate> stats(StatsAggregate v) {
            this._kind = Kind.Stats;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Aggregate> stats(Function<StatsAggregate.Builder, ObjectBuilder<StatsAggregate>> fn) {
            return this.stats(fn.apply(new StatsAggregate.Builder()).build());
        }

        public ObjectBuilder<Aggregate> statsBucket(StatsBucketAggregate v) {
            this._kind = Kind.StatsBucket;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Aggregate> statsBucket(Function<StatsBucketAggregate.Builder, ObjectBuilder<StatsBucketAggregate>> fn) {
            return this.statsBucket(fn.apply(new StatsBucketAggregate.Builder()).build());
        }

        public ObjectBuilder<Aggregate> sterms(StringTermsAggregate v) {
            this._kind = Kind.Sterms;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Aggregate> sterms(Function<StringTermsAggregate.Builder, ObjectBuilder<StringTermsAggregate>> fn) {
            return this.sterms(fn.apply(new StringTermsAggregate.Builder()).build());
        }

        public ObjectBuilder<Aggregate> sum(SumAggregate v) {
            this._kind = Kind.Sum;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Aggregate> sum(Function<SumAggregate.Builder, ObjectBuilder<SumAggregate>> fn) {
            return this.sum(fn.apply(new SumAggregate.Builder()).build());
        }

        public ObjectBuilder<Aggregate> tTest(TTestAggregate v) {
            this._kind = Kind.TTest;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Aggregate> tTest(Function<TTestAggregate.Builder, ObjectBuilder<TTestAggregate>> fn) {
            return this.tTest(fn.apply(new TTestAggregate.Builder()).build());
        }

        public ObjectBuilder<Aggregate> tdigestPercentileRanks(TDigestPercentileRanksAggregate v) {
            this._kind = Kind.TdigestPercentileRanks;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Aggregate> tdigestPercentileRanks(Function<TDigestPercentileRanksAggregate.Builder, ObjectBuilder<TDigestPercentileRanksAggregate>> fn) {
            return this.tdigestPercentileRanks(fn.apply(new TDigestPercentileRanksAggregate.Builder()).build());
        }

        public ObjectBuilder<Aggregate> tdigestPercentiles(TDigestPercentilesAggregate v) {
            this._kind = Kind.TdigestPercentiles;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Aggregate> tdigestPercentiles(Function<TDigestPercentilesAggregate.Builder, ObjectBuilder<TDigestPercentilesAggregate>> fn) {
            return this.tdigestPercentiles(fn.apply(new TDigestPercentilesAggregate.Builder()).build());
        }

        public ObjectBuilder<Aggregate> topHits(TopHitsAggregate v) {
            this._kind = Kind.TopHits;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Aggregate> topHits(Function<TopHitsAggregate.Builder, ObjectBuilder<TopHitsAggregate>> fn) {
            return this.topHits(fn.apply(new TopHitsAggregate.Builder()).build());
        }

        public ObjectBuilder<Aggregate> umrareterms(UnmappedRareTermsAggregate v) {
            this._kind = Kind.Umrareterms;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Aggregate> umrareterms(Function<UnmappedRareTermsAggregate.Builder, ObjectBuilder<UnmappedRareTermsAggregate>> fn) {
            return this.umrareterms(fn.apply(new UnmappedRareTermsAggregate.Builder()).build());
        }

        public ObjectBuilder<Aggregate> umsigterms(UnmappedSignificantTermsAggregate v) {
            this._kind = Kind.Umsigterms;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Aggregate> umsigterms(Function<UnmappedSignificantTermsAggregate.Builder, ObjectBuilder<UnmappedSignificantTermsAggregate>> fn) {
            return this.umsigterms(fn.apply(new UnmappedSignificantTermsAggregate.Builder()).build());
        }

        public ObjectBuilder<Aggregate> umterms(UnmappedTermsAggregate v) {
            this._kind = Kind.Umterms;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Aggregate> umterms(Function<UnmappedTermsAggregate.Builder, ObjectBuilder<UnmappedTermsAggregate>> fn) {
            return this.umterms(fn.apply(new UnmappedTermsAggregate.Builder()).build());
        }

        public ObjectBuilder<Aggregate> valueCount(ValueCountAggregate v) {
            this._kind = Kind.ValueCount;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Aggregate> valueCount(Function<ValueCountAggregate.Builder, ObjectBuilder<ValueCountAggregate>> fn) {
            return this.valueCount(fn.apply(new ValueCountAggregate.Builder()).build());
        }

        public ObjectBuilder<Aggregate> variableWidthHistogram(VariableWidthHistogramAggregate v) {
            this._kind = Kind.VariableWidthHistogram;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Aggregate> variableWidthHistogram(Function<VariableWidthHistogramAggregate.Builder, ObjectBuilder<VariableWidthHistogramAggregate>> fn) {
            return this.variableWidthHistogram(fn.apply(new VariableWidthHistogramAggregate.Builder()).build());
        }

        public ObjectBuilder<Aggregate> weightedAvg(WeightedAvgAggregate v) {
            this._kind = Kind.WeightedAvg;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Aggregate> weightedAvg(Function<WeightedAvgAggregate.Builder, ObjectBuilder<WeightedAvgAggregate>> fn) {
            return this.weightedAvg(fn.apply(new WeightedAvgAggregate.Builder()).build());
        }

        @Override
        public Aggregate build() {
            this._checkSingleUse();
            return new Aggregate(this);
        }
    }

    public static enum Kind implements JsonEnum
    {
        AdjacencyMatrix("adjacency_matrix"),
        AutoDateHistogram("auto_date_histogram"),
        Avg("avg"),
        BoxPlot("box_plot"),
        BucketMetricValue("bucket_metric_value"),
        Cardinality("cardinality"),
        Children("children"),
        Composite("composite"),
        DateHistogram("date_histogram"),
        DateRange("date_range"),
        Derivative("derivative"),
        Dterms("dterms"),
        ExtendedStats("extended_stats"),
        ExtendedStatsBucket("extended_stats_bucket"),
        Filter("filter"),
        Filters("filters"),
        GeoBounds("geo_bounds"),
        GeoCentroid("geo_centroid"),
        GeoDistance("geo_distance"),
        GeohashGrid("geohash_grid"),
        GeotileGrid("geotile_grid"),
        Global("global"),
        HdrPercentileRanks("hdr_percentile_ranks"),
        HdrPercentiles("hdr_percentiles"),
        Histogram("histogram"),
        IpRange("ip_range"),
        Lrareterms("lrareterms"),
        Lterms("lterms"),
        MatrixStats("matrix_stats"),
        Max("max"),
        MedianAbsoluteDeviation("median_absolute_deviation"),
        Min("min"),
        Missing("missing"),
        MultiTerms("multi_terms"),
        Nested("nested"),
        Parent("parent"),
        PercentilesBucket("percentiles_bucket"),
        Range("range"),
        Rate("rate"),
        ReverseNested("reverse_nested"),
        Sampler("sampler"),
        ScriptedMetric("scripted_metric"),
        Siglterms("siglterms"),
        Sigsterms("sigsterms"),
        SimpleLongValue("simple_long_value"),
        SimpleValue("simple_value"),
        Srareterms("srareterms"),
        Stats("stats"),
        StatsBucket("stats_bucket"),
        Sterms("sterms"),
        Sum("sum"),
        TTest("t_test"),
        TdigestPercentileRanks("tdigest_percentile_ranks"),
        TdigestPercentiles("tdigest_percentiles"),
        TopHits("top_hits"),
        Umrareterms("umrareterms"),
        Umsigterms("umsigterms"),
        Umterms("umterms"),
        ValueCount("value_count"),
        VariableWidthHistogram("variable_width_histogram"),
        WeightedAvg("weighted_avg");

        private final String jsonValue;

        private Kind(String jsonValue) {
            this.jsonValue = jsonValue;
        }

        @Override
        public String jsonValue() {
            return this.jsonValue;
        }
    }
}

