/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sns.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.sns.model.MessageAttributeValue;
import com.amazonaws.services.sns.model.PublishBatchRequest;
import com.amazonaws.services.sns.model.PublishBatchRequestEntry;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.nio.ByteBuffer;
import java.util.Map;

public class PublishBatchRequestMarshaller
implements Marshaller<Request<PublishBatchRequest>, PublishBatchRequest> {
    public Request<PublishBatchRequest> marshall(PublishBatchRequest publishBatchRequest) {
        if (publishBatchRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)publishBatchRequest, "AmazonSNS");
        request.addParameter("Action", "PublishBatch");
        request.addParameter("Version", "2010-03-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (publishBatchRequest.getTopicArn() != null) {
            request.addParameter("TopicArn", StringUtils.fromString((String)publishBatchRequest.getTopicArn()));
        }
        if (!publishBatchRequest.getPublishBatchRequestEntries().isEmpty() || !((SdkInternalList)publishBatchRequest.getPublishBatchRequestEntries()).isAutoConstruct()) {
            SdkInternalList publishBatchRequestEntriesList = (SdkInternalList)publishBatchRequest.getPublishBatchRequestEntries();
            int publishBatchRequestEntriesListIndex = 1;
            for (PublishBatchRequestEntry publishBatchRequestEntriesListValue : publishBatchRequestEntriesList) {
                if (publishBatchRequestEntriesListValue != null) {
                    if (publishBatchRequestEntriesListValue.getId() != null) {
                        request.addParameter("PublishBatchRequestEntries.member." + publishBatchRequestEntriesListIndex + ".Id", StringUtils.fromString((String)publishBatchRequestEntriesListValue.getId()));
                    }
                    if (publishBatchRequestEntriesListValue.getMessage() != null) {
                        request.addParameter("PublishBatchRequestEntries.member." + publishBatchRequestEntriesListIndex + ".Message", StringUtils.fromString((String)publishBatchRequestEntriesListValue.getMessage()));
                    }
                    if (publishBatchRequestEntriesListValue.getSubject() != null) {
                        request.addParameter("PublishBatchRequestEntries.member." + publishBatchRequestEntriesListIndex + ".Subject", StringUtils.fromString((String)publishBatchRequestEntriesListValue.getSubject()));
                    }
                    if (publishBatchRequestEntriesListValue.getMessageStructure() != null) {
                        request.addParameter("PublishBatchRequestEntries.member." + publishBatchRequestEntriesListIndex + ".MessageStructure", StringUtils.fromString((String)publishBatchRequestEntriesListValue.getMessageStructure()));
                    }
                    Map<String, MessageAttributeValue> messageAttributes = publishBatchRequestEntriesListValue.getMessageAttributes();
                    int messageAttributesListIndex = 1;
                    for (Map.Entry<String, MessageAttributeValue> entry : messageAttributes.entrySet()) {
                        if (entry != null && entry.getKey() != null) {
                            request.addParameter("PublishBatchRequestEntries.member." + publishBatchRequestEntriesListIndex + ".MessageAttributes.entry." + messageAttributesListIndex + ".Name", StringUtils.fromString((String)entry.getKey()));
                        }
                        if (entry != null && entry.getValue() != null) {
                            if (entry.getValue().getDataType() != null) {
                                request.addParameter("PublishBatchRequestEntries.member." + publishBatchRequestEntriesListIndex + ".MessageAttributes.entry." + messageAttributesListIndex + ".Value.DataType", StringUtils.fromString((String)entry.getValue().getDataType()));
                            }
                            if (entry.getValue().getStringValue() != null) {
                                request.addParameter("PublishBatchRequestEntries.member." + publishBatchRequestEntriesListIndex + ".MessageAttributes.entry." + messageAttributesListIndex + ".Value.StringValue", StringUtils.fromString((String)entry.getValue().getStringValue()));
                            }
                            if (entry.getValue().getBinaryValue() != null) {
                                request.addParameter("PublishBatchRequestEntries.member." + publishBatchRequestEntriesListIndex + ".MessageAttributes.entry." + messageAttributesListIndex + ".Value.BinaryValue", StringUtils.fromByteBuffer((ByteBuffer)entry.getValue().getBinaryValue()));
                            }
                        }
                        ++messageAttributesListIndex;
                    }
                    if (publishBatchRequestEntriesListValue.getMessageDeduplicationId() != null) {
                        request.addParameter("PublishBatchRequestEntries.member." + publishBatchRequestEntriesListIndex + ".MessageDeduplicationId", StringUtils.fromString((String)publishBatchRequestEntriesListValue.getMessageDeduplicationId()));
                    }
                    if (publishBatchRequestEntriesListValue.getMessageGroupId() != null) {
                        request.addParameter("PublishBatchRequestEntries.member." + publishBatchRequestEntriesListIndex + ".MessageGroupId", StringUtils.fromString((String)publishBatchRequestEntriesListValue.getMessageGroupId()));
                    }
                }
                ++publishBatchRequestEntriesListIndex;
            }
        }
        return request;
    }
}

