/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.security;

import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.ErrorResponse;
import org.opensearch.client.opensearch._types.RequestBase;
import org.opensearch.client.opensearch.security.PatchActionGroupResponse;
import org.opensearch.client.opensearch.security.PatchOperation;
import org.opensearch.client.transport.Endpoint;
import org.opensearch.client.transport.endpoints.SimpleEndpoint;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public final class PatchActionGroupRequest
extends RequestBase
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, PatchActionGroupRequest> {
    @Nonnull
    private final String actionGroup;
    @Nonnull
    private final List<PatchOperation> operations;
    public static final JsonpDeserializer<PatchActionGroupRequest> _DESERIALIZER = PatchActionGroupRequest.createPatchActionGroupRequestDeserializer();
    public static final Endpoint<PatchActionGroupRequest, PatchActionGroupResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<PatchActionGroupRequest, PatchActionGroupResponse>(request -> "PATCH", request -> {
        StringBuilder buf = new StringBuilder();
        buf.append("/_plugins/_security/api/actiongroups/");
        SimpleEndpoint.pathEncode(request.actionGroup, buf);
        return buf.toString();
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        request.applyQueryParameters(params);
        return params;
    }, SimpleEndpoint.emptyMap(), true, PatchActionGroupResponse._DESERIALIZER);

    private PatchActionGroupRequest(Builder builder) {
        super(builder);
        this.actionGroup = ApiTypeHelper.requireNonNull(builder.actionGroup, this, "actionGroup");
        this.operations = ApiTypeHelper.unmodifiableRequired(builder.operations, (Object)this, "operations");
    }

    public static PatchActionGroupRequest of(Function<Builder, ObjectBuilder<PatchActionGroupRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nonnull
    public final String actionGroup() {
        return this.actionGroup;
    }

    @Nonnull
    public final List<PatchOperation> operations() {
        return this.operations;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartArray();
        for (PatchOperation item0 : this.operations) {
            item0.serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static JsonpDeserializer<PatchActionGroupRequest> createPatchActionGroupRequestDeserializer() {
        JsonpDeserializer<List<PatchOperation>> valueDeserializer = JsonpDeserializer.arrayDeserializer(PatchOperation._DESERIALIZER);
        return JsonpDeserializer.of(valueDeserializer.acceptedEvents(), (parser, mapper) -> new Builder().operations((List)valueDeserializer.deserialize((JsonParser)parser, (JsonpMapper)mapper)).build());
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.actionGroup.hashCode();
        result = 31 * result + this.operations.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PatchActionGroupRequest other = (PatchActionGroupRequest)o;
        return this.actionGroup.equals(other.actionGroup) && this.operations.equals(other.operations);
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, PatchActionGroupRequest> {
        private String actionGroup;
        private List<PatchOperation> operations;

        public Builder() {
        }

        private Builder(PatchActionGroupRequest o) {
            super(o);
            this.actionGroup = o.actionGroup;
            this.operations = Builder._listCopy(o.operations);
        }

        private Builder(Builder o) {
            super(o);
            this.actionGroup = o.actionGroup;
            this.operations = Builder._listCopy(o.operations);
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder actionGroup(String value) {
            this.actionGroup = value;
            return this;
        }

        @Nonnull
        public final Builder operations(List<PatchOperation> list) {
            this.operations = Builder._listAddAll(this.operations, list);
            return this;
        }

        @Nonnull
        public final Builder operations(PatchOperation value, PatchOperation ... values) {
            this.operations = Builder._listAdd(this.operations, value, values);
            return this;
        }

        @Nonnull
        public final Builder operations(Function<PatchOperation.Builder, ObjectBuilder<PatchOperation>> fn) {
            return this.operations(fn.apply(new PatchOperation.Builder()).build(), new PatchOperation[0]);
        }

        @Override
        @Nonnull
        public PatchActionGroupRequest build() {
            this._checkSingleUse();
            return new PatchActionGroupRequest(this);
        }
    }
}

