/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.security;

import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.ErrorResponse;
import org.opensearch.client.opensearch._types.RequestBase;
import org.opensearch.client.opensearch.security.CreateUserResponse;
import org.opensearch.client.transport.Endpoint;
import org.opensearch.client.transport.endpoints.SimpleEndpoint;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public final class CreateUserRequest
extends RequestBase
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, CreateUserRequest> {
    @Nonnull
    private final Map<String, String> attributes;
    @Nonnull
    private final List<String> backendRoles;
    @Nullable
    private final String description;
    @Nullable
    private final String hash;
    @Nullable
    private final Boolean hidden;
    @Nonnull
    private final List<String> opendistroSecurityRoles;
    @Nullable
    private final String password;
    @Nullable
    private final Boolean reserved;
    @Nullable
    private final Boolean static_;
    @Nonnull
    private final String username;
    public static final JsonpDeserializer<CreateUserRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, CreateUserRequest::setupCreateUserRequestDeserializer);
    public static final Endpoint<CreateUserRequest, CreateUserResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<CreateUserRequest, CreateUserResponse>(request -> "PUT", request -> {
        StringBuilder buf = new StringBuilder();
        buf.append("/_plugins/_security/api/internalusers/");
        SimpleEndpoint.pathEncode(request.username, buf);
        return buf.toString();
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        request.applyQueryParameters(params);
        return params;
    }, SimpleEndpoint.emptyMap(), true, CreateUserResponse._DESERIALIZER);

    private CreateUserRequest(Builder builder) {
        super(builder);
        this.attributes = ApiTypeHelper.unmodifiable(builder.attributes);
        this.backendRoles = ApiTypeHelper.unmodifiable(builder.backendRoles);
        this.description = builder.description;
        this.hash = builder.hash;
        this.hidden = builder.hidden;
        this.opendistroSecurityRoles = ApiTypeHelper.unmodifiable(builder.opendistroSecurityRoles);
        this.password = builder.password;
        this.reserved = builder.reserved;
        this.static_ = builder.static_;
        this.username = ApiTypeHelper.requireNonNull(builder.username, this, "username");
    }

    public static CreateUserRequest of(Function<Builder, ObjectBuilder<CreateUserRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nonnull
    public final Map<String, String> attributes() {
        return this.attributes;
    }

    @Nonnull
    public final List<String> backendRoles() {
        return this.backendRoles;
    }

    @Nullable
    public final String description() {
        return this.description;
    }

    @Nullable
    public final String hash() {
        return this.hash;
    }

    @Nullable
    public final Boolean hidden() {
        return this.hidden;
    }

    @Nonnull
    public final List<String> opendistroSecurityRoles() {
        return this.opendistroSecurityRoles;
    }

    @Nullable
    public final String password() {
        return this.password;
    }

    @Nullable
    public final Boolean reserved() {
        return this.reserved;
    }

    @Nullable
    public final Boolean static_() {
        return this.static_;
    }

    @Nonnull
    public final String username() {
        return this.username;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.attributes)) {
            generator.writeKey("attributes");
            generator.writeStartObject();
            for (Map.Entry entry : this.attributes.entrySet()) {
                generator.writeKey((String)entry.getKey());
                generator.write((String)entry.getValue());
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.backendRoles)) {
            generator.writeKey("backend_roles");
            generator.writeStartArray();
            for (String string : this.backendRoles) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (this.description != null) {
            generator.writeKey("description");
            generator.write(this.description);
        }
        if (this.hash != null) {
            generator.writeKey("hash");
            generator.write(this.hash);
        }
        if (this.hidden != null) {
            generator.writeKey("hidden");
            generator.write(this.hidden.booleanValue());
        }
        if (ApiTypeHelper.isDefined(this.opendistroSecurityRoles)) {
            generator.writeKey("opendistro_security_roles");
            generator.writeStartArray();
            for (String string : this.opendistroSecurityRoles) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (this.password != null) {
            generator.writeKey("password");
            generator.write(this.password);
        }
        if (this.reserved != null) {
            generator.writeKey("reserved");
            generator.write(this.reserved.booleanValue());
        }
        if (this.static_ != null) {
            generator.writeKey("static");
            generator.write(this.static_.booleanValue());
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupCreateUserRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::attributes, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.stringDeserializer()), "attributes");
        op.add(Builder::backendRoles, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "backend_roles");
        op.add(Builder::description, JsonpDeserializer.stringDeserializer(), "description");
        op.add(Builder::hash, JsonpDeserializer.stringDeserializer(), "hash");
        op.add(Builder::hidden, JsonpDeserializer.booleanDeserializer(), "hidden");
        op.add(Builder::opendistroSecurityRoles, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "opendistro_security_roles");
        op.add(Builder::password, JsonpDeserializer.stringDeserializer(), "password");
        op.add(Builder::reserved, JsonpDeserializer.booleanDeserializer(), "reserved");
        op.add(Builder::static_, JsonpDeserializer.booleanDeserializer(), "static");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.attributes);
        result = 31 * result + Objects.hashCode(this.backendRoles);
        result = 31 * result + Objects.hashCode(this.description);
        result = 31 * result + Objects.hashCode(this.hash);
        result = 31 * result + Objects.hashCode(this.hidden);
        result = 31 * result + Objects.hashCode(this.opendistroSecurityRoles);
        result = 31 * result + Objects.hashCode(this.password);
        result = 31 * result + Objects.hashCode(this.reserved);
        result = 31 * result + Objects.hashCode(this.static_);
        result = 31 * result + this.username.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateUserRequest other = (CreateUserRequest)o;
        return Objects.equals(this.attributes, other.attributes) && Objects.equals(this.backendRoles, other.backendRoles) && Objects.equals(this.description, other.description) && Objects.equals(this.hash, other.hash) && Objects.equals(this.hidden, other.hidden) && Objects.equals(this.opendistroSecurityRoles, other.opendistroSecurityRoles) && Objects.equals(this.password, other.password) && Objects.equals(this.reserved, other.reserved) && Objects.equals(this.static_, other.static_) && this.username.equals(other.username);
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, CreateUserRequest> {
        @Nullable
        private Map<String, String> attributes;
        @Nullable
        private List<String> backendRoles;
        @Nullable
        private String description;
        @Nullable
        private String hash;
        @Nullable
        private Boolean hidden;
        @Nullable
        private List<String> opendistroSecurityRoles;
        @Nullable
        private String password;
        @Nullable
        private Boolean reserved;
        @Nullable
        private Boolean static_;
        private String username;

        public Builder() {
        }

        private Builder(CreateUserRequest o) {
            super(o);
            this.attributes = Builder._mapCopy(o.attributes);
            this.backendRoles = Builder._listCopy(o.backendRoles);
            this.description = o.description;
            this.hash = o.hash;
            this.hidden = o.hidden;
            this.opendistroSecurityRoles = Builder._listCopy(o.opendistroSecurityRoles);
            this.password = o.password;
            this.reserved = o.reserved;
            this.static_ = o.static_;
            this.username = o.username;
        }

        private Builder(Builder o) {
            super(o);
            this.attributes = Builder._mapCopy(o.attributes);
            this.backendRoles = Builder._listCopy(o.backendRoles);
            this.description = o.description;
            this.hash = o.hash;
            this.hidden = o.hidden;
            this.opendistroSecurityRoles = Builder._listCopy(o.opendistroSecurityRoles);
            this.password = o.password;
            this.reserved = o.reserved;
            this.static_ = o.static_;
            this.username = o.username;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder attributes(Map<String, String> map) {
            this.attributes = Builder._mapPutAll(this.attributes, map);
            return this;
        }

        @Nonnull
        public final Builder attributes(String key, String value) {
            this.attributes = Builder._mapPut(this.attributes, key, value);
            return this;
        }

        @Nonnull
        public final Builder backendRoles(List<String> list) {
            this.backendRoles = Builder._listAddAll(this.backendRoles, list);
            return this;
        }

        @Nonnull
        public final Builder backendRoles(String value, String ... values) {
            this.backendRoles = Builder._listAdd(this.backendRoles, value, values);
            return this;
        }

        @Nonnull
        public final Builder description(@Nullable String value) {
            this.description = value;
            return this;
        }

        @Nonnull
        public final Builder hash(@Nullable String value) {
            this.hash = value;
            return this;
        }

        @Nonnull
        public final Builder hidden(@Nullable Boolean value) {
            this.hidden = value;
            return this;
        }

        @Nonnull
        public final Builder opendistroSecurityRoles(List<String> list) {
            this.opendistroSecurityRoles = Builder._listAddAll(this.opendistroSecurityRoles, list);
            return this;
        }

        @Nonnull
        public final Builder opendistroSecurityRoles(String value, String ... values) {
            this.opendistroSecurityRoles = Builder._listAdd(this.opendistroSecurityRoles, value, values);
            return this;
        }

        @Nonnull
        public final Builder password(@Nullable String value) {
            this.password = value;
            return this;
        }

        @Nonnull
        public final Builder reserved(@Nullable Boolean value) {
            this.reserved = value;
            return this;
        }

        @Nonnull
        public final Builder static_(@Nullable Boolean value) {
            this.static_ = value;
            return this;
        }

        @Nonnull
        public final Builder username(String value) {
            this.username = value;
            return this;
        }

        @Override
        @Nonnull
        public CreateUserRequest build() {
            this._checkSingleUse();
            return new CreateUserRequest(this);
        }
    }
}

