/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.security;

import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.ErrorResponse;
import org.opensearch.client.opensearch._types.RequestBase;
import org.opensearch.client.opensearch.security.CreateActionGroupResponse;
import org.opensearch.client.transport.Endpoint;
import org.opensearch.client.transport.endpoints.SimpleEndpoint;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public final class CreateActionGroupRequest
extends RequestBase
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, CreateActionGroupRequest> {
    @Nonnull
    private final String actionGroup;
    @Nonnull
    private final List<String> allowedActions;
    @Nullable
    private final String description;
    @Nullable
    private final Boolean hidden;
    @Nullable
    private final Boolean reserved;
    @Nullable
    private final Boolean static_;
    @Nullable
    private final String type;
    public static final JsonpDeserializer<CreateActionGroupRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, CreateActionGroupRequest::setupCreateActionGroupRequestDeserializer);
    public static final Endpoint<CreateActionGroupRequest, CreateActionGroupResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<CreateActionGroupRequest, CreateActionGroupResponse>(request -> "PUT", request -> {
        StringBuilder buf = new StringBuilder();
        buf.append("/_plugins/_security/api/actiongroups/");
        SimpleEndpoint.pathEncode(request.actionGroup, buf);
        return buf.toString();
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        request.applyQueryParameters(params);
        return params;
    }, SimpleEndpoint.emptyMap(), true, CreateActionGroupResponse._DESERIALIZER);

    private CreateActionGroupRequest(Builder builder) {
        super(builder);
        this.actionGroup = ApiTypeHelper.requireNonNull(builder.actionGroup, this, "actionGroup");
        this.allowedActions = ApiTypeHelper.unmodifiable(builder.allowedActions);
        this.description = builder.description;
        this.hidden = builder.hidden;
        this.reserved = builder.reserved;
        this.static_ = builder.static_;
        this.type = builder.type;
    }

    public static CreateActionGroupRequest of(Function<Builder, ObjectBuilder<CreateActionGroupRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nonnull
    public final String actionGroup() {
        return this.actionGroup;
    }

    @Nonnull
    public final List<String> allowedActions() {
        return this.allowedActions;
    }

    @Nullable
    public final String description() {
        return this.description;
    }

    @Nullable
    public final Boolean hidden() {
        return this.hidden;
    }

    @Nullable
    public final Boolean reserved() {
        return this.reserved;
    }

    @Nullable
    public final Boolean static_() {
        return this.static_;
    }

    @Nullable
    public final String type() {
        return this.type;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.allowedActions)) {
            generator.writeKey("allowed_actions");
            generator.writeStartArray();
            for (String item0 : this.allowedActions) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (this.description != null) {
            generator.writeKey("description");
            generator.write(this.description);
        }
        if (this.hidden != null) {
            generator.writeKey("hidden");
            generator.write(this.hidden.booleanValue());
        }
        if (this.reserved != null) {
            generator.writeKey("reserved");
            generator.write(this.reserved.booleanValue());
        }
        if (this.static_ != null) {
            generator.writeKey("static");
            generator.write(this.static_.booleanValue());
        }
        if (this.type != null) {
            generator.writeKey("type");
            generator.write(this.type);
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupCreateActionGroupRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::allowedActions, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "allowed_actions");
        op.add(Builder::description, JsonpDeserializer.stringDeserializer(), "description");
        op.add(Builder::hidden, JsonpDeserializer.booleanDeserializer(), "hidden");
        op.add(Builder::reserved, JsonpDeserializer.booleanDeserializer(), "reserved");
        op.add(Builder::static_, JsonpDeserializer.booleanDeserializer(), "static");
        op.add(Builder::type, JsonpDeserializer.stringDeserializer(), "type");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.actionGroup.hashCode();
        result = 31 * result + Objects.hashCode(this.allowedActions);
        result = 31 * result + Objects.hashCode(this.description);
        result = 31 * result + Objects.hashCode(this.hidden);
        result = 31 * result + Objects.hashCode(this.reserved);
        result = 31 * result + Objects.hashCode(this.static_);
        result = 31 * result + Objects.hashCode(this.type);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateActionGroupRequest other = (CreateActionGroupRequest)o;
        return this.actionGroup.equals(other.actionGroup) && Objects.equals(this.allowedActions, other.allowedActions) && Objects.equals(this.description, other.description) && Objects.equals(this.hidden, other.hidden) && Objects.equals(this.reserved, other.reserved) && Objects.equals(this.static_, other.static_) && Objects.equals(this.type, other.type);
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, CreateActionGroupRequest> {
        private String actionGroup;
        @Nullable
        private List<String> allowedActions;
        @Nullable
        private String description;
        @Nullable
        private Boolean hidden;
        @Nullable
        private Boolean reserved;
        @Nullable
        private Boolean static_;
        @Nullable
        private String type;

        public Builder() {
        }

        private Builder(CreateActionGroupRequest o) {
            super(o);
            this.actionGroup = o.actionGroup;
            this.allowedActions = Builder._listCopy(o.allowedActions);
            this.description = o.description;
            this.hidden = o.hidden;
            this.reserved = o.reserved;
            this.static_ = o.static_;
            this.type = o.type;
        }

        private Builder(Builder o) {
            super(o);
            this.actionGroup = o.actionGroup;
            this.allowedActions = Builder._listCopy(o.allowedActions);
            this.description = o.description;
            this.hidden = o.hidden;
            this.reserved = o.reserved;
            this.static_ = o.static_;
            this.type = o.type;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder actionGroup(String value) {
            this.actionGroup = value;
            return this;
        }

        @Nonnull
        public final Builder allowedActions(List<String> list) {
            this.allowedActions = Builder._listAddAll(this.allowedActions, list);
            return this;
        }

        @Nonnull
        public final Builder allowedActions(String value, String ... values) {
            this.allowedActions = Builder._listAdd(this.allowedActions, value, values);
            return this;
        }

        @Nonnull
        public final Builder description(@Nullable String value) {
            this.description = value;
            return this;
        }

        @Nonnull
        public final Builder hidden(@Nullable Boolean value) {
            this.hidden = value;
            return this;
        }

        @Nonnull
        public final Builder reserved(@Nullable Boolean value) {
            this.reserved = value;
            return this;
        }

        @Nonnull
        public final Builder static_(@Nullable Boolean value) {
            this.static_ = value;
            return this;
        }

        @Nonnull
        public final Builder type(@Nullable String value) {
            this.type = value;
            return this;
        }

        @Override
        @Nonnull
        public CreateActionGroupRequest build() {
            this._checkSingleUse();
            return new CreateActionGroupRequest(this);
        }
    }
}

