/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.nodes.stats;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch.nodes.stats.CgroupCpuAcctStats;
import org.opensearch.client.opensearch.nodes.stats.CgroupCpuStats;
import org.opensearch.client.opensearch.nodes.stats.CgroupMemoryStats;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class CgroupStats
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, CgroupStats> {
    @Nullable
    private final CgroupCpuStats cpu;
    @Nullable
    private final CgroupCpuAcctStats cpuacct;
    @Nullable
    private final CgroupMemoryStats memory;
    public static final JsonpDeserializer<CgroupStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, CgroupStats::setupCgroupStatsDeserializer);

    private CgroupStats(Builder builder) {
        this.cpu = builder.cpu;
        this.cpuacct = builder.cpuacct;
        this.memory = builder.memory;
    }

    public static CgroupStats of(Function<Builder, ObjectBuilder<CgroupStats>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final CgroupCpuStats cpu() {
        return this.cpu;
    }

    @Nullable
    public final CgroupCpuAcctStats cpuacct() {
        return this.cpuacct;
    }

    @Nullable
    public final CgroupMemoryStats memory() {
        return this.memory;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.cpu != null) {
            generator.writeKey("cpu");
            this.cpu.serialize(generator, mapper);
        }
        if (this.cpuacct != null) {
            generator.writeKey("cpuacct");
            this.cpuacct.serialize(generator, mapper);
        }
        if (this.memory != null) {
            generator.writeKey("memory");
            this.memory.serialize(generator, mapper);
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupCgroupStatsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::cpu, CgroupCpuStats._DESERIALIZER, "cpu");
        op.add(Builder::cpuacct, CgroupCpuAcctStats._DESERIALIZER, "cpuacct");
        op.add(Builder::memory, CgroupMemoryStats._DESERIALIZER, "memory");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.cpu);
        result = 31 * result + Objects.hashCode(this.cpuacct);
        result = 31 * result + Objects.hashCode(this.memory);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CgroupStats other = (CgroupStats)o;
        return Objects.equals(this.cpu, other.cpu) && Objects.equals(this.cpuacct, other.cpuacct) && Objects.equals(this.memory, other.memory);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, CgroupStats> {
        @Nullable
        private CgroupCpuStats cpu;
        @Nullable
        private CgroupCpuAcctStats cpuacct;
        @Nullable
        private CgroupMemoryStats memory;

        public Builder() {
        }

        private Builder(CgroupStats o) {
            this.cpu = o.cpu;
            this.cpuacct = o.cpuacct;
            this.memory = o.memory;
        }

        private Builder(Builder o) {
            this.cpu = o.cpu;
            this.cpuacct = o.cpuacct;
            this.memory = o.memory;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder cpu(@Nullable CgroupCpuStats value) {
            this.cpu = value;
            return this;
        }

        @Nonnull
        public final Builder cpu(Function<CgroupCpuStats.Builder, ObjectBuilder<CgroupCpuStats>> fn) {
            return this.cpu(fn.apply(new CgroupCpuStats.Builder()).build());
        }

        @Nonnull
        public final Builder cpuacct(@Nullable CgroupCpuAcctStats value) {
            this.cpuacct = value;
            return this;
        }

        @Nonnull
        public final Builder cpuacct(Function<CgroupCpuAcctStats.Builder, ObjectBuilder<CgroupCpuAcctStats>> fn) {
            return this.cpuacct(fn.apply(new CgroupCpuAcctStats.Builder()).build());
        }

        @Nonnull
        public final Builder memory(@Nullable CgroupMemoryStats value) {
            this.memory = value;
            return this;
        }

        @Nonnull
        public final Builder memory(Function<CgroupMemoryStats.Builder, ObjectBuilder<CgroupMemoryStats>> fn) {
            return this.memory(fn.apply(new CgroupMemoryStats.Builder()).build());
        }

        @Override
        @Nonnull
        public CgroupStats build() {
            this._checkSingleUse();
            return new CgroupStats(this);
        }
    }
}

