/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.nodes.info;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.JsonpSerializable;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.json.UnionDeserializer;
import org.opensearch.client.opensearch.nodes.info.NodeInfoSettingsTransportTypeConfig;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.TaggedUnion;
import org.opensearch.client.util.TaggedUnionUtils;

@JsonpDeserializable
public class NodeInfoSettingsTransportType
implements TaggedUnion<Kind, Object>,
PlainJsonSerializable {
    private final Kind _kind;
    private final Object _value;
    public static final JsonpDeserializer<NodeInfoSettingsTransportType> _DESERIALIZER = JsonpDeserializer.lazy(NodeInfoSettingsTransportType::buildNodeInfoSettingsTransportTypeDeserializer);

    @Override
    public final Kind _kind() {
        return this._kind;
    }

    @Override
    public final Object _get() {
        return this._value;
    }

    private NodeInfoSettingsTransportType(Kind kind, Object value) {
        this._kind = kind;
        this._value = value;
    }

    private NodeInfoSettingsTransportType(Builder builder) {
        this._kind = ApiTypeHelper.requireNonNull(builder._kind, builder, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(builder._value, builder, "<variant value>");
    }

    public static NodeInfoSettingsTransportType of(Function<Builder, ObjectBuilder<NodeInfoSettingsTransportType>> fn) {
        return fn.apply(new Builder()).build();
    }

    public boolean isConfig() {
        return this._kind == Kind.Config;
    }

    public NodeInfoSettingsTransportTypeConfig config() {
        return (NodeInfoSettingsTransportTypeConfig)TaggedUnionUtils.get(this, Kind.Config);
    }

    public boolean isType() {
        return this._kind == Kind.Type;
    }

    public String type() {
        return (String)TaggedUnionUtils.get(this, Kind.Type);
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        if (this._value instanceof JsonpSerializable) {
            ((JsonpSerializable)this._value).serialize(generator, mapper);
        } else {
            switch (this._kind.ordinal()) {
                case 1: {
                    generator.write((String)this._value);
                }
            }
        }
    }

    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    private static JsonpDeserializer<NodeInfoSettingsTransportType> buildNodeInfoSettingsTransportTypeDeserializer() {
        return new UnionDeserializer.Builder<NodeInfoSettingsTransportType, Kind, Object>(NodeInfoSettingsTransportType::new, false).addMember(Kind.Config, NodeInfoSettingsTransportTypeConfig._DESERIALIZER).addMember(Kind.Type, JsonpDeserializer.stringDeserializer()).build();
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode((Object)this._kind);
        result = 31 * result + Objects.hashCode(this._value);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodeInfoSettingsTransportType other = (NodeInfoSettingsTransportType)o;
        return Objects.equals((Object)this._kind, (Object)other._kind) && Objects.equals(this._value, other._value);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<NodeInfoSettingsTransportType> {
        private Kind _kind;
        private Object _value;

        public Builder() {
        }

        private Builder(NodeInfoSettingsTransportType o) {
            this._kind = o._kind;
            this._value = o._value;
        }

        public ObjectBuilder<NodeInfoSettingsTransportType> config(NodeInfoSettingsTransportTypeConfig v) {
            this._kind = Kind.Config;
            this._value = v;
            return this;
        }

        public ObjectBuilder<NodeInfoSettingsTransportType> config(Function<NodeInfoSettingsTransportTypeConfig.Builder, ObjectBuilder<NodeInfoSettingsTransportTypeConfig>> fn) {
            return this.config(fn.apply(new NodeInfoSettingsTransportTypeConfig.Builder()).build());
        }

        public ObjectBuilder<NodeInfoSettingsTransportType> type(String v) {
            this._kind = Kind.Type;
            this._value = v;
            return this;
        }

        @Override
        public NodeInfoSettingsTransportType build() {
            this._checkSingleUse();
            return new NodeInfoSettingsTransportType(this);
        }
    }

    public static enum Kind {
        Config,
        Type;

    }
}

