/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.ism;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch.ism.Action;
import org.opensearch.client.opensearch.ism.Transition;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class States
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, States> {
    @Nonnull
    private final List<Action> actions;
    @Nullable
    private final String name;
    @Nonnull
    private final List<Transition> transitions;
    public static final JsonpDeserializer<States> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, States::setupStatesDeserializer);

    private States(Builder builder) {
        this.actions = ApiTypeHelper.unmodifiable(builder.actions);
        this.name = builder.name;
        this.transitions = ApiTypeHelper.unmodifiable(builder.transitions);
    }

    public static States of(Function<Builder, ObjectBuilder<States>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nonnull
    public final List<Action> actions() {
        return this.actions;
    }

    @Nullable
    public final String name() {
        return this.name;
    }

    @Nonnull
    public final List<Transition> transitions() {
        return this.transitions;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.actions)) {
            generator.writeKey("actions");
            generator.writeStartArray();
            for (Action action : this.actions) {
                action.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.name != null) {
            generator.writeKey("name");
            generator.write(this.name);
        }
        if (ApiTypeHelper.isDefined(this.transitions)) {
            generator.writeKey("transitions");
            generator.writeStartArray();
            for (Transition transition : this.transitions) {
                transition.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupStatesDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::actions, JsonpDeserializer.arrayDeserializer(Action._DESERIALIZER), "actions");
        op.add(Builder::name, JsonpDeserializer.stringDeserializer(), "name");
        op.add(Builder::transitions, JsonpDeserializer.arrayDeserializer(Transition._DESERIALIZER), "transitions");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.actions);
        result = 31 * result + Objects.hashCode(this.name);
        result = 31 * result + Objects.hashCode(this.transitions);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        States other = (States)o;
        return Objects.equals(this.actions, other.actions) && Objects.equals(this.name, other.name) && Objects.equals(this.transitions, other.transitions);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, States> {
        @Nullable
        private List<Action> actions;
        @Nullable
        private String name;
        @Nullable
        private List<Transition> transitions;

        public Builder() {
        }

        private Builder(States o) {
            this.actions = Builder._listCopy(o.actions);
            this.name = o.name;
            this.transitions = Builder._listCopy(o.transitions);
        }

        private Builder(Builder o) {
            this.actions = Builder._listCopy(o.actions);
            this.name = o.name;
            this.transitions = Builder._listCopy(o.transitions);
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder actions(List<Action> list) {
            this.actions = Builder._listAddAll(this.actions, list);
            return this;
        }

        @Nonnull
        public final Builder actions(Action value, Action ... values) {
            this.actions = Builder._listAdd(this.actions, value, values);
            return this;
        }

        @Nonnull
        public final Builder actions(Function<Action.Builder, ObjectBuilder<Action>> fn) {
            return this.actions(fn.apply(new Action.Builder()).build(), new Action[0]);
        }

        @Nonnull
        public final Builder name(@Nullable String value) {
            this.name = value;
            return this;
        }

        @Nonnull
        public final Builder transitions(List<Transition> list) {
            this.transitions = Builder._listAddAll(this.transitions, list);
            return this;
        }

        @Nonnull
        public final Builder transitions(Transition value, Transition ... values) {
            this.transitions = Builder._listAdd(this.transitions, value, values);
            return this;
        }

        @Nonnull
        public final Builder transitions(Function<Transition.Builder, ObjectBuilder<Transition>> fn) {
            return this.transitions(fn.apply(new Transition.Builder()).build(), new Transition[0]);
        }

        @Override
        @Nonnull
        public States build() {
            this._checkSingleUse();
            return new States(this);
        }
    }
}

