/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.core.search;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch.core.search.AggregationProfile;
import org.opensearch.client.opensearch.core.search.FetchProfile;
import org.opensearch.client.opensearch.core.search.SearchProfile;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class ShardProfile
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, ShardProfile> {
    @Nonnull
    private final List<AggregationProfile> aggregations;
    @Nullable
    private final FetchProfile fetch;
    @Nonnull
    private final String id;
    @Nonnull
    private final List<SearchProfile> searches;
    public static final JsonpDeserializer<ShardProfile> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ShardProfile::setupShardProfileDeserializer);

    private ShardProfile(Builder builder) {
        this.aggregations = ApiTypeHelper.unmodifiableRequired(builder.aggregations, (Object)this, "aggregations");
        this.fetch = builder.fetch;
        this.id = ApiTypeHelper.requireNonNull(builder.id, this, "id");
        this.searches = ApiTypeHelper.unmodifiableRequired(builder.searches, (Object)this, "searches");
    }

    public static ShardProfile of(Function<Builder, ObjectBuilder<ShardProfile>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nonnull
    public final List<AggregationProfile> aggregations() {
        return this.aggregations;
    }

    @Nullable
    public final FetchProfile fetch() {
        return this.fetch;
    }

    @Nonnull
    public final String id() {
        return this.id;
    }

    @Nonnull
    public final List<SearchProfile> searches() {
        return this.searches;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("aggregations");
        generator.writeStartArray();
        for (AggregationProfile aggregationProfile : this.aggregations) {
            aggregationProfile.serialize(generator, mapper);
        }
        generator.writeEnd();
        if (this.fetch != null) {
            generator.writeKey("fetch");
            this.fetch.serialize(generator, mapper);
        }
        generator.writeKey("id");
        generator.write(this.id);
        generator.writeKey("searches");
        generator.writeStartArray();
        for (SearchProfile searchProfile : this.searches) {
            searchProfile.serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupShardProfileDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::aggregations, JsonpDeserializer.arrayDeserializer(AggregationProfile._DESERIALIZER), "aggregations");
        op.add(Builder::fetch, FetchProfile._DESERIALIZER, "fetch");
        op.add(Builder::id, JsonpDeserializer.stringDeserializer(), "id");
        op.add(Builder::searches, JsonpDeserializer.arrayDeserializer(SearchProfile._DESERIALIZER), "searches");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.aggregations.hashCode();
        result = 31 * result + Objects.hashCode(this.fetch);
        result = 31 * result + this.id.hashCode();
        result = 31 * result + this.searches.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShardProfile other = (ShardProfile)o;
        return this.aggregations.equals(other.aggregations) && Objects.equals(this.fetch, other.fetch) && this.id.equals(other.id) && this.searches.equals(other.searches);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, ShardProfile> {
        private List<AggregationProfile> aggregations;
        @Nullable
        private FetchProfile fetch;
        private String id;
        private List<SearchProfile> searches;

        public Builder() {
        }

        private Builder(ShardProfile o) {
            this.aggregations = Builder._listCopy(o.aggregations);
            this.fetch = o.fetch;
            this.id = o.id;
            this.searches = Builder._listCopy(o.searches);
        }

        private Builder(Builder o) {
            this.aggregations = Builder._listCopy(o.aggregations);
            this.fetch = o.fetch;
            this.id = o.id;
            this.searches = Builder._listCopy(o.searches);
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder aggregations(List<AggregationProfile> list) {
            this.aggregations = Builder._listAddAll(this.aggregations, list);
            return this;
        }

        @Nonnull
        public final Builder aggregations(AggregationProfile value, AggregationProfile ... values) {
            this.aggregations = Builder._listAdd(this.aggregations, value, values);
            return this;
        }

        @Nonnull
        public final Builder aggregations(Function<AggregationProfile.Builder, ObjectBuilder<AggregationProfile>> fn) {
            return this.aggregations(fn.apply(new AggregationProfile.Builder()).build(), new AggregationProfile[0]);
        }

        @Nonnull
        public final Builder fetch(@Nullable FetchProfile value) {
            this.fetch = value;
            return this;
        }

        @Nonnull
        public final Builder fetch(Function<FetchProfile.Builder, ObjectBuilder<FetchProfile>> fn) {
            return this.fetch(fn.apply(new FetchProfile.Builder()).build());
        }

        @Nonnull
        public final Builder id(String value) {
            this.id = value;
            return this;
        }

        @Nonnull
        public final Builder searches(List<SearchProfile> list) {
            this.searches = Builder._listAddAll(this.searches, list);
            return this;
        }

        @Nonnull
        public final Builder searches(SearchProfile value, SearchProfile ... values) {
            this.searches = Builder._listAdd(this.searches, value, values);
            return this;
        }

        @Nonnull
        public final Builder searches(Function<SearchProfile.Builder, ObjectBuilder<SearchProfile>> fn) {
            return this.searches(fn.apply(new SearchProfile.Builder()).build(), new SearchProfile[0]);
        }

        @Override
        @Nonnull
        public ShardProfile build() {
            this._checkSingleUse();
            return new ShardProfile(this);
        }
    }
}

