/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.cat;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.opensearch._types.Bytes;
import org.opensearch.client.opensearch._types.ErrorResponse;
import org.opensearch.client.opensearch._types.ExpandWildcard;
import org.opensearch.client.opensearch._types.Time;
import org.opensearch.client.opensearch._types.TimeUnit;
import org.opensearch.client.opensearch.cat.CatRequestBase;
import org.opensearch.client.opensearch.cat.SegmentReplicationResponse;
import org.opensearch.client.transport.Endpoint;
import org.opensearch.client.transport.endpoints.SimpleEndpoint;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

public final class SegmentReplicationRequest
extends CatRequestBase
implements ToCopyableBuilder<Builder, SegmentReplicationRequest> {
    @Nullable
    private final Boolean activeOnly;
    @Nullable
    private final Boolean allowNoIndices;
    @Nullable
    private final Bytes bytes;
    @Nullable
    private final Boolean completedOnly;
    @Nullable
    private final Boolean detailed;
    @Nonnull
    private final List<ExpandWildcard> expandWildcards;
    @Nullable
    private final Boolean ignoreThrottled;
    @Nullable
    private final Boolean ignoreUnavailable;
    @Nonnull
    private final List<String> index;
    @Nonnull
    private final List<String> shards;
    @Nullable
    private final TimeUnit time;
    @Nullable
    private final Time timeout;
    public static final Endpoint<SegmentReplicationRequest, SegmentReplicationResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<SegmentReplicationRequest, SegmentReplicationResponse>(request -> "GET", request -> {
        boolean _index = true;
        boolean propsSet = false;
        if (ApiTypeHelper.isDefined(request.index())) {
            propsSet |= true;
        }
        if (!propsSet) {
            return "/_cat/segment_replication";
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_cat/segment_replication/");
            SimpleEndpoint.pathEncode(String.join((CharSequence)",", request.index), buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        request.applyQueryParameters(params);
        return params;
    }, SimpleEndpoint.emptyMap(), false, SegmentReplicationResponse._DESERIALIZER);

    private SegmentReplicationRequest(Builder builder) {
        super(builder);
        this.activeOnly = builder.activeOnly;
        this.allowNoIndices = builder.allowNoIndices;
        this.bytes = builder.bytes;
        this.completedOnly = builder.completedOnly;
        this.detailed = builder.detailed;
        this.expandWildcards = ApiTypeHelper.unmodifiable(builder.expandWildcards);
        this.ignoreThrottled = builder.ignoreThrottled;
        this.ignoreUnavailable = builder.ignoreUnavailable;
        this.index = ApiTypeHelper.unmodifiable(builder.index);
        this.shards = ApiTypeHelper.unmodifiable(builder.shards);
        this.time = builder.time;
        this.timeout = builder.timeout;
    }

    public static SegmentReplicationRequest of(Function<Builder, ObjectBuilder<SegmentReplicationRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Boolean activeOnly() {
        return this.activeOnly;
    }

    @Nullable
    public final Boolean allowNoIndices() {
        return this.allowNoIndices;
    }

    @Nullable
    public final Bytes bytes() {
        return this.bytes;
    }

    @Nullable
    public final Boolean completedOnly() {
        return this.completedOnly;
    }

    @Nullable
    public final Boolean detailed() {
        return this.detailed;
    }

    @Nonnull
    public final List<ExpandWildcard> expandWildcards() {
        return this.expandWildcards;
    }

    @Nullable
    public final Boolean ignoreThrottled() {
        return this.ignoreThrottled;
    }

    @Nullable
    public final Boolean ignoreUnavailable() {
        return this.ignoreUnavailable;
    }

    @Nonnull
    public final List<String> index() {
        return this.index;
    }

    @Nonnull
    public final List<String> shards() {
        return this.shards;
    }

    @Nullable
    public final TimeUnit time() {
        return this.time;
    }

    @Nullable
    public final Time timeout() {
        return this.timeout;
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    @Override
    protected void applyQueryParameters(@Nonnull Map<String, String> params) {
        super.applyQueryParameters(params);
        if (this.activeOnly != null) {
            params.put("active_only", String.valueOf(this.activeOnly));
        }
        if (this.allowNoIndices != null) {
            params.put("allow_no_indices", String.valueOf(this.allowNoIndices));
        }
        if (this.bytes != null) {
            params.put("bytes", this.bytes.jsonValue());
        }
        if (this.completedOnly != null) {
            params.put("completed_only", String.valueOf(this.completedOnly));
        }
        if (this.detailed != null) {
            params.put("detailed", String.valueOf(this.detailed));
        }
        if (ApiTypeHelper.isDefined(this.expandWildcards)) {
            params.put("expand_wildcards", this.expandWildcards.stream().map(v -> v.jsonValue()).collect(Collectors.joining(",")));
        }
        if (this.ignoreThrottled != null) {
            params.put("ignore_throttled", String.valueOf(this.ignoreThrottled));
        }
        if (this.ignoreUnavailable != null) {
            params.put("ignore_unavailable", String.valueOf(this.ignoreUnavailable));
        }
        if (ApiTypeHelper.isDefined(this.shards)) {
            params.put("shards", String.join((CharSequence)",", this.shards));
        }
        if (this.time != null) {
            params.put("time", this.time.jsonValue());
        }
        if (this.timeout != null) {
            params.put("timeout", this.timeout._toJsonString());
        }
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.activeOnly);
        result = 31 * result + Objects.hashCode(this.allowNoIndices);
        result = 31 * result + Objects.hashCode(this.bytes);
        result = 31 * result + Objects.hashCode(this.completedOnly);
        result = 31 * result + Objects.hashCode(this.detailed);
        result = 31 * result + Objects.hashCode(this.expandWildcards);
        result = 31 * result + Objects.hashCode(this.ignoreThrottled);
        result = 31 * result + Objects.hashCode(this.ignoreUnavailable);
        result = 31 * result + Objects.hashCode(this.index);
        result = 31 * result + Objects.hashCode(this.shards);
        result = 31 * result + Objects.hashCode(this.time);
        result = 31 * result + Objects.hashCode(this.timeout);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SegmentReplicationRequest other = (SegmentReplicationRequest)o;
        return Objects.equals(this.activeOnly, other.activeOnly) && Objects.equals(this.allowNoIndices, other.allowNoIndices) && Objects.equals(this.bytes, other.bytes) && Objects.equals(this.completedOnly, other.completedOnly) && Objects.equals(this.detailed, other.detailed) && Objects.equals(this.expandWildcards, other.expandWildcards) && Objects.equals(this.ignoreThrottled, other.ignoreThrottled) && Objects.equals(this.ignoreUnavailable, other.ignoreUnavailable) && Objects.equals(this.index, other.index) && Objects.equals(this.shards, other.shards) && Objects.equals(this.time, other.time) && Objects.equals(this.timeout, other.timeout);
    }

    public static class Builder
    extends CatRequestBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, SegmentReplicationRequest> {
        @Nullable
        private Boolean activeOnly;
        @Nullable
        private Boolean allowNoIndices;
        @Nullable
        private Bytes bytes;
        @Nullable
        private Boolean completedOnly;
        @Nullable
        private Boolean detailed;
        @Nullable
        private List<ExpandWildcard> expandWildcards;
        @Nullable
        private Boolean ignoreThrottled;
        @Nullable
        private Boolean ignoreUnavailable;
        @Nullable
        private List<String> index;
        @Nullable
        private List<String> shards;
        @Nullable
        private TimeUnit time;
        @Nullable
        private Time timeout;

        public Builder() {
        }

        private Builder(SegmentReplicationRequest o) {
            super(o);
            this.activeOnly = o.activeOnly;
            this.allowNoIndices = o.allowNoIndices;
            this.bytes = o.bytes;
            this.completedOnly = o.completedOnly;
            this.detailed = o.detailed;
            this.expandWildcards = Builder._listCopy(o.expandWildcards);
            this.ignoreThrottled = o.ignoreThrottled;
            this.ignoreUnavailable = o.ignoreUnavailable;
            this.index = Builder._listCopy(o.index);
            this.shards = Builder._listCopy(o.shards);
            this.time = o.time;
            this.timeout = o.timeout;
        }

        private Builder(Builder o) {
            super(o);
            this.activeOnly = o.activeOnly;
            this.allowNoIndices = o.allowNoIndices;
            this.bytes = o.bytes;
            this.completedOnly = o.completedOnly;
            this.detailed = o.detailed;
            this.expandWildcards = Builder._listCopy(o.expandWildcards);
            this.ignoreThrottled = o.ignoreThrottled;
            this.ignoreUnavailable = o.ignoreUnavailable;
            this.index = Builder._listCopy(o.index);
            this.shards = Builder._listCopy(o.shards);
            this.time = o.time;
            this.timeout = o.timeout;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder activeOnly(@Nullable Boolean value) {
            this.activeOnly = value;
            return this;
        }

        @Nonnull
        public final Builder allowNoIndices(@Nullable Boolean value) {
            this.allowNoIndices = value;
            return this;
        }

        @Nonnull
        public final Builder bytes(@Nullable Bytes value) {
            this.bytes = value;
            return this;
        }

        @Nonnull
        public final Builder completedOnly(@Nullable Boolean value) {
            this.completedOnly = value;
            return this;
        }

        @Nonnull
        public final Builder detailed(@Nullable Boolean value) {
            this.detailed = value;
            return this;
        }

        @Nonnull
        public final Builder expandWildcards(List<ExpandWildcard> list) {
            this.expandWildcards = Builder._listAddAll(this.expandWildcards, list);
            return this;
        }

        @Nonnull
        public final Builder expandWildcards(ExpandWildcard value, ExpandWildcard ... values) {
            this.expandWildcards = Builder._listAdd(this.expandWildcards, value, values);
            return this;
        }

        @Nonnull
        public final Builder ignoreThrottled(@Nullable Boolean value) {
            this.ignoreThrottled = value;
            return this;
        }

        @Nonnull
        public final Builder ignoreUnavailable(@Nullable Boolean value) {
            this.ignoreUnavailable = value;
            return this;
        }

        @Nonnull
        public final Builder index(List<String> list) {
            this.index = Builder._listAddAll(this.index, list);
            return this;
        }

        @Nonnull
        public final Builder index(String value, String ... values) {
            this.index = Builder._listAdd(this.index, value, values);
            return this;
        }

        @Nonnull
        public final Builder shards(List<String> list) {
            this.shards = Builder._listAddAll(this.shards, list);
            return this;
        }

        @Nonnull
        public final Builder shards(String value, String ... values) {
            this.shards = Builder._listAdd(this.shards, value, values);
            return this;
        }

        @Nonnull
        public final Builder time(@Nullable TimeUnit value) {
            this.time = value;
            return this;
        }

        @Nonnull
        public final Builder timeout(@Nullable Time value) {
            this.timeout = value;
            return this;
        }

        @Nonnull
        public final Builder timeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.timeout(fn.apply(new Time.Builder()).build());
        }

        @Override
        @Nonnull
        public SegmentReplicationRequest build() {
            this._checkSingleUse();
            return new SegmentReplicationRequest(this);
        }
    }
}

