/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.query_dsl;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch._types.query_dsl.QueryBase;
import org.opensearch.client.opensearch._types.query_dsl.QueryVariant;
import org.opensearch.client.opensearch._types.query_dsl.SpanQuery;
import org.opensearch.client.opensearch._types.query_dsl.SpanQueryVariant;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class SpanFieldMaskingQuery
extends QueryBase
implements QueryVariant,
SpanQueryVariant,
ToCopyableBuilder<Builder, SpanFieldMaskingQuery> {
    @Nonnull
    private final String field;
    @Nonnull
    private final SpanQuery query;
    public static final JsonpDeserializer<SpanFieldMaskingQuery> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SpanFieldMaskingQuery::setupSpanFieldMaskingQueryDeserializer);

    private SpanFieldMaskingQuery(Builder builder) {
        super(builder);
        this.field = ApiTypeHelper.requireNonNull(builder.field, this, "field");
        this.query = ApiTypeHelper.requireNonNull(builder.query, this, "query");
    }

    public static SpanFieldMaskingQuery of(Function<Builder, ObjectBuilder<SpanFieldMaskingQuery>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Query.Kind _queryKind() {
        return Query.Kind.FieldMaskingSpan;
    }

    @Override
    public SpanQuery.Kind _spanQueryKind() {
        return SpanQuery.Kind.FieldMaskingSpan;
    }

    @Nonnull
    public final String field() {
        return this.field;
    }

    @Nonnull
    public final SpanQuery query() {
        return this.query;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("field");
        generator.write(this.field);
        generator.writeKey("query");
        this.query.serialize(generator, mapper);
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupSpanFieldMaskingQueryDeserializer(ObjectDeserializer<Builder> op) {
        SpanFieldMaskingQuery.setupQueryBaseDeserializer(op);
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field");
        op.add(Builder::query, SpanQuery._DESERIALIZER, "query");
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.field.hashCode();
        result = 31 * result + this.query.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SpanFieldMaskingQuery other = (SpanFieldMaskingQuery)o;
        return this.field.equals(other.field) && this.query.equals(other.query);
    }

    public static class Builder
    extends QueryBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, SpanFieldMaskingQuery> {
        private String field;
        private SpanQuery query;

        public Builder() {
        }

        private Builder(SpanFieldMaskingQuery o) {
            super(o);
            this.field = o.field;
            this.query = o.query;
        }

        private Builder(Builder o) {
            super(o);
            this.field = o.field;
            this.query = o.query;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder field(String value) {
            this.field = value;
            return this;
        }

        @Nonnull
        public final Builder query(SpanQuery value) {
            this.query = value;
            return this;
        }

        @Nonnull
        public final Builder query(Function<SpanQuery.Builder, ObjectBuilder<SpanQuery>> fn) {
            return this.query(fn.apply(new SpanQuery.Builder()).build());
        }

        @Override
        @Nonnull
        public SpanFieldMaskingQuery build() {
            this._checkSingleUse();
            return new SpanFieldMaskingQuery(this);
        }
    }
}

