/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.query_dsl;

import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.GeoBounds;
import org.opensearch.client.opensearch._types.query_dsl.GeoExecution;
import org.opensearch.client.opensearch._types.query_dsl.GeoValidationMethod;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch._types.query_dsl.QueryBase;
import org.opensearch.client.opensearch._types.query_dsl.QueryVariant;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class GeoBoundingBoxQuery
extends QueryBase
implements QueryVariant,
ToCopyableBuilder<Builder, GeoBoundingBoxQuery> {
    @Nonnull
    private final GeoBounds boundingBox;
    @Nonnull
    private final String field;
    @Nullable
    private final Boolean ignoreUnmapped;
    @Nullable
    private final GeoExecution type;
    @Nullable
    private final GeoValidationMethod validationMethod;
    public static final JsonpDeserializer<GeoBoundingBoxQuery> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GeoBoundingBoxQuery::setupGeoBoundingBoxQueryDeserializer);

    private GeoBoundingBoxQuery(Builder builder) {
        super(builder);
        this.boundingBox = ApiTypeHelper.requireNonNull(builder.boundingBox, this, "boundingBox");
        this.field = ApiTypeHelper.requireNonNull(builder.field, this, "field");
        this.ignoreUnmapped = builder.ignoreUnmapped;
        this.type = builder.type;
        this.validationMethod = builder.validationMethod;
    }

    public static GeoBoundingBoxQuery of(Function<Builder, ObjectBuilder<GeoBoundingBoxQuery>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Query.Kind _queryKind() {
        return Query.Kind.GeoBoundingBox;
    }

    @Nonnull
    public final GeoBounds boundingBox() {
        return this.boundingBox;
    }

    @Nonnull
    public final String field() {
        return this.field;
    }

    @Nullable
    public final Boolean ignoreUnmapped() {
        return this.ignoreUnmapped;
    }

    @Nullable
    public final GeoExecution type() {
        return this.type;
    }

    @Nullable
    public final GeoValidationMethod validationMethod() {
        return this.validationMethod;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey(this.field);
        this.boundingBox.serialize(generator, mapper);
        if (this.ignoreUnmapped != null) {
            generator.writeKey("ignore_unmapped");
            generator.write(this.ignoreUnmapped.booleanValue());
        }
        if (this.type != null) {
            generator.writeKey("type");
            this.type.serialize(generator, mapper);
        }
        if (this.validationMethod != null) {
            generator.writeKey("validation_method");
            this.validationMethod.serialize(generator, mapper);
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupGeoBoundingBoxQueryDeserializer(ObjectDeserializer<Builder> op) {
        GeoBoundingBoxQuery.setupQueryBaseDeserializer(op);
        op.add(Builder::ignoreUnmapped, JsonpDeserializer.booleanDeserializer(), "ignore_unmapped");
        op.add(Builder::type, GeoExecution._DESERIALIZER, "type");
        op.add(Builder::validationMethod, GeoValidationMethod._DESERIALIZER, "validation_method");
        op.setUnknownFieldHandler((builder, name, parser, mapper) -> {
            builder.field((String)name);
            builder.boundingBox(GeoBounds._DESERIALIZER.deserialize((JsonParser)parser, (JsonpMapper)mapper));
        });
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.boundingBox.hashCode();
        result = 31 * result + this.field.hashCode();
        result = 31 * result + Objects.hashCode(this.ignoreUnmapped);
        result = 31 * result + Objects.hashCode(this.type);
        result = 31 * result + Objects.hashCode(this.validationMethod);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GeoBoundingBoxQuery other = (GeoBoundingBoxQuery)o;
        return this.boundingBox.equals(other.boundingBox) && this.field.equals(other.field) && Objects.equals(this.ignoreUnmapped, other.ignoreUnmapped) && Objects.equals(this.type, other.type) && Objects.equals(this.validationMethod, other.validationMethod);
    }

    public static class Builder
    extends QueryBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, GeoBoundingBoxQuery> {
        private GeoBounds boundingBox;
        private String field;
        @Nullable
        private Boolean ignoreUnmapped;
        @Nullable
        private GeoExecution type;
        @Nullable
        private GeoValidationMethod validationMethod;

        public Builder() {
        }

        private Builder(GeoBoundingBoxQuery o) {
            super(o);
            this.boundingBox = o.boundingBox;
            this.field = o.field;
            this.ignoreUnmapped = o.ignoreUnmapped;
            this.type = o.type;
            this.validationMethod = o.validationMethod;
        }

        private Builder(Builder o) {
            super(o);
            this.boundingBox = o.boundingBox;
            this.field = o.field;
            this.ignoreUnmapped = o.ignoreUnmapped;
            this.type = o.type;
            this.validationMethod = o.validationMethod;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder boundingBox(GeoBounds value) {
            this.boundingBox = value;
            return this;
        }

        @Nonnull
        public final Builder boundingBox(Function<GeoBounds.Builder, ObjectBuilder<GeoBounds>> fn) {
            return this.boundingBox(fn.apply(new GeoBounds.Builder()).build());
        }

        @Nonnull
        public final Builder field(String value) {
            this.field = value;
            return this;
        }

        @Nonnull
        public final Builder ignoreUnmapped(@Nullable Boolean value) {
            this.ignoreUnmapped = value;
            return this;
        }

        @Nonnull
        public final Builder type(@Nullable GeoExecution value) {
            this.type = value;
            return this;
        }

        @Nonnull
        public final Builder validationMethod(@Nullable GeoValidationMethod value) {
            this.validationMethod = value;
            return this;
        }

        @Override
        @Nonnull
        public GeoBoundingBoxQuery build() {
            this._checkSingleUse();
            return new GeoBoundingBoxQuery(this);
        }
    }
}

