/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.query_dsl;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.query_dsl.FieldValueFactorModifier;
import org.opensearch.client.opensearch._types.query_dsl.FunctionScore;
import org.opensearch.client.opensearch._types.query_dsl.FunctionScoreVariant;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class FieldValueFactorScoreFunction
implements FunctionScoreVariant,
PlainJsonSerializable,
ToCopyableBuilder<Builder, FieldValueFactorScoreFunction> {
    @Nullable
    private final Float factor;
    @Nonnull
    private final String field;
    @Nullable
    private final Double missing;
    @Nullable
    private final FieldValueFactorModifier modifier;
    public static final JsonpDeserializer<FieldValueFactorScoreFunction> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, FieldValueFactorScoreFunction::setupFieldValueFactorScoreFunctionDeserializer);

    private FieldValueFactorScoreFunction(Builder builder) {
        this.factor = builder.factor;
        this.field = ApiTypeHelper.requireNonNull(builder.field, this, "field");
        this.missing = builder.missing;
        this.modifier = builder.modifier;
    }

    public static FieldValueFactorScoreFunction of(Function<Builder, ObjectBuilder<FieldValueFactorScoreFunction>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public FunctionScore.Kind _functionScoreKind() {
        return FunctionScore.Kind.FieldValueFactor;
    }

    @Nullable
    public final Float factor() {
        return this.factor;
    }

    @Nonnull
    public final String field() {
        return this.field;
    }

    @Nullable
    public final Double missing() {
        return this.missing;
    }

    @Nullable
    public final FieldValueFactorModifier modifier() {
        return this.modifier;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.factor != null) {
            generator.writeKey("factor");
            generator.write((double)this.factor.floatValue());
        }
        generator.writeKey("field");
        generator.write(this.field);
        if (this.missing != null) {
            generator.writeKey("missing");
            generator.write(this.missing.doubleValue());
        }
        if (this.modifier != null) {
            generator.writeKey("modifier");
            this.modifier.serialize(generator, mapper);
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupFieldValueFactorScoreFunctionDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::factor, JsonpDeserializer.floatDeserializer(), "factor");
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field");
        op.add(Builder::missing, JsonpDeserializer.doubleDeserializer(), "missing");
        op.add(Builder::modifier, FieldValueFactorModifier._DESERIALIZER, "modifier");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.factor);
        result = 31 * result + this.field.hashCode();
        result = 31 * result + Objects.hashCode(this.missing);
        result = 31 * result + Objects.hashCode(this.modifier);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FieldValueFactorScoreFunction other = (FieldValueFactorScoreFunction)o;
        return Objects.equals(this.factor, other.factor) && this.field.equals(other.field) && Objects.equals(this.missing, other.missing) && Objects.equals(this.modifier, other.modifier);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, FieldValueFactorScoreFunction> {
        @Nullable
        private Float factor;
        private String field;
        @Nullable
        private Double missing;
        @Nullable
        private FieldValueFactorModifier modifier;

        public Builder() {
        }

        private Builder(FieldValueFactorScoreFunction o) {
            this.factor = o.factor;
            this.field = o.field;
            this.missing = o.missing;
            this.modifier = o.modifier;
        }

        private Builder(Builder o) {
            this.factor = o.factor;
            this.field = o.field;
            this.missing = o.missing;
            this.modifier = o.modifier;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder factor(@Nullable Float value) {
            this.factor = value;
            return this;
        }

        @Nonnull
        public final Builder field(String value) {
            this.field = value;
            return this;
        }

        @Nonnull
        public final Builder missing(@Nullable Double value) {
            this.missing = value;
            return this;
        }

        @Nonnull
        public final Builder modifier(@Nullable FieldValueFactorModifier value) {
            this.modifier = value;
            return this;
        }

        @Override
        @Nonnull
        public FieldValueFactorScoreFunction build() {
            this._checkSingleUse();
            return new FieldValueFactorScoreFunction(this);
        }
    }
}

