/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.analysis;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.analysis.TokenizerBase;
import org.opensearch.client.opensearch._types.analysis.TokenizerDefinition;
import org.opensearch.client.opensearch._types.analysis.TokenizerDefinitionVariant;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class PatternTokenizer
extends TokenizerBase
implements TokenizerDefinitionVariant,
ToCopyableBuilder<Builder, PatternTokenizer> {
    @Nullable
    private final String flags;
    @Nullable
    private final Integer group;
    @Nullable
    private final String pattern;
    public static final JsonpDeserializer<PatternTokenizer> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PatternTokenizer::setupPatternTokenizerDeserializer);

    private PatternTokenizer(Builder builder) {
        super(builder);
        this.flags = builder.flags;
        this.group = builder.group;
        this.pattern = builder.pattern;
    }

    public static PatternTokenizer of(Function<Builder, ObjectBuilder<PatternTokenizer>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public TokenizerDefinition.Kind _tokenizerDefinitionKind() {
        return TokenizerDefinition.Kind.Pattern;
    }

    @Nullable
    public final String flags() {
        return this.flags;
    }

    @Nullable
    public final Integer group() {
        return this.group;
    }

    @Nullable
    public final String pattern() {
        return this.pattern;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "pattern");
        super.serializeInternal(generator, mapper);
        if (this.flags != null) {
            generator.writeKey("flags");
            generator.write(this.flags);
        }
        if (this.group != null) {
            generator.writeKey("group");
            generator.write(this.group.intValue());
        }
        if (this.pattern != null) {
            generator.writeKey("pattern");
            generator.write(this.pattern);
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupPatternTokenizerDeserializer(ObjectDeserializer<Builder> op) {
        PatternTokenizer.setupTokenizerBaseDeserializer(op);
        op.add(Builder::flags, JsonpDeserializer.stringDeserializer(), "flags");
        op.add(Builder::group, JsonpDeserializer.integerDeserializer(), "group");
        op.add(Builder::pattern, JsonpDeserializer.stringDeserializer(), "pattern");
        op.ignore("type");
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.flags);
        result = 31 * result + Objects.hashCode(this.group);
        result = 31 * result + Objects.hashCode(this.pattern);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PatternTokenizer other = (PatternTokenizer)o;
        return Objects.equals(this.flags, other.flags) && Objects.equals(this.group, other.group) && Objects.equals(this.pattern, other.pattern);
    }

    public static class Builder
    extends TokenizerBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, PatternTokenizer> {
        @Nullable
        private String flags;
        @Nullable
        private Integer group;
        @Nullable
        private String pattern;

        public Builder() {
        }

        private Builder(PatternTokenizer o) {
            super(o);
            this.flags = o.flags;
            this.group = o.group;
            this.pattern = o.pattern;
        }

        private Builder(Builder o) {
            super(o);
            this.flags = o.flags;
            this.group = o.group;
            this.pattern = o.pattern;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder flags(@Nullable String value) {
            this.flags = value;
            return this;
        }

        @Nonnull
        public final Builder group(@Nullable Integer value) {
            this.group = value;
            return this;
        }

        @Nonnull
        public final Builder pattern(@Nullable String value) {
            this.pattern = value;
            return this;
        }

        @Override
        @Nonnull
        public PatternTokenizer build() {
            this._checkSingleUse();
            return new PatternTokenizer(this);
        }
    }
}

