/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.aggregations;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.Script;
import org.opensearch.client.opensearch._types.aggregations.Aggregation;
import org.opensearch.client.opensearch._types.aggregations.AggregationVariant;
import org.opensearch.client.opensearch._types.aggregations.BucketAggregationBase;
import org.opensearch.client.opensearch._types.aggregations.SamplerAggregationExecutionHint;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class DiversifiedSamplerAggregation
extends BucketAggregationBase
implements AggregationVariant,
ToCopyableBuilder<Builder, DiversifiedSamplerAggregation> {
    @Nullable
    private final SamplerAggregationExecutionHint executionHint;
    @Nullable
    private final String field;
    @Nullable
    private final Integer maxDocsPerValue;
    @Nullable
    private final Script script;
    @Nullable
    private final Integer shardSize;
    public static final JsonpDeserializer<DiversifiedSamplerAggregation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DiversifiedSamplerAggregation::setupDiversifiedSamplerAggregationDeserializer);

    private DiversifiedSamplerAggregation(Builder builder) {
        super(builder);
        this.executionHint = builder.executionHint;
        this.field = builder.field;
        this.maxDocsPerValue = builder.maxDocsPerValue;
        this.script = builder.script;
        this.shardSize = builder.shardSize;
    }

    public static DiversifiedSamplerAggregation of(Function<Builder, ObjectBuilder<DiversifiedSamplerAggregation>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Aggregation.Kind _aggregationKind() {
        return Aggregation.Kind.DiversifiedSampler;
    }

    @Nullable
    public final SamplerAggregationExecutionHint executionHint() {
        return this.executionHint;
    }

    @Nullable
    public final String field() {
        return this.field;
    }

    @Nullable
    public final Integer maxDocsPerValue() {
        return this.maxDocsPerValue;
    }

    @Nullable
    public final Script script() {
        return this.script;
    }

    @Nullable
    public final Integer shardSize() {
        return this.shardSize;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.executionHint != null) {
            generator.writeKey("execution_hint");
            this.executionHint.serialize(generator, mapper);
        }
        if (this.field != null) {
            generator.writeKey("field");
            generator.write(this.field);
        }
        if (this.maxDocsPerValue != null) {
            generator.writeKey("max_docs_per_value");
            generator.write(this.maxDocsPerValue.intValue());
        }
        if (this.script != null) {
            generator.writeKey("script");
            this.script.serialize(generator, mapper);
        }
        if (this.shardSize != null) {
            generator.writeKey("shard_size");
            generator.write(this.shardSize.intValue());
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupDiversifiedSamplerAggregationDeserializer(ObjectDeserializer<Builder> op) {
        DiversifiedSamplerAggregation.setupBucketAggregationBaseDeserializer(op);
        op.add(Builder::executionHint, SamplerAggregationExecutionHint._DESERIALIZER, "execution_hint");
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field");
        op.add(Builder::maxDocsPerValue, JsonpDeserializer.integerDeserializer(), "max_docs_per_value");
        op.add(Builder::script, Script._DESERIALIZER, "script");
        op.add(Builder::shardSize, JsonpDeserializer.integerDeserializer(), "shard_size");
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.executionHint);
        result = 31 * result + Objects.hashCode(this.field);
        result = 31 * result + Objects.hashCode(this.maxDocsPerValue);
        result = 31 * result + Objects.hashCode(this.script);
        result = 31 * result + Objects.hashCode(this.shardSize);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DiversifiedSamplerAggregation other = (DiversifiedSamplerAggregation)o;
        return Objects.equals(this.executionHint, other.executionHint) && Objects.equals(this.field, other.field) && Objects.equals(this.maxDocsPerValue, other.maxDocsPerValue) && Objects.equals(this.script, other.script) && Objects.equals(this.shardSize, other.shardSize);
    }

    public static class Builder
    extends BucketAggregationBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, DiversifiedSamplerAggregation> {
        @Nullable
        private SamplerAggregationExecutionHint executionHint;
        @Nullable
        private String field;
        @Nullable
        private Integer maxDocsPerValue;
        @Nullable
        private Script script;
        @Nullable
        private Integer shardSize;

        public Builder() {
        }

        private Builder(DiversifiedSamplerAggregation o) {
            super(o);
            this.executionHint = o.executionHint;
            this.field = o.field;
            this.maxDocsPerValue = o.maxDocsPerValue;
            this.script = o.script;
            this.shardSize = o.shardSize;
        }

        private Builder(Builder o) {
            super(o);
            this.executionHint = o.executionHint;
            this.field = o.field;
            this.maxDocsPerValue = o.maxDocsPerValue;
            this.script = o.script;
            this.shardSize = o.shardSize;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder executionHint(@Nullable SamplerAggregationExecutionHint value) {
            this.executionHint = value;
            return this;
        }

        @Nonnull
        public final Builder field(@Nullable String value) {
            this.field = value;
            return this;
        }

        @Nonnull
        public final Builder maxDocsPerValue(@Nullable Integer value) {
            this.maxDocsPerValue = value;
            return this;
        }

        @Nonnull
        public final Builder script(@Nullable Script value) {
            this.script = value;
            return this;
        }

        @Nonnull
        public final Builder script(Function<Script.Builder, ObjectBuilder<Script>> fn) {
            return this.script(fn.apply(new Script.Builder()).build());
        }

        @Nonnull
        public final Builder shardSize(@Nullable Integer value) {
            this.shardSize = value;
            return this;
        }

        @Override
        @Nonnull
        public DiversifiedSamplerAggregation build() {
            this._checkSingleUse();
            return new DiversifiedSamplerAggregation(this);
        }
    }
}

