/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.aggregations;

import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonData;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.Script;
import org.opensearch.client.opensearch._types.Time;
import org.opensearch.client.opensearch._types.aggregations.Aggregation;
import org.opensearch.client.opensearch._types.aggregations.AggregationVariant;
import org.opensearch.client.opensearch._types.aggregations.BucketAggregationBase;
import org.opensearch.client.opensearch._types.aggregations.CalendarInterval;
import org.opensearch.client.opensearch._types.aggregations.ExtendedBounds;
import org.opensearch.client.opensearch._types.aggregations.FieldDateMath;
import org.opensearch.client.opensearch._types.aggregations.HistogramOrder;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class DateHistogramAggregation
extends BucketAggregationBase
implements AggregationVariant,
ToCopyableBuilder<Builder, DateHistogramAggregation> {
    @Nullable
    private final CalendarInterval calendarInterval;
    @Nullable
    private final ExtendedBounds<FieldDateMath> extendedBounds;
    @Nullable
    private final String field;
    @Nullable
    private final Time fixedInterval;
    @Nullable
    private final String format;
    @Nullable
    private final ExtendedBounds<FieldDateMath> hardBounds;
    @Nullable
    private final Time interval;
    @Nullable
    private final Boolean keyed;
    @Nullable
    private final Integer minDocCount;
    @Nullable
    private final String missing;
    @Nullable
    private final Time offset;
    @Nullable
    private final HistogramOrder order;
    @Nonnull
    private final Map<String, JsonData> params;
    @Nullable
    private final Script script;
    @Nullable
    private final String timeZone;
    public static final JsonpDeserializer<DateHistogramAggregation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DateHistogramAggregation::setupDateHistogramAggregationDeserializer);

    private DateHistogramAggregation(Builder builder) {
        super(builder);
        this.calendarInterval = builder.calendarInterval;
        this.extendedBounds = builder.extendedBounds;
        this.field = builder.field;
        this.fixedInterval = builder.fixedInterval;
        this.format = builder.format;
        this.hardBounds = builder.hardBounds;
        this.interval = builder.interval;
        this.keyed = builder.keyed;
        this.minDocCount = builder.minDocCount;
        this.missing = builder.missing;
        this.offset = builder.offset;
        this.order = builder.order;
        this.params = ApiTypeHelper.unmodifiable(builder.params);
        this.script = builder.script;
        this.timeZone = builder.timeZone;
    }

    public static DateHistogramAggregation of(Function<Builder, ObjectBuilder<DateHistogramAggregation>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Aggregation.Kind _aggregationKind() {
        return Aggregation.Kind.DateHistogram;
    }

    @Nullable
    public final CalendarInterval calendarInterval() {
        return this.calendarInterval;
    }

    @Nullable
    public final ExtendedBounds<FieldDateMath> extendedBounds() {
        return this.extendedBounds;
    }

    @Nullable
    public final String field() {
        return this.field;
    }

    @Nullable
    public final Time fixedInterval() {
        return this.fixedInterval;
    }

    @Nullable
    public final String format() {
        return this.format;
    }

    @Nullable
    public final ExtendedBounds<FieldDateMath> hardBounds() {
        return this.hardBounds;
    }

    @Nullable
    public final Time interval() {
        return this.interval;
    }

    @Nullable
    public final Boolean keyed() {
        return this.keyed;
    }

    @Nullable
    public final Integer minDocCount() {
        return this.minDocCount;
    }

    @Nullable
    public final String missing() {
        return this.missing;
    }

    @Nullable
    public final Time offset() {
        return this.offset;
    }

    @Nullable
    public final HistogramOrder order() {
        return this.order;
    }

    @Nonnull
    public final Map<String, JsonData> params() {
        return this.params;
    }

    @Nullable
    public final Script script() {
        return this.script;
    }

    @Nullable
    public final String timeZone() {
        return this.timeZone;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.calendarInterval != null) {
            generator.writeKey("calendar_interval");
            this.calendarInterval.serialize(generator, mapper);
        }
        if (this.extendedBounds != null) {
            generator.writeKey("extended_bounds");
            this.extendedBounds.serialize(generator, mapper);
        }
        if (this.field != null) {
            generator.writeKey("field");
            generator.write(this.field);
        }
        if (this.fixedInterval != null) {
            generator.writeKey("fixed_interval");
            this.fixedInterval.serialize(generator, mapper);
        }
        if (this.format != null) {
            generator.writeKey("format");
            generator.write(this.format);
        }
        if (this.hardBounds != null) {
            generator.writeKey("hard_bounds");
            this.hardBounds.serialize(generator, mapper);
        }
        if (this.interval != null) {
            generator.writeKey("interval");
            this.interval.serialize(generator, mapper);
        }
        if (this.keyed != null) {
            generator.writeKey("keyed");
            generator.write(this.keyed.booleanValue());
        }
        if (this.minDocCount != null) {
            generator.writeKey("min_doc_count");
            generator.write(this.minDocCount.intValue());
        }
        if (this.missing != null) {
            generator.writeKey("missing");
            generator.write(this.missing);
        }
        if (this.offset != null) {
            generator.writeKey("offset");
            this.offset.serialize(generator, mapper);
        }
        if (this.order != null) {
            generator.writeKey("order");
            this.order.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.params)) {
            generator.writeKey("params");
            generator.writeStartObject();
            for (Map.Entry<String, JsonData> item0 : this.params.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.script != null) {
            generator.writeKey("script");
            this.script.serialize(generator, mapper);
        }
        if (this.timeZone != null) {
            generator.writeKey("time_zone");
            generator.write(this.timeZone);
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupDateHistogramAggregationDeserializer(ObjectDeserializer<Builder> op) {
        DateHistogramAggregation.setupBucketAggregationBaseDeserializer(op);
        op.add(Builder::calendarInterval, CalendarInterval._DESERIALIZER, "calendar_interval");
        op.add(Builder::extendedBounds, ExtendedBounds.createExtendedBoundsDeserializer(FieldDateMath._DESERIALIZER), "extended_bounds");
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field");
        op.add(Builder::fixedInterval, Time._DESERIALIZER, "fixed_interval");
        op.add(Builder::format, JsonpDeserializer.stringDeserializer(), "format");
        op.add(Builder::hardBounds, ExtendedBounds.createExtendedBoundsDeserializer(FieldDateMath._DESERIALIZER), "hard_bounds");
        op.add(Builder::interval, Time._DESERIALIZER, "interval");
        op.add(Builder::keyed, JsonpDeserializer.booleanDeserializer(), "keyed");
        op.add(Builder::minDocCount, JsonpDeserializer.integerDeserializer(), "min_doc_count");
        op.add(Builder::missing, JsonpDeserializer.stringDeserializer(), "missing");
        op.add(Builder::offset, Time._DESERIALIZER, "offset");
        op.add(Builder::order, HistogramOrder._DESERIALIZER, "order");
        op.add(Builder::params, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "params");
        op.add(Builder::script, Script._DESERIALIZER, "script");
        op.add(Builder::timeZone, JsonpDeserializer.stringDeserializer(), "time_zone");
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.calendarInterval);
        result = 31 * result + Objects.hashCode(this.extendedBounds);
        result = 31 * result + Objects.hashCode(this.field);
        result = 31 * result + Objects.hashCode(this.fixedInterval);
        result = 31 * result + Objects.hashCode(this.format);
        result = 31 * result + Objects.hashCode(this.hardBounds);
        result = 31 * result + Objects.hashCode(this.interval);
        result = 31 * result + Objects.hashCode(this.keyed);
        result = 31 * result + Objects.hashCode(this.minDocCount);
        result = 31 * result + Objects.hashCode(this.missing);
        result = 31 * result + Objects.hashCode(this.offset);
        result = 31 * result + Objects.hashCode(this.order);
        result = 31 * result + Objects.hashCode(this.params);
        result = 31 * result + Objects.hashCode(this.script);
        result = 31 * result + Objects.hashCode(this.timeZone);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DateHistogramAggregation other = (DateHistogramAggregation)o;
        return Objects.equals(this.calendarInterval, other.calendarInterval) && Objects.equals(this.extendedBounds, other.extendedBounds) && Objects.equals(this.field, other.field) && Objects.equals(this.fixedInterval, other.fixedInterval) && Objects.equals(this.format, other.format) && Objects.equals(this.hardBounds, other.hardBounds) && Objects.equals(this.interval, other.interval) && Objects.equals(this.keyed, other.keyed) && Objects.equals(this.minDocCount, other.minDocCount) && Objects.equals(this.missing, other.missing) && Objects.equals(this.offset, other.offset) && Objects.equals(this.order, other.order) && Objects.equals(this.params, other.params) && Objects.equals(this.script, other.script) && Objects.equals(this.timeZone, other.timeZone);
    }

    public static class Builder
    extends BucketAggregationBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, DateHistogramAggregation> {
        @Nullable
        private CalendarInterval calendarInterval;
        @Nullable
        private ExtendedBounds<FieldDateMath> extendedBounds;
        @Nullable
        private String field;
        @Nullable
        private Time fixedInterval;
        @Nullable
        private String format;
        @Nullable
        private ExtendedBounds<FieldDateMath> hardBounds;
        @Nullable
        private Time interval;
        @Nullable
        private Boolean keyed;
        @Nullable
        private Integer minDocCount;
        @Nullable
        private String missing;
        @Nullable
        private Time offset;
        @Nullable
        private HistogramOrder order;
        @Nullable
        private Map<String, JsonData> params;
        @Nullable
        private Script script;
        @Nullable
        private String timeZone;

        public Builder() {
        }

        private Builder(DateHistogramAggregation o) {
            super(o);
            this.calendarInterval = o.calendarInterval;
            this.extendedBounds = o.extendedBounds;
            this.field = o.field;
            this.fixedInterval = o.fixedInterval;
            this.format = o.format;
            this.hardBounds = o.hardBounds;
            this.interval = o.interval;
            this.keyed = o.keyed;
            this.minDocCount = o.minDocCount;
            this.missing = o.missing;
            this.offset = o.offset;
            this.order = o.order;
            this.params = Builder._mapCopy(o.params);
            this.script = o.script;
            this.timeZone = o.timeZone;
        }

        private Builder(Builder o) {
            super(o);
            this.calendarInterval = o.calendarInterval;
            this.extendedBounds = o.extendedBounds;
            this.field = o.field;
            this.fixedInterval = o.fixedInterval;
            this.format = o.format;
            this.hardBounds = o.hardBounds;
            this.interval = o.interval;
            this.keyed = o.keyed;
            this.minDocCount = o.minDocCount;
            this.missing = o.missing;
            this.offset = o.offset;
            this.order = o.order;
            this.params = Builder._mapCopy(o.params);
            this.script = o.script;
            this.timeZone = o.timeZone;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder calendarInterval(@Nullable CalendarInterval value) {
            this.calendarInterval = value;
            return this;
        }

        @Nonnull
        public final Builder extendedBounds(@Nullable ExtendedBounds<FieldDateMath> value) {
            this.extendedBounds = value;
            return this;
        }

        @Nonnull
        public final Builder extendedBounds(Function<ExtendedBounds.Builder<FieldDateMath>, ObjectBuilder<ExtendedBounds<FieldDateMath>>> fn) {
            return this.extendedBounds(fn.apply(new ExtendedBounds.Builder()).build());
        }

        @Nonnull
        public final Builder field(@Nullable String value) {
            this.field = value;
            return this;
        }

        @Nonnull
        public final Builder fixedInterval(@Nullable Time value) {
            this.fixedInterval = value;
            return this;
        }

        @Nonnull
        public final Builder fixedInterval(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.fixedInterval(fn.apply(new Time.Builder()).build());
        }

        @Nonnull
        public final Builder format(@Nullable String value) {
            this.format = value;
            return this;
        }

        @Nonnull
        public final Builder hardBounds(@Nullable ExtendedBounds<FieldDateMath> value) {
            this.hardBounds = value;
            return this;
        }

        @Nonnull
        public final Builder hardBounds(Function<ExtendedBounds.Builder<FieldDateMath>, ObjectBuilder<ExtendedBounds<FieldDateMath>>> fn) {
            return this.hardBounds(fn.apply(new ExtendedBounds.Builder()).build());
        }

        @Nonnull
        public final Builder interval(@Nullable Time value) {
            this.interval = value;
            return this;
        }

        @Nonnull
        public final Builder interval(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.interval(fn.apply(new Time.Builder()).build());
        }

        @Nonnull
        public final Builder keyed(@Nullable Boolean value) {
            this.keyed = value;
            return this;
        }

        @Nonnull
        public final Builder minDocCount(@Nullable Integer value) {
            this.minDocCount = value;
            return this;
        }

        @Nonnull
        public final Builder missing(@Nullable String value) {
            this.missing = value;
            return this;
        }

        @Nonnull
        public final Builder offset(@Nullable Time value) {
            this.offset = value;
            return this;
        }

        @Nonnull
        public final Builder offset(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.offset(fn.apply(new Time.Builder()).build());
        }

        @Nonnull
        public final Builder order(@Nullable HistogramOrder value) {
            this.order = value;
            return this;
        }

        @Nonnull
        public final Builder order(Function<HistogramOrder.Builder, ObjectBuilder<HistogramOrder>> fn) {
            return this.order(fn.apply(new HistogramOrder.Builder()).build());
        }

        @Nonnull
        public final Builder params(Map<String, JsonData> map) {
            this.params = Builder._mapPutAll(this.params, map);
            return this;
        }

        @Nonnull
        public final Builder params(String key, JsonData value) {
            this.params = Builder._mapPut(this.params, key, value);
            return this;
        }

        @Nonnull
        public final Builder script(@Nullable Script value) {
            this.script = value;
            return this;
        }

        @Nonnull
        public final Builder script(Function<Script.Builder, ObjectBuilder<Script>> fn) {
            return this.script(fn.apply(new Script.Builder()).build());
        }

        @Nonnull
        public final Builder timeZone(@Nullable String value) {
            this.timeZone = value;
            return this;
        }

        @Override
        @Nonnull
        public DateHistogramAggregation build() {
            this._checkSingleUse();
            return new DateHistogramAggregation(this);
        }
    }
}

