/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class ThreadInfo
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, ThreadInfo> {
    @Nonnull
    private final Number activeThreads;
    @Nonnull
    private final Number threadExecutions;
    public static final JsonpDeserializer<ThreadInfo> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ThreadInfo::setupThreadInfoDeserializer);

    private ThreadInfo(Builder builder) {
        this.activeThreads = ApiTypeHelper.requireNonNull(builder.activeThreads, this, "activeThreads");
        this.threadExecutions = ApiTypeHelper.requireNonNull(builder.threadExecutions, this, "threadExecutions");
    }

    public static ThreadInfo of(Function<Builder, ObjectBuilder<ThreadInfo>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nonnull
    public final Number activeThreads() {
        return this.activeThreads;
    }

    @Nonnull
    public final Number threadExecutions() {
        return this.threadExecutions;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("active_threads");
        generator.write(this.activeThreads.doubleValue());
        generator.writeKey("thread_executions");
        generator.write(this.threadExecutions.doubleValue());
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupThreadInfoDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::activeThreads, JsonpDeserializer.numberDeserializer(), "active_threads");
        op.add(Builder::threadExecutions, JsonpDeserializer.numberDeserializer(), "thread_executions");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.activeThreads.hashCode();
        result = 31 * result + this.threadExecutions.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ThreadInfo other = (ThreadInfo)o;
        return this.activeThreads.equals(other.activeThreads) && this.threadExecutions.equals(other.threadExecutions);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, ThreadInfo> {
        private Number activeThreads;
        private Number threadExecutions;

        public Builder() {
        }

        private Builder(ThreadInfo o) {
            this.activeThreads = o.activeThreads;
            this.threadExecutions = o.threadExecutions;
        }

        private Builder(Builder o) {
            this.activeThreads = o.activeThreads;
            this.threadExecutions = o.threadExecutions;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder activeThreads(Number value) {
            this.activeThreads = value;
            return this;
        }

        @Nonnull
        public final Builder threadExecutions(Number value) {
            this.threadExecutions = value;
            return this;
        }

        @Override
        @Nonnull
        public ThreadInfo build() {
            this._checkSingleUse();
            return new ThreadInfo(this);
        }
    }
}

