/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.notifications.core.repackage.com.amazonaws.internal.http;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.opensearch.notifications.core.repackage.com.amazonaws.annotation.SdkProtectedApi;
import org.opensearch.notifications.core.repackage.com.amazonaws.http.HttpResponse;
import org.opensearch.notifications.core.repackage.com.fasterxml.jackson.databind.JsonNode;

@SdkProtectedApi
public class JsonErrorMessageParser {
    private static final List<String> DEFAULT_ERROR_MESSAGE_LOCATIONS = Arrays.asList("message", "Message", "errorMessage", "ErrorMessage");
    public static final String X_AMZN_ERROR_MESSAGE = "x-amzn-error-message";
    public static final JsonErrorMessageParser DEFAULT_ERROR_MESSAGE_PARSER = new JsonErrorMessageParser(DEFAULT_ERROR_MESSAGE_LOCATIONS);
    private static final HttpResponse EMPTY_HTTP_RESPONSE = new HttpResponse(null, null);
    private final List<String> errorMessageJsonLocations;

    public JsonErrorMessageParser(List<String> errorMessageJsonLocations) {
        this.errorMessageJsonLocations = new LinkedList<String>(errorMessageJsonLocations);
    }

    @Deprecated
    public String parseErrorMessage(JsonNode jsonNode) {
        return this.parseErrorMessage(EMPTY_HTTP_RESPONSE, jsonNode);
    }

    public String parseErrorMessage(HttpResponse httpResponse, JsonNode jsonNode) {
        String headerMessage = httpResponse.getHeader(X_AMZN_ERROR_MESSAGE);
        if (headerMessage != null) {
            return headerMessage;
        }
        for (String field : this.errorMessageJsonLocations) {
            JsonNode value = jsonNode.get(field);
            if (value == null || !value.isTextual()) continue;
            return value.asText();
        }
        return null;
    }
}

