/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.util.tokens.impl;

import com.oracle.labs.mlrg.olcut.config.Config;
import com.oracle.labs.mlrg.olcut.config.Configurable;
import com.oracle.labs.mlrg.olcut.provenance.ConfiguredObjectProvenance;
import com.oracle.labs.mlrg.olcut.provenance.impl.ConfiguredObjectProvenanceImpl;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.tribuo.util.tokens.Token;
import org.tribuo.util.tokens.Tokenizer;

public class SplitPatternTokenizer
implements Tokenizer {
    public static final String SIMPLE_DEFAULT_PATTERN = "[\\.,]?\\s+";
    @Config(description="The regex to split with.")
    private String splitPatternRegex = "[\\.,]?\\s+";
    private Pattern splitPattern;
    private CharSequence cs;
    private int start;
    private int end;
    private Matcher matcher;
    private int prevMatchEnd;
    private boolean done;
    private boolean ready;

    public SplitPatternTokenizer() {
        this.postConfig();
    }

    public SplitPatternTokenizer(String splitPatternRegex) {
        this.splitPatternRegex = splitPatternRegex;
        this.postConfig();
    }

    public void postConfig() {
        this.splitPattern = Pattern.compile(this.splitPatternRegex);
        this.ready = false;
        this.cs = null;
    }

    public ConfiguredObjectProvenance getProvenance() {
        return new ConfiguredObjectProvenanceImpl((Configurable)this, "Tokenizer");
    }

    public String getSplitPatternRegex() {
        return this.splitPatternRegex;
    }

    @Override
    public void reset(CharSequence cs) {
        this.cs = cs;
        this.matcher = this.splitPattern.matcher(cs);
        this.start = -1;
        this.end = -1;
        this.prevMatchEnd = 0;
        this.done = false;
        this.ready = false;
    }

    @Override
    public boolean advance() {
        if (this.cs == null) {
            throw new IllegalStateException("SplitPatternTokenizer has not been reset.");
        }
        if (this.done) {
            return false;
        }
        if (this.matcher.find()) {
            if (this.matcher.start() == 0) {
                this.prevMatchEnd = this.matcher.end();
                return this.advance();
            }
            this.start = this.prevMatchEnd;
            this.end = this.matcher.start();
            this.prevMatchEnd = this.matcher.end();
            this.ready = true;
        } else {
            this.start = this.prevMatchEnd;
            this.end = this.cs.length();
            this.done = true;
            this.ready = this.start < this.end;
        }
        return this.ready;
    }

    @Override
    public String getText() {
        if (this.ready) {
            return this.cs.subSequence(this.start, this.end).toString();
        }
        throw new IllegalStateException("SplitPatternTokenizer is not ready.");
    }

    @Override
    public int getStart() {
        if (this.ready) {
            return this.start;
        }
        throw new IllegalStateException("SplitPatternTokenizer is not ready.");
    }

    @Override
    public int getEnd() {
        if (this.ready) {
            return this.end;
        }
        throw new IllegalStateException("SplitPatternTokenizer is not ready.");
    }

    @Override
    public Token.TokenType getType() {
        if (this.ready) {
            return Token.TokenType.WORD;
        }
        throw new IllegalStateException("SplitPatternTokenizer is not ready.");
    }

    @Override
    public SplitPatternTokenizer clone() {
        try {
            SplitPatternTokenizer copy = (SplitPatternTokenizer)super.clone();
            copy.postConfig();
            return copy;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)"SplitPatternTokenizer is Cloneable, but the clone call failed.");
        }
    }
}

