/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.modality.cv.translator;

import ai.djl.modality.cv.output.DetectedObjects;
import ai.djl.modality.cv.translator.BaseImageTranslator;
import ai.djl.translate.ArgumentsUtil;
import ai.djl.translate.TranslatorContext;
import java.util.List;
import java.util.Map;

public abstract class ObjectDetectionTranslator
extends BaseImageTranslator<DetectedObjects> {
    protected float threshold;
    private BaseImageTranslator.SynsetLoader synsetLoader;
    protected List<String> classes;
    protected boolean applyRatio;
    protected boolean removePadding;

    protected ObjectDetectionTranslator(ObjectDetectionBuilder<?> builder) {
        super(builder);
        this.threshold = builder.threshold;
        this.synsetLoader = builder.synsetLoader;
        this.applyRatio = builder.applyRatio;
        this.removePadding = builder.removePadding;
    }

    @Override
    public void prepare(TranslatorContext ctx) throws Exception {
        if (this.classes == null) {
            this.classes = this.synsetLoader.load(ctx.getModel());
        }
    }

    public static abstract class ObjectDetectionBuilder<T extends ObjectDetectionBuilder>
    extends BaseImageTranslator.ClassificationBuilder<T> {
        protected float threshold = 0.2f;
        protected boolean applyRatio;
        protected boolean removePadding;

        public T optThreshold(float threshold) {
            this.threshold = threshold;
            return (T)((ObjectDetectionBuilder)this.self());
        }

        public T optApplyRatio(boolean value) {
            this.applyRatio = value;
            return (T)((ObjectDetectionBuilder)this.self());
        }

        @Override
        protected void configPostProcess(Map<String, ?> arguments) {
            super.configPostProcess(arguments);
            if (ArgumentsUtil.booleanValue(arguments, "optApplyRatio") || ArgumentsUtil.booleanValue(arguments, "applyRatio")) {
                this.optApplyRatio(true);
            }
            this.threshold = ArgumentsUtil.floatValue(arguments, "threshold", 0.2f);
            String centerFit = ArgumentsUtil.stringValue(arguments, "centerFit", "false");
            this.removePadding = "true".equals(centerFit);
        }
    }
}

