/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.rest;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.core.action.ActionListener;
import org.opensearch.ml.common.transport.task.MLCancelBatchJobAction;
import org.opensearch.ml.common.transport.task.MLCancelBatchJobRequest;
import org.opensearch.ml.utils.RestActionUtils;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.action.RestToXContentListener;
import org.opensearch.transport.client.node.NodeClient;

public class RestMLCancelBatchJobAction
extends BaseRestHandler {
    private static final String ML_CANCEL_TASK_ACTION = "ml_cancel_task_action";

    public String getName() {
        return ML_CANCEL_TASK_ACTION;
    }

    public List<RestHandler.Route> routes() {
        return ImmutableList.of((Object)new RestHandler.Route(RestRequest.Method.POST, String.format(Locale.ROOT, "%s/tasks/{%s}/_cancel", "/_plugins/_ml", "task_id")));
    }

    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        MLCancelBatchJobRequest mlCancelBatchJobRequest = this.getRequest(request);
        return channel -> client.execute((ActionType)MLCancelBatchJobAction.INSTANCE, (ActionRequest)mlCancelBatchJobRequest, (ActionListener)new RestToXContentListener(channel));
    }

    @VisibleForTesting
    MLCancelBatchJobRequest getRequest(RestRequest request) throws IOException {
        String taskId = RestActionUtils.getParameterId(request, "task_id");
        return new MLCancelBatchJobRequest(taskId);
    }
}

