/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.rest;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.ml.common.settings.MLCommonsSettings;
import org.opensearch.ml.common.settings.MLFeatureEnabledSetting;
import org.opensearch.ml.common.transport.memorycontainer.memory.MLAddMemoriesAction;
import org.opensearch.ml.common.transport.memorycontainer.memory.MLAddMemoriesInput;
import org.opensearch.ml.common.transport.memorycontainer.memory.MLAddMemoriesRequest;
import org.opensearch.ml.utils.RestActionUtils;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.action.RestToXContentListener;
import org.opensearch.transport.client.node.NodeClient;

public class RestMLAddMemoriesAction
extends BaseRestHandler {
    private static final String ML_ADD_MEMORIES_ACTION = "ml_add_memories_action";
    private final MLFeatureEnabledSetting mlFeatureEnabledSetting;

    public RestMLAddMemoriesAction(MLFeatureEnabledSetting mlFeatureEnabledSetting) {
        this.mlFeatureEnabledSetting = mlFeatureEnabledSetting;
    }

    public List<RestHandler.Route> routes() {
        return ImmutableList.of((Object)new RestHandler.Route(RestRequest.Method.POST, "/_plugins/_ml/memory_containers/{memory_container_id}/memories"));
    }

    public String getName() {
        return ML_ADD_MEMORIES_ACTION;
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        if (!this.mlFeatureEnabledSetting.isAgenticMemoryEnabled()) {
            throw new OpenSearchStatusException(MLCommonsSettings.ML_COMMONS_AGENTIC_MEMORY_DISABLED_MESSAGE, RestStatus.FORBIDDEN, new Object[0]);
        }
        MLAddMemoriesRequest mlAddMemoryRequest = this.getRequest(request);
        return channel -> client.execute((ActionType)MLAddMemoriesAction.INSTANCE, (ActionRequest)mlAddMemoryRequest, (ActionListener)new RestToXContentListener(channel));
    }

    private MLAddMemoriesRequest getRequest(RestRequest request) throws IOException {
        if (!request.hasContent()) {
            throw new IOException("Add memory request has empty body");
        }
        String memoryContainerId = RestActionUtils.getParameterId(request, "memory_container_id");
        XContentParser parser = request.contentParser();
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
        MLAddMemoriesInput mlAddMemoryInput = MLAddMemoriesInput.parse((XContentParser)parser, (String)memoryContainerId);
        return new MLAddMemoriesRequest(mlAddMemoryInput);
    }
}

