/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.action.handler;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Throwables;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.search.TotalHits;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.Nullable;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.util.CollectionUtils;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.index.IndexNotFoundException;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.ExistsQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.index.query.TermsQueryBuilder;
import org.opensearch.indices.InvalidIndexNameException;
import org.opensearch.ml.common.ResourceSharingClientAccessor;
import org.opensearch.ml.common.exception.MLException;
import org.opensearch.ml.common.exception.MLResourceNotFoundException;
import org.opensearch.ml.common.settings.MLFeatureEnabledSetting;
import org.opensearch.ml.engine.indices.MLIndicesHandler;
import org.opensearch.ml.helper.ModelAccessControlHelper;
import org.opensearch.ml.utils.RestActionUtils;
import org.opensearch.remote.metadata.client.SdkClient;
import org.opensearch.remote.metadata.client.SearchDataObjectRequest;
import org.opensearch.remote.metadata.common.SdkClientUtils;
import org.opensearch.search.SearchHits;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.search.fetch.subphase.FetchSourceContext;
import org.opensearch.security.spi.resources.client.ResourceSharingClient;
import org.opensearch.transport.client.Client;

public class MLSearchHandler {
    @Generated
    private static final Logger log = LogManager.getLogger(MLSearchHandler.class);
    private final Client client;
    private NamedXContentRegistry xContentRegistry;
    private ModelAccessControlHelper modelAccessControlHelper;
    private ClusterService clusterService;
    private MLFeatureEnabledSetting mlFeatureEnabledSetting;

    public MLSearchHandler(Client client, NamedXContentRegistry xContentRegistry, ModelAccessControlHelper modelAccessControlHelper, ClusterService clusterService, MLFeatureEnabledSetting mlFeatureEnabledSetting) {
        this.modelAccessControlHelper = modelAccessControlHelper;
        this.client = client;
        this.xContentRegistry = xContentRegistry;
        this.clusterService = clusterService;
        this.mlFeatureEnabledSetting = mlFeatureEnabledSetting;
    }

    public void search(SdkClient sdkClient, SearchRequest request, String tenantId, ActionListener<SearchResponse> actionListener) {
        User user = RestActionUtils.getUserContext(this.client);
        ActionListener<SearchResponse> listener = MLSearchHandler.wrapRestActionListener(actionListener, "Fail to search model version");
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            boolean rsClientPresent;
            ActionListener wrappedListener = ActionListener.runBefore(listener, () -> ((ThreadContext.StoredContext)context).restore());
            List excludes = Optional.ofNullable(request.source()).map(SearchSourceBuilder::fetchSource).map(FetchSourceContext::excludes).map(x -> Arrays.stream(x).collect(Collectors.toList())).orElse(new ArrayList());
            excludes.add("connector.credential");
            FetchSourceContext rebuiltFetchSourceContext = new FetchSourceContext(Optional.ofNullable(request.source()).map(SearchSourceBuilder::fetchSource).map(FetchSourceContext::fetchSource).orElse(true).booleanValue(), (String[])Optional.ofNullable(request.source()).map(SearchSourceBuilder::fetchSource).map(FetchSourceContext::includes).orElse(null), excludes.toArray(new String[0]));
            BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery();
            if (request.source().query() != null) {
                queryBuilder.must(request.source().query());
            }
            BoolQueryBuilder shouldQuery = QueryBuilders.boolQuery();
            shouldQuery.should((QueryBuilder)QueryBuilders.termQuery((String)"is_hidden", (boolean)false));
            shouldQuery.should((QueryBuilder)QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.existsQuery((String)"is_hidden")));
            shouldQuery.minimumShouldMatch(1);
            queryBuilder.filter((QueryBuilder)shouldQuery);
            request.source().query((QueryBuilder)queryBuilder);
            request.source().fetchSource(rebuiltFetchSourceContext);
            ActionListener doubleWrapperListener = ActionListener.wrap(arg_0 -> ((ActionListener)wrappedListener).onResponse(arg_0), e -> RestActionUtils.wrapListenerToHandleSearchIndexNotFound(e, (ActionListener<SearchResponse>)wrappedListener));
            boolean hasModelGroupIndex = MLIndicesHandler.doesMultiTenantIndexExist((ClusterService)this.clusterService, (boolean)this.mlFeatureEnabledSetting.isMultiTenancyEnabled(), (String)".plugins-ml-model-group");
            boolean bl = rsClientPresent = ResourceSharingClientAccessor.getInstance().getResourceSharingClient() != null;
            if (rsClientPresent && user != null && this.modelAccessControlHelper.modelAccessControlEnabled() && hasModelGroupIndex) {
                ResourceSharingClient rsc = ResourceSharingClientAccessor.getInstance().getResourceSharingClient();
                rsc.getAccessibleResourceIds(".plugins-ml-model-group", ActionListener.wrap(ids -> {
                    SearchSourceBuilder gated = Optional.ofNullable(request.source()).orElseGet(SearchSourceBuilder::new);
                    gated.query(MLSearchHandler.rewriteQueryBuilderRSC(gated.query(), ids));
                    request.source(gated);
                    SearchDataObjectRequest finalSearch = SearchDataObjectRequest.builder().indices(request.indices()).searchSourceBuilder(request.source()).tenantId(tenantId).build();
                    sdkClient.searchDataObjectAsync(finalSearch).whenComplete(SdkClientUtils.wrapSearchCompletion((ActionListener)doubleWrapperListener, (Class[])new Class[0]));
                }, e -> {
                    log.error("RSC getAccessibleResourceIds failed", (Throwable)e);
                    wrappedListener.onFailure(e);
                }));
                return;
            }
            if (this.modelAccessControlHelper.skipModelAccessControl(user) || !hasModelGroupIndex) {
                SearchDataObjectRequest searchDataObjectRequest = SearchDataObjectRequest.builder().indices(request.indices()).searchSourceBuilder(request.source()).tenantId(tenantId).build();
                sdkClient.searchDataObjectAsync(searchDataObjectRequest).whenComplete(SdkClientUtils.wrapSearchCompletion((ActionListener)doubleWrapperListener, (Class[])new Class[0]));
                return;
            }
            SearchSourceBuilder sourceBuilder = this.modelAccessControlHelper.createSearchSourceBuilder(user);
            SearchRequest modelGroupSearchRequest = new SearchRequest();
            sourceBuilder.fetchSource(new String[]{"model_group_id"}, null);
            sourceBuilder.size(10000);
            modelGroupSearchRequest.source(sourceBuilder);
            modelGroupSearchRequest.indices(new String[]{".plugins-ml-model-group"});
            ActionListener modelGroupSearchActionListener = ActionListener.wrap(r -> {
                if (Optional.ofNullable(r).map(SearchResponse::getHits).map(SearchHits::getTotalHits).map(TotalHits::value).orElse(0L) > 0L) {
                    ArrayList<String> modelGroupIds = new ArrayList<String>();
                    Arrays.stream(r.getHits().getHits()).forEach(hit -> modelGroupIds.add(hit.getId()));
                    request.source().query(MLSearchHandler.rewriteQueryBuilder(request.source().query(), modelGroupIds));
                } else {
                    log.debug("No model group found");
                    request.source().query(MLSearchHandler.rewriteQueryBuilder(request.source().query(), null));
                }
                SearchDataObjectRequest searchDataObjectRequest = SearchDataObjectRequest.builder().indices(request.indices()).searchSourceBuilder(request.source()).tenantId(tenantId).build();
                sdkClient.searchDataObjectAsync(searchDataObjectRequest).whenComplete(SdkClientUtils.wrapSearchCompletion((ActionListener)doubleWrapperListener, (Class[])new Class[0]));
            }, e -> {
                log.error("Fail to search model groups!", (Throwable)e);
                wrappedListener.onFailure(e);
            });
            SearchDataObjectRequest searchDataObjectRequest = SearchDataObjectRequest.builder().indices(modelGroupSearchRequest.indices()).searchSourceBuilder(modelGroupSearchRequest.source()).tenantId(tenantId).build();
            sdkClient.searchDataObjectAsync(searchDataObjectRequest).whenComplete(SdkClientUtils.wrapSearchCompletion((ActionListener)modelGroupSearchActionListener, (Class[])new Class[0]));
        }
        catch (Exception e2) {
            log.error(e2.getMessage(), (Throwable)e2);
            actionListener.onFailure(e2);
        }
    }

    @VisibleForTesting
    static QueryBuilder rewriteQueryBuilderRSC(QueryBuilder existing, @Nullable Collection<String> modelGroupIds) {
        BoolQueryBuilder gate = modelGroupIds == null || modelGroupIds.isEmpty() ? QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.matchAllQuery()) : QueryBuilders.boolQuery().should((QueryBuilder)QueryBuilders.termsQuery((String)"model_group_id", modelGroupIds)).should((QueryBuilder)QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.existsQuery((String)"model_group_id"))).minimumShouldMatch(1);
        if (existing == null) {
            return gate != null ? gate : QueryBuilders.boolQuery().filter(null);
        }
        if (existing instanceof BoolQueryBuilder) {
            ((BoolQueryBuilder)existing).filter((QueryBuilder)gate);
            return existing;
        }
        return QueryBuilders.boolQuery().must(existing).filter((QueryBuilder)gate);
    }

    @VisibleForTesting
    static QueryBuilder rewriteQueryBuilder(QueryBuilder queryBuilder, List<String> modelGroupIds) {
        ExistsQueryBuilder existsQueryBuilder = new ExistsQueryBuilder("model_group_id");
        BoolQueryBuilder modelGroupIdMustNotExistBoolQuery = new BoolQueryBuilder();
        modelGroupIdMustNotExistBoolQuery.mustNot((QueryBuilder)existsQueryBuilder);
        BoolQueryBuilder accessControlledBoolQuery = new BoolQueryBuilder();
        if (!CollectionUtils.isEmpty(modelGroupIds)) {
            TermsQueryBuilder modelGroupIdTermsQuery = new TermsQueryBuilder("model_group_id", modelGroupIds);
            accessControlledBoolQuery.should((QueryBuilder)modelGroupIdTermsQuery);
        }
        accessControlledBoolQuery.should((QueryBuilder)modelGroupIdMustNotExistBoolQuery);
        if (queryBuilder == null) {
            return accessControlledBoolQuery;
        }
        if (queryBuilder instanceof BoolQueryBuilder) {
            ((BoolQueryBuilder)queryBuilder).must((QueryBuilder)accessControlledBoolQuery);
            return queryBuilder;
        }
        BoolQueryBuilder boolQueryBuilder = new BoolQueryBuilder();
        boolQueryBuilder.must(queryBuilder);
        boolQueryBuilder.must((QueryBuilder)modelGroupIdMustNotExistBoolQuery);
        return boolQueryBuilder;
    }

    public static <T> ActionListener<T> wrapRestActionListener(ActionListener<T> actionListener, String generalErrorMessage) {
        return ActionListener.wrap(r -> actionListener.onResponse(r), e -> {
            log.error("Wrap exception before sending back to user", (Throwable)e);
            Throwable cause = Throwables.getRootCause((Throwable)e);
            if (MLSearchHandler.isProperExceptionToReturn(e)) {
                actionListener.onFailure(e);
            } else if (MLSearchHandler.isProperExceptionToReturn(cause)) {
                actionListener.onFailure((Exception)cause);
            } else {
                RestStatus status = MLSearchHandler.isBadRequest(e) ? RestStatus.BAD_REQUEST : RestStatus.INTERNAL_SERVER_ERROR;
                String errorMessage = generalErrorMessage;
                if (MLSearchHandler.isBadRequest(e) || e instanceof MLException) {
                    errorMessage = e.getMessage();
                } else if (MLSearchHandler.isBadRequest(cause) || cause instanceof MLException) {
                    errorMessage = cause.getMessage();
                }
                actionListener.onFailure((Exception)new OpenSearchStatusException(errorMessage, status, new Object[0]));
            }
        });
    }

    public static boolean isProperExceptionToReturn(Throwable e) {
        return e instanceof OpenSearchStatusException || e instanceof IndexNotFoundException || e instanceof InvalidIndexNameException;
    }

    public static boolean isBadRequest(Throwable e) {
        return e instanceof IllegalArgumentException || e instanceof MLResourceNotFoundException;
    }
}

