/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.action.IndexInsight;

import java.time.Instant;
import java.util.Optional;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.get.GetResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.json.JsonXContent;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.ml.common.indexInsight.FieldDescriptionTask;
import org.opensearch.ml.common.indexInsight.IndexInsight;
import org.opensearch.ml.common.indexInsight.IndexInsightAccessControllerHelper;
import org.opensearch.ml.common.indexInsight.IndexInsightConfig;
import org.opensearch.ml.common.indexInsight.IndexInsightTask;
import org.opensearch.ml.common.indexInsight.IndexInsightTaskStatus;
import org.opensearch.ml.common.indexInsight.LogRelatedIndexCheckTask;
import org.opensearch.ml.common.indexInsight.MLIndexInsightType;
import org.opensearch.ml.common.indexInsight.StatisticalDataTask;
import org.opensearch.ml.common.settings.MLCommonsSettings;
import org.opensearch.ml.common.settings.MLFeatureEnabledSetting;
import org.opensearch.ml.common.transport.indexInsight.MLIndexInsightGetRequest;
import org.opensearch.ml.common.transport.indexInsight.MLIndexInsightGetResponse;
import org.opensearch.ml.utils.TenantAwareHelper;
import org.opensearch.remote.metadata.client.GetDataObjectRequest;
import org.opensearch.remote.metadata.client.SdkClient;
import org.opensearch.remote.metadata.common.SdkClientUtils;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;
import org.opensearch.transport.client.Client;

public class GetIndexInsightTransportAction
extends HandledTransportAction<ActionRequest, MLIndexInsightGetResponse> {
    @Generated
    private static final Logger log = LogManager.getLogger(GetIndexInsightTransportAction.class);
    private static final MLIndexInsightType[] ALL_TYPE_ORDER = new MLIndexInsightType[]{MLIndexInsightType.STATISTICAL_DATA, MLIndexInsightType.FIELD_DESCRIPTION, MLIndexInsightType.LOG_RELATED_INDEX_CHECK};
    private final Client client;
    private final SdkClient sdkClient;
    private final NamedXContentRegistry xContentRegistry;
    private final MLFeatureEnabledSetting mlFeatureEnabledSetting;

    @Inject
    public GetIndexInsightTransportAction(TransportService transportService, ActionFilters actionFilters, NamedXContentRegistry xContentRegistry, MLFeatureEnabledSetting mlFeatureEnabledSetting, Client client, SdkClient sdkClient) {
        super("cluster:admin/opensearch/ml/index_insight/get", transportService, actionFilters, MLIndexInsightGetRequest::new);
        this.client = client;
        this.xContentRegistry = xContentRegistry;
        this.sdkClient = sdkClient;
        this.mlFeatureEnabledSetting = mlFeatureEnabledSetting;
    }

    protected void doExecute(Task task, ActionRequest request, ActionListener<MLIndexInsightGetResponse> actionListener) {
        MLIndexInsightGetRequest mlIndexInsightGetRequest = MLIndexInsightGetRequest.fromActionRequest((ActionRequest)request);
        if (!TenantAwareHelper.validateTenantId(this.mlFeatureEnabledSetting, mlIndexInsightGetRequest.getTenantId(), actionListener)) {
            return;
        }
        if (!this.mlFeatureEnabledSetting.isIndexInsightEnabled()) {
            actionListener.onFailure((Exception)new RuntimeException("Index insight feature is not enabled yet. To enable, please update the setting " + MLCommonsSettings.ML_COMMONS_INDEX_INSIGHT_FEATURE_ENABLED.getKey()));
            return;
        }
        String indexName = mlIndexInsightGetRequest.getIndexName();
        String docId = Optional.ofNullable(mlIndexInsightGetRequest.getTenantId()).orElse("03000200-0400-0500-0006-000700080009");
        ActionListener actionAfterDryRun = ActionListener.wrap(r -> {
            try (ThreadContext.StoredContext getContext = this.client.threadPool().getThreadContext().stashContext();){
                this.sdkClient.getDataObjectAsync(((GetDataObjectRequest.Builder)((GetDataObjectRequest.Builder)((GetDataObjectRequest.Builder)GetDataObjectRequest.builder().tenantId(mlIndexInsightGetRequest.getTenantId())).id(docId)).index(".plugins-ml-index-insight-config")).build()).whenComplete((r1, throwable) -> {
                    getContext.restore();
                    if (throwable != null) {
                        Exception cause = SdkClientUtils.unwrapAndConvertToException((Throwable)throwable, (Class[])new Class[0]);
                        log.error("Failed to get index insight config", (Throwable)cause);
                        actionListener.onFailure(cause);
                    } else {
                        GetResponse getResponse = r1.getResponse();
                        if (getResponse.isExists()) {
                            try (XContentParser parser = JsonXContent.jsonXContent.createParser(this.xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, getResponse.getSourceAsString());){
                                XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
                                IndexInsightConfig indexInsightConfig = IndexInsightConfig.parse((XContentParser)parser);
                                Boolean isEnable = indexInsightConfig.getIsEnable();
                                if (Boolean.FALSE.equals(isEnable)) {
                                    actionListener.onFailure((Exception)new RuntimeException("You are not enabled to use index insight yet, please firstly enable it."));
                                    return;
                                }
                                try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
                                    ActionListener wrappedListener = ActionListener.runBefore((ActionListener)actionListener, () -> context.restore());
                                    this.executeTaskAndReturn(mlIndexInsightGetRequest, mlIndexInsightGetRequest.getTenantId(), (ActionListener<MLIndexInsightGetResponse>)wrappedListener);
                                }
                                catch (Exception e) {
                                    log.error("Failed to get index insight", (Throwable)e);
                                    actionListener.onFailure(e);
                                }
                            }
                            catch (Exception e) {
                                actionListener.onFailure(e);
                            }
                        } else {
                            actionListener.onFailure((Exception)new RuntimeException("You are not enabled to use index insight yet, please firstly enable it."));
                        }
                    }
                });
            }
            catch (Exception e) {
                actionListener.onFailure(e);
            }
        }, arg_0 -> actionListener.onFailure(arg_0));
        IndexInsightAccessControllerHelper.verifyAccessController((Client)this.client, (ActionListener)actionAfterDryRun, (String)indexName);
    }

    private void executeTaskAndReturn(MLIndexInsightGetRequest request, String tenantId, ActionListener<MLIndexInsightGetResponse> listener) {
        if (request.getTargetIndexInsight() == MLIndexInsightType.ALL) {
            StringBuilder combinedContent = new StringBuilder();
            this.executeTaskChain(request.getIndexName(), tenantId, combinedContent, listener, 0, null);
        } else {
            IndexInsightTask task = this.createTask(request);
            task.execute(tenantId, ActionListener.wrap(insight -> listener.onResponse((Object)MLIndexInsightGetResponse.builder().indexInsight(insight).build()), arg_0 -> listener.onFailure(arg_0)));
        }
    }

    private void executeTaskChain(String indexName, String tenantId, StringBuilder combinedContent, ActionListener<MLIndexInsightGetResponse> listener, int taskIndex, Instant lastSuccessTime) {
        if (taskIndex >= ALL_TYPE_ORDER.length) {
            if (combinedContent.length() == 0) {
                listener.onFailure((Exception)new RuntimeException("All index insight tasks failed"));
                return;
            }
            this.returnCombinedResult(indexName, combinedContent, lastSuccessTime, listener);
            return;
        }
        MLIndexInsightGetRequest taskRequest = MLIndexInsightGetRequest.builder().indexName(indexName).targetIndexInsight(ALL_TYPE_ORDER[taskIndex]).tenantId(tenantId).build();
        this.executeTaskForAllType(taskRequest, tenantId, combinedContent, (ActionListener<Instant>)ActionListener.wrap(time -> this.executeTaskChain(indexName, tenantId, combinedContent, listener, taskIndex + 1, (Instant)time), e -> this.executeTaskChain(indexName, tenantId, combinedContent, listener, taskIndex + 1, lastSuccessTime)));
    }

    private void executeTaskForAllType(MLIndexInsightGetRequest request, String tenantId, StringBuilder combinedContent, ActionListener<Instant> listener) {
        this.createTask(request).execute(tenantId, ActionListener.wrap(insight -> {
            if (combinedContent.length() > 0) {
                combinedContent.append("\n\n");
            }
            combinedContent.append(request.getTargetIndexInsight().name()).append(":\n").append(insight.getContent());
            listener.onResponse((Object)insight.getLastUpdatedTime());
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    private void returnCombinedResult(String indexName, StringBuilder combinedContent, Instant lastUpdatedTime, ActionListener<MLIndexInsightGetResponse> listener) {
        IndexInsight combinedInsight = IndexInsight.builder().index(indexName).taskType(MLIndexInsightType.ALL).content(combinedContent.toString()).status(IndexInsightTaskStatus.COMPLETED).lastUpdatedTime(lastUpdatedTime).build();
        listener.onResponse((Object)MLIndexInsightGetResponse.builder().indexInsight(combinedInsight).build());
    }

    IndexInsightTask createTask(MLIndexInsightGetRequest request) {
        switch (request.getTargetIndexInsight()) {
            case STATISTICAL_DATA: {
                return new StatisticalDataTask(request.getIndexName(), this.client, this.sdkClient);
            }
            case FIELD_DESCRIPTION: {
                return new FieldDescriptionTask(request.getIndexName(), this.client, this.sdkClient);
            }
            case LOG_RELATED_INDEX_CHECK: {
                return new LogRelatedIndexCheckTask(request.getIndexName(), this.client, this.sdkClient);
            }
        }
        throw new IllegalArgumentException("Unsupported task type: " + String.valueOf(request.getTargetIndexInsight()));
    }
}

