/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.searchpipelines.questionanswering.generative.ext;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.opensearch.Version;
import org.opensearch.core.common.Strings;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.ml.common.CommonValue;
import org.opensearch.searchpipelines.questionanswering.generative.llm.MessageBlock;

public class GenerativeQAParameters
implements Writeable,
ToXContentObject {
    private static final String CONVERSATION_ID = "memory_id";
    private static final String LLM_MODEL = "llm_model";
    private static final String LLM_QUESTION = "llm_question";
    private static final String CONTEXT_SIZE = "context_size";
    private static final String INTERACTION_SIZE = "message_size";
    private static final String TIMEOUT = "timeout";
    private static final String SYSTEM_PROMPT = "system_prompt";
    private static final String USER_INSTRUCTIONS = "user_instructions";
    private static final String LLM_RESPONSE_FIELD = "llm_response_field";
    private static final String LLM_MESSAGES_FIELD = "llm_messages";
    public static final int SIZE_NULL_VALUE = -1;
    static final Version MINIMAL_SUPPORTED_VERSION_FOR_BEDROCK_CONVERSE_LLM_MESSAGES = CommonValue.VERSION_2_18_0;
    public static final Version MINIMAL_SUPPORTED_VERSION_FOR_PROMPT_AND_INSTRUCTIONS = CommonValue.VERSION_2_13_0;
    private String conversationId;
    private String llmModel;
    private String llmQuestion;
    private Integer contextSize;
    private Integer interactionSize;
    private Integer timeout;
    private String systemPrompt;
    private String userInstructions;
    private String llmResponseField;
    private List<MessageBlock> llmMessages = new ArrayList<MessageBlock>();

    public GenerativeQAParameters(String conversationId, String llmModel, String llmQuestion, String systemPrompt, String userInstructions, Integer contextSize, Integer interactionSize, Integer timeout, String llmResponseField) {
        this(conversationId, llmModel, llmQuestion, systemPrompt, userInstructions, contextSize, interactionSize, timeout, llmResponseField, null);
    }

    public GenerativeQAParameters(String conversationId, String llmModel, String llmQuestion, String systemPrompt, String userInstructions, Integer contextSize, Integer interactionSize, Integer timeout, String llmResponseField, List<MessageBlock> llmMessages) {
        this.conversationId = conversationId;
        this.llmModel = llmModel;
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)llmQuestion) || llmMessages != null && !llmMessages.isEmpty() ? 1 : 0) != 0, (Object)"At least one of llm_question or llm_messages must be provided.");
        this.llmQuestion = llmQuestion;
        this.systemPrompt = systemPrompt;
        this.userInstructions = userInstructions;
        this.contextSize = contextSize == null ? -1 : contextSize;
        this.interactionSize = interactionSize == null ? -1 : interactionSize;
        this.timeout = timeout == null ? -1 : timeout;
        this.llmResponseField = llmResponseField;
        if (llmMessages != null) {
            this.llmMessages.addAll(llmMessages);
        }
    }

    public GenerativeQAParameters(StreamInput input) throws IOException {
        Version version = input.getVersion();
        this.conversationId = input.readOptionalString();
        this.llmModel = input.readOptionalString();
        this.llmQuestion = version.onOrAfter(MINIMAL_SUPPORTED_VERSION_FOR_BEDROCK_CONVERSE_LLM_MESSAGES) ? input.readOptionalString() : input.readString();
        if (version.onOrAfter(MINIMAL_SUPPORTED_VERSION_FOR_PROMPT_AND_INSTRUCTIONS)) {
            this.systemPrompt = input.readOptionalString();
            this.userInstructions = input.readOptionalString();
        }
        this.contextSize = input.readInt();
        this.interactionSize = input.readInt();
        this.timeout = input.readInt();
        if (version.onOrAfter(MINIMAL_SUPPORTED_VERSION_FOR_PROMPT_AND_INSTRUCTIONS)) {
            this.llmResponseField = input.readOptionalString();
        }
        if (version.onOrAfter(MINIMAL_SUPPORTED_VERSION_FOR_BEDROCK_CONVERSE_LLM_MESSAGES)) {
            this.llmMessages.addAll(input.readList(MessageBlock::new));
        }
    }

    public XContentBuilder toXContent(XContentBuilder xContentBuilder, ToXContent.Params params) throws IOException {
        xContentBuilder.startObject();
        if (this.conversationId != null) {
            xContentBuilder.field(CONVERSATION_ID, this.conversationId);
        }
        if (this.llmModel != null) {
            xContentBuilder.field(LLM_MODEL, this.llmModel);
        }
        if (this.llmQuestion != null) {
            xContentBuilder.field(LLM_QUESTION, this.llmQuestion);
        }
        if (this.systemPrompt != null) {
            xContentBuilder.field(SYSTEM_PROMPT, this.systemPrompt);
        }
        if (this.userInstructions != null) {
            xContentBuilder.field(USER_INSTRUCTIONS, this.userInstructions);
        }
        if (this.contextSize != null) {
            xContentBuilder.field(CONTEXT_SIZE, this.contextSize);
        }
        if (this.interactionSize != null) {
            xContentBuilder.field(INTERACTION_SIZE, this.interactionSize);
        }
        if (this.timeout != null) {
            xContentBuilder.field(TIMEOUT, this.timeout);
        }
        if (this.llmResponseField != null) {
            xContentBuilder.field(LLM_RESPONSE_FIELD, this.llmResponseField);
        }
        if (this.llmMessages != null && !this.llmMessages.isEmpty()) {
            xContentBuilder.field(LLM_MESSAGES_FIELD, this.llmMessages);
        }
        xContentBuilder.endObject();
        return xContentBuilder;
    }

    public void writeTo(StreamOutput out) throws IOException {
        Version version = out.getVersion();
        out.writeOptionalString(this.conversationId);
        out.writeOptionalString(this.llmModel);
        if (version.onOrAfter(MINIMAL_SUPPORTED_VERSION_FOR_BEDROCK_CONVERSE_LLM_MESSAGES)) {
            out.writeOptionalString(this.llmQuestion);
        } else {
            out.writeString(this.llmQuestion);
        }
        if (version.onOrAfter(MINIMAL_SUPPORTED_VERSION_FOR_PROMPT_AND_INSTRUCTIONS)) {
            out.writeOptionalString(this.systemPrompt);
            out.writeOptionalString(this.userInstructions);
        }
        out.writeInt(this.contextSize.intValue());
        out.writeInt(this.interactionSize.intValue());
        out.writeInt(this.timeout.intValue());
        if (version.onOrAfter(MINIMAL_SUPPORTED_VERSION_FOR_PROMPT_AND_INSTRUCTIONS)) {
            out.writeOptionalString(this.llmResponseField);
        }
        if (version.onOrAfter(MINIMAL_SUPPORTED_VERSION_FOR_BEDROCK_CONVERSE_LLM_MESSAGES)) {
            out.writeList(this.llmMessages);
        }
    }

    public static GenerativeQAParameters parse(XContentParser parser) throws IOException {
        String conversationId = null;
        String llmModel = null;
        String llmQuestion = null;
        String systemPrompt = null;
        String userInstructions = null;
        Integer contextSize = null;
        Integer interactionSize = null;
        Integer timeout = null;
        String llmResponseField = null;
        ArrayList<MessageBlock> llmMessages = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        block24: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String field = parser.currentName();
            parser.nextToken();
            switch (field) {
                case "memory_id": {
                    conversationId = parser.text();
                    continue block24;
                }
                case "llm_model": {
                    llmModel = parser.text();
                    continue block24;
                }
                case "llm_question": {
                    llmQuestion = parser.text();
                    continue block24;
                }
                case "system_prompt": {
                    systemPrompt = parser.text();
                    continue block24;
                }
                case "user_instructions": {
                    userInstructions = parser.text();
                    continue block24;
                }
                case "context_size": {
                    contextSize = parser.intValue();
                    continue block24;
                }
                case "message_size": {
                    interactionSize = parser.intValue();
                    continue block24;
                }
                case "timeout": {
                    timeout = parser.intValue();
                    continue block24;
                }
                case "llm_response_field": {
                    llmResponseField = parser.text();
                    continue block24;
                }
                case "llm_messages": {
                    llmMessages = new ArrayList<MessageBlock>();
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
                    while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                        llmMessages.add(MessageBlock.fromXContent(parser));
                    }
                    continue block24;
                }
            }
            parser.skipChildren();
        }
        return GenerativeQAParameters.builder().conversationId(conversationId).llmModel(llmModel).llmQuestion(llmQuestion).systemPrompt(systemPrompt).userInstructions(userInstructions).contextSize(contextSize).interactionSize(interactionSize).timeout(timeout).llmResponseField(llmResponseField).llmMessages(llmMessages).build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GenerativeQAParameters other = (GenerativeQAParameters)o;
        return Objects.equals(this.conversationId, other.getConversationId()) && Objects.equals(this.llmModel, other.getLlmModel()) && Objects.equals(this.llmQuestion, other.getLlmQuestion()) && Objects.equals(this.systemPrompt, other.getSystemPrompt()) && Objects.equals(this.userInstructions, other.getUserInstructions()) && this.contextSize == other.getContextSize() && this.interactionSize == other.getInteractionSize() && this.timeout == other.getTimeout() && Objects.equals(this.llmResponseField, other.getLlmResponseField());
    }

    public void setMessageBlock(List<MessageBlock> blockList) {
        this.llmMessages = blockList;
    }

    @Generated
    public static GenerativeQAParametersBuilder builder() {
        return new GenerativeQAParametersBuilder();
    }

    @Generated
    public GenerativeQAParametersBuilder toBuilder() {
        return new GenerativeQAParametersBuilder().conversationId(this.conversationId).llmModel(this.llmModel).llmQuestion(this.llmQuestion).systemPrompt(this.systemPrompt).userInstructions(this.userInstructions).contextSize(this.contextSize).interactionSize(this.interactionSize).timeout(this.timeout).llmResponseField(this.llmResponseField).llmMessages(this.llmMessages);
    }

    @Generated
    public GenerativeQAParameters() {
    }

    @Generated
    public void setConversationId(String conversationId) {
        this.conversationId = conversationId;
    }

    @Generated
    public String getConversationId() {
        return this.conversationId;
    }

    @Generated
    public void setLlmModel(String llmModel) {
        this.llmModel = llmModel;
    }

    @Generated
    public String getLlmModel() {
        return this.llmModel;
    }

    @Generated
    public void setLlmQuestion(String llmQuestion) {
        this.llmQuestion = llmQuestion;
    }

    @Generated
    public String getLlmQuestion() {
        return this.llmQuestion;
    }

    @Generated
    public void setContextSize(Integer contextSize) {
        this.contextSize = contextSize;
    }

    @Generated
    public Integer getContextSize() {
        return this.contextSize;
    }

    @Generated
    public void setInteractionSize(Integer interactionSize) {
        this.interactionSize = interactionSize;
    }

    @Generated
    public Integer getInteractionSize() {
        return this.interactionSize;
    }

    @Generated
    public void setTimeout(Integer timeout) {
        this.timeout = timeout;
    }

    @Generated
    public Integer getTimeout() {
        return this.timeout;
    }

    @Generated
    public void setSystemPrompt(String systemPrompt) {
        this.systemPrompt = systemPrompt;
    }

    @Generated
    public String getSystemPrompt() {
        return this.systemPrompt;
    }

    @Generated
    public void setUserInstructions(String userInstructions) {
        this.userInstructions = userInstructions;
    }

    @Generated
    public String getUserInstructions() {
        return this.userInstructions;
    }

    @Generated
    public void setLlmResponseField(String llmResponseField) {
        this.llmResponseField = llmResponseField;
    }

    @Generated
    public String getLlmResponseField() {
        return this.llmResponseField;
    }

    @Generated
    public void setLlmMessages(List<MessageBlock> llmMessages) {
        this.llmMessages = llmMessages;
    }

    @Generated
    public List<MessageBlock> getLlmMessages() {
        return this.llmMessages;
    }

    @Generated
    public static class GenerativeQAParametersBuilder {
        @Generated
        private String conversationId;
        @Generated
        private String llmModel;
        @Generated
        private String llmQuestion;
        @Generated
        private String systemPrompt;
        @Generated
        private String userInstructions;
        @Generated
        private Integer contextSize;
        @Generated
        private Integer interactionSize;
        @Generated
        private Integer timeout;
        @Generated
        private String llmResponseField;
        @Generated
        private List<MessageBlock> llmMessages;

        @Generated
        GenerativeQAParametersBuilder() {
        }

        @Generated
        public GenerativeQAParametersBuilder conversationId(String conversationId) {
            this.conversationId = conversationId;
            return this;
        }

        @Generated
        public GenerativeQAParametersBuilder llmModel(String llmModel) {
            this.llmModel = llmModel;
            return this;
        }

        @Generated
        public GenerativeQAParametersBuilder llmQuestion(String llmQuestion) {
            this.llmQuestion = llmQuestion;
            return this;
        }

        @Generated
        public GenerativeQAParametersBuilder systemPrompt(String systemPrompt) {
            this.systemPrompt = systemPrompt;
            return this;
        }

        @Generated
        public GenerativeQAParametersBuilder userInstructions(String userInstructions) {
            this.userInstructions = userInstructions;
            return this;
        }

        @Generated
        public GenerativeQAParametersBuilder contextSize(Integer contextSize) {
            this.contextSize = contextSize;
            return this;
        }

        @Generated
        public GenerativeQAParametersBuilder interactionSize(Integer interactionSize) {
            this.interactionSize = interactionSize;
            return this;
        }

        @Generated
        public GenerativeQAParametersBuilder timeout(Integer timeout) {
            this.timeout = timeout;
            return this;
        }

        @Generated
        public GenerativeQAParametersBuilder llmResponseField(String llmResponseField) {
            this.llmResponseField = llmResponseField;
            return this;
        }

        @Generated
        public GenerativeQAParametersBuilder llmMessages(List<MessageBlock> llmMessages) {
            this.llmMessages = llmMessages;
            return this;
        }

        @Generated
        public GenerativeQAParameters build() {
            return new GenerativeQAParameters(this.conversationId, this.llmModel, this.llmQuestion, this.systemPrompt, this.userInstructions, this.contextSize, this.interactionSize, this.timeout, this.llmResponseField, this.llmMessages);
        }

        @Generated
        public String toString() {
            return "GenerativeQAParameters.GenerativeQAParametersBuilder(conversationId=" + this.conversationId + ", llmModel=" + this.llmModel + ", llmQuestion=" + this.llmQuestion + ", systemPrompt=" + this.systemPrompt + ", userInstructions=" + this.userInstructions + ", contextSize=" + this.contextSize + ", interactionSize=" + this.interactionSize + ", timeout=" + this.timeout + ", llmResponseField=" + this.llmResponseField + ", llmMessages=" + String.valueOf(this.llmMessages) + ")";
        }
    }
}

