/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal.serializer;

import jakarta.json.stream.JsonGenerator;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import org.eclipse.yasson.internal.Marshaller;
import org.eclipse.yasson.internal.model.customization.Customization;
import org.eclipse.yasson.internal.serializer.AbstractValueTypeSerializer;
import org.eclipse.yasson.internal.serializer.JsonbNumberFormatter;

public abstract class AbstractNumberSerializer<T extends Number>
extends AbstractValueTypeSerializer<T> {
    private final JsonbNumberFormatter formatter;

    public AbstractNumberSerializer(Customization customization) {
        super(customization);
        this.formatter = customization != null ? customization.getSerializeNumberFormatter() : null;
    }

    protected abstract void serializeNonFormatted(T var1, JsonGenerator var2, String var3);

    @Override
    protected void serialize(T obj, JsonGenerator generator, Marshaller marshaller) {
        if (this.formatter != null) {
            NumberFormat format = NumberFormat.getInstance(marshaller.getJsonbContext().getConfigProperties().getLocale(this.formatter.getLocale()));
            ((DecimalFormat)format).applyPattern(this.formatter.getFormat());
            generator.write(format.format(obj));
        } else {
            this.serializeNonFormatted(obj, generator);
        }
    }

    protected abstract void serializeNonFormatted(T var1, JsonGenerator var2);
}

