/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.security;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch.security.AuditLogsConfig;
import org.opensearch.client.opensearch.security.ComplianceConfig;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class AuditConfig
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, AuditConfig> {
    @Nullable
    private final AuditLogsConfig audit;
    @Nullable
    private final ComplianceConfig compliance;
    @Nullable
    private final Boolean enabled;
    public static final JsonpDeserializer<AuditConfig> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, AuditConfig::setupAuditConfigDeserializer);

    private AuditConfig(Builder builder) {
        this.audit = builder.audit;
        this.compliance = builder.compliance;
        this.enabled = builder.enabled;
    }

    public static AuditConfig of(Function<Builder, ObjectBuilder<AuditConfig>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final AuditLogsConfig audit() {
        return this.audit;
    }

    @Nullable
    public final ComplianceConfig compliance() {
        return this.compliance;
    }

    @Nullable
    public final Boolean enabled() {
        return this.enabled;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.audit != null) {
            generator.writeKey("audit");
            this.audit.serialize(generator, mapper);
        }
        if (this.compliance != null) {
            generator.writeKey("compliance");
            this.compliance.serialize(generator, mapper);
        }
        if (this.enabled != null) {
            generator.writeKey("enabled");
            generator.write(this.enabled.booleanValue());
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupAuditConfigDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::audit, AuditLogsConfig._DESERIALIZER, "audit");
        op.add(Builder::compliance, ComplianceConfig._DESERIALIZER, "compliance");
        op.add(Builder::enabled, JsonpDeserializer.booleanDeserializer(), "enabled");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.audit);
        result = 31 * result + Objects.hashCode(this.compliance);
        result = 31 * result + Objects.hashCode(this.enabled);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuditConfig other = (AuditConfig)o;
        return Objects.equals(this.audit, other.audit) && Objects.equals(this.compliance, other.compliance) && Objects.equals(this.enabled, other.enabled);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, AuditConfig> {
        @Nullable
        private AuditLogsConfig audit;
        @Nullable
        private ComplianceConfig compliance;
        @Nullable
        private Boolean enabled;

        public Builder() {
        }

        private Builder(AuditConfig o) {
            this.audit = o.audit;
            this.compliance = o.compliance;
            this.enabled = o.enabled;
        }

        private Builder(Builder o) {
            this.audit = o.audit;
            this.compliance = o.compliance;
            this.enabled = o.enabled;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder audit(@Nullable AuditLogsConfig value) {
            this.audit = value;
            return this;
        }

        @Nonnull
        public final Builder audit(Function<AuditLogsConfig.Builder, ObjectBuilder<AuditLogsConfig>> fn) {
            return this.audit(fn.apply(new AuditLogsConfig.Builder()).build());
        }

        @Nonnull
        public final Builder compliance(@Nullable ComplianceConfig value) {
            this.compliance = value;
            return this;
        }

        @Nonnull
        public final Builder compliance(Function<ComplianceConfig.Builder, ObjectBuilder<ComplianceConfig>> fn) {
            return this.compliance(fn.apply(new ComplianceConfig.Builder()).build());
        }

        @Nonnull
        public final Builder enabled(@Nullable Boolean value) {
            this.enabled = value;
            return this;
        }

        @Override
        @Nonnull
        public AuditConfig build() {
            this._checkSingleUse();
            return new AuditConfig(this);
        }
    }
}

