/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.search_pipeline;

import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.ErrorResponse;
import org.opensearch.client.opensearch._types.RequestBase;
import org.opensearch.client.opensearch._types.Time;
import org.opensearch.client.opensearch.search_pipeline.PhaseResultsProcessor;
import org.opensearch.client.opensearch.search_pipeline.PutSearchPipelineResponse;
import org.opensearch.client.opensearch.search_pipeline.RequestProcessor;
import org.opensearch.client.opensearch.search_pipeline.ResponseProcessor;
import org.opensearch.client.transport.Endpoint;
import org.opensearch.client.transport.endpoints.SimpleEndpoint;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public final class PutSearchPipelineRequest
extends RequestBase
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, PutSearchPipelineRequest> {
    @Nullable
    private final Time clusterManagerTimeout;
    @Nullable
    private final String description;
    @Nonnull
    private final String id;
    @Nonnull
    private final List<PhaseResultsProcessor> phaseResultsProcessors;
    @Nonnull
    private final List<RequestProcessor> requestProcessors;
    @Nonnull
    private final List<ResponseProcessor> responseProcessors;
    @Nullable
    private final Time timeout;
    @Nullable
    private final Integer version;
    public static final JsonpDeserializer<PutSearchPipelineRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PutSearchPipelineRequest::setupPutSearchPipelineRequestDeserializer);
    public static final Endpoint<PutSearchPipelineRequest, PutSearchPipelineResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<PutSearchPipelineRequest, PutSearchPipelineResponse>(request -> "PUT", request -> {
        StringBuilder buf = new StringBuilder();
        buf.append("/_search/pipeline/");
        SimpleEndpoint.pathEncode(request.id, buf);
        return buf.toString();
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        request.applyQueryParameters(params);
        return params;
    }, SimpleEndpoint.emptyMap(), true, PutSearchPipelineResponse._DESERIALIZER);

    private PutSearchPipelineRequest(Builder builder) {
        super(builder);
        this.clusterManagerTimeout = builder.clusterManagerTimeout;
        this.description = builder.description;
        this.id = ApiTypeHelper.requireNonNull(builder.id, this, "id");
        this.phaseResultsProcessors = ApiTypeHelper.unmodifiable(builder.phaseResultsProcessors);
        this.requestProcessors = ApiTypeHelper.unmodifiable(builder.requestProcessors);
        this.responseProcessors = ApiTypeHelper.unmodifiable(builder.responseProcessors);
        this.timeout = builder.timeout;
        this.version = builder.version;
    }

    public static PutSearchPipelineRequest of(Function<Builder, ObjectBuilder<PutSearchPipelineRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Time clusterManagerTimeout() {
        return this.clusterManagerTimeout;
    }

    @Nullable
    public final String description() {
        return this.description;
    }

    @Nonnull
    public final String id() {
        return this.id;
    }

    @Nonnull
    public final List<PhaseResultsProcessor> phaseResultsProcessors() {
        return this.phaseResultsProcessors;
    }

    @Nonnull
    public final List<RequestProcessor> requestProcessors() {
        return this.requestProcessors;
    }

    @Nonnull
    public final List<ResponseProcessor> responseProcessors() {
        return this.responseProcessors;
    }

    @Nullable
    public final Time timeout() {
        return this.timeout;
    }

    @Nullable
    public final Integer version() {
        return this.version;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.description != null) {
            generator.writeKey("description");
            generator.write(this.description);
        }
        if (ApiTypeHelper.isDefined(this.phaseResultsProcessors)) {
            generator.writeKey("phase_results_processors");
            generator.writeStartArray();
            for (PhaseResultsProcessor phaseResultsProcessor : this.phaseResultsProcessors) {
                phaseResultsProcessor.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.requestProcessors)) {
            generator.writeKey("request_processors");
            generator.writeStartArray();
            for (RequestProcessor requestProcessor : this.requestProcessors) {
                requestProcessor.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.responseProcessors)) {
            generator.writeKey("response_processors");
            generator.writeStartArray();
            for (ResponseProcessor responseProcessor : this.responseProcessors) {
                responseProcessor.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.version != null) {
            generator.writeKey("version");
            generator.write(this.version.intValue());
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupPutSearchPipelineRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::description, JsonpDeserializer.stringDeserializer(), "description");
        op.add(Builder::phaseResultsProcessors, JsonpDeserializer.arrayDeserializer(PhaseResultsProcessor._DESERIALIZER), "phase_results_processors");
        op.add(Builder::requestProcessors, JsonpDeserializer.arrayDeserializer(RequestProcessor._DESERIALIZER), "request_processors");
        op.add(Builder::responseProcessors, JsonpDeserializer.arrayDeserializer(ResponseProcessor._DESERIALIZER), "response_processors");
        op.add(Builder::version, JsonpDeserializer.integerDeserializer(), "version");
    }

    @Override
    protected void applyQueryParameters(@Nonnull Map<String, String> params) {
        super.applyQueryParameters(params);
        if (this.clusterManagerTimeout != null) {
            params.put("cluster_manager_timeout", this.clusterManagerTimeout._toJsonString());
        }
        if (this.timeout != null) {
            params.put("timeout", this.timeout._toJsonString());
        }
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.clusterManagerTimeout);
        result = 31 * result + Objects.hashCode(this.description);
        result = 31 * result + this.id.hashCode();
        result = 31 * result + Objects.hashCode(this.phaseResultsProcessors);
        result = 31 * result + Objects.hashCode(this.requestProcessors);
        result = 31 * result + Objects.hashCode(this.responseProcessors);
        result = 31 * result + Objects.hashCode(this.timeout);
        result = 31 * result + Objects.hashCode(this.version);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PutSearchPipelineRequest other = (PutSearchPipelineRequest)o;
        return Objects.equals(this.clusterManagerTimeout, other.clusterManagerTimeout) && Objects.equals(this.description, other.description) && this.id.equals(other.id) && Objects.equals(this.phaseResultsProcessors, other.phaseResultsProcessors) && Objects.equals(this.requestProcessors, other.requestProcessors) && Objects.equals(this.responseProcessors, other.responseProcessors) && Objects.equals(this.timeout, other.timeout) && Objects.equals(this.version, other.version);
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, PutSearchPipelineRequest> {
        @Nullable
        private Time clusterManagerTimeout;
        @Nullable
        private String description;
        private String id;
        @Nullable
        private List<PhaseResultsProcessor> phaseResultsProcessors;
        @Nullable
        private List<RequestProcessor> requestProcessors;
        @Nullable
        private List<ResponseProcessor> responseProcessors;
        @Nullable
        private Time timeout;
        @Nullable
        private Integer version;

        public Builder() {
        }

        private Builder(PutSearchPipelineRequest o) {
            super(o);
            this.clusterManagerTimeout = o.clusterManagerTimeout;
            this.description = o.description;
            this.id = o.id;
            this.phaseResultsProcessors = Builder._listCopy(o.phaseResultsProcessors);
            this.requestProcessors = Builder._listCopy(o.requestProcessors);
            this.responseProcessors = Builder._listCopy(o.responseProcessors);
            this.timeout = o.timeout;
            this.version = o.version;
        }

        private Builder(Builder o) {
            super(o);
            this.clusterManagerTimeout = o.clusterManagerTimeout;
            this.description = o.description;
            this.id = o.id;
            this.phaseResultsProcessors = Builder._listCopy(o.phaseResultsProcessors);
            this.requestProcessors = Builder._listCopy(o.requestProcessors);
            this.responseProcessors = Builder._listCopy(o.responseProcessors);
            this.timeout = o.timeout;
            this.version = o.version;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder clusterManagerTimeout(@Nullable Time value) {
            this.clusterManagerTimeout = value;
            return this;
        }

        @Nonnull
        public final Builder clusterManagerTimeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.clusterManagerTimeout(fn.apply(new Time.Builder()).build());
        }

        @Nonnull
        public final Builder description(@Nullable String value) {
            this.description = value;
            return this;
        }

        @Nonnull
        public final Builder id(String value) {
            this.id = value;
            return this;
        }

        @Nonnull
        public final Builder phaseResultsProcessors(List<PhaseResultsProcessor> list) {
            this.phaseResultsProcessors = Builder._listAddAll(this.phaseResultsProcessors, list);
            return this;
        }

        @Nonnull
        public final Builder phaseResultsProcessors(PhaseResultsProcessor value, PhaseResultsProcessor ... values) {
            this.phaseResultsProcessors = Builder._listAdd(this.phaseResultsProcessors, value, values);
            return this;
        }

        @Nonnull
        public final Builder phaseResultsProcessors(Function<PhaseResultsProcessor.Builder, ObjectBuilder<PhaseResultsProcessor>> fn) {
            return this.phaseResultsProcessors(fn.apply(new PhaseResultsProcessor.Builder()).build(), new PhaseResultsProcessor[0]);
        }

        @Nonnull
        public final Builder requestProcessors(List<RequestProcessor> list) {
            this.requestProcessors = Builder._listAddAll(this.requestProcessors, list);
            return this;
        }

        @Nonnull
        public final Builder requestProcessors(RequestProcessor value, RequestProcessor ... values) {
            this.requestProcessors = Builder._listAdd(this.requestProcessors, value, values);
            return this;
        }

        @Nonnull
        public final Builder requestProcessors(Function<RequestProcessor.Builder, ObjectBuilder<RequestProcessor>> fn) {
            return this.requestProcessors(fn.apply(new RequestProcessor.Builder()).build(), new RequestProcessor[0]);
        }

        @Nonnull
        public final Builder responseProcessors(List<ResponseProcessor> list) {
            this.responseProcessors = Builder._listAddAll(this.responseProcessors, list);
            return this;
        }

        @Nonnull
        public final Builder responseProcessors(ResponseProcessor value, ResponseProcessor ... values) {
            this.responseProcessors = Builder._listAdd(this.responseProcessors, value, values);
            return this;
        }

        @Nonnull
        public final Builder responseProcessors(Function<ResponseProcessor.Builder, ObjectBuilder<ResponseProcessor>> fn) {
            return this.responseProcessors(fn.apply(new ResponseProcessor.Builder()).build(), new ResponseProcessor[0]);
        }

        @Nonnull
        public final Builder timeout(@Nullable Time value) {
            this.timeout = value;
            return this;
        }

        @Nonnull
        public final Builder timeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.timeout(fn.apply(new Time.Builder()).build());
        }

        @Nonnull
        public final Builder version(@Nullable Integer value) {
            this.version = value;
            return this;
        }

        @Override
        @Nonnull
        public PutSearchPipelineRequest build() {
            this._checkSingleUse();
            return new PutSearchPipelineRequest(this);
        }
    }
}

