/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.nodes.stats;

import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch.nodes.stats.ShardIndexingPressurePerShardStats;
import org.opensearch.client.opensearch.nodes.stats.ShardIndexingPressureRejectionsBreakupStats;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class ShardIndexingPressureStats
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, ShardIndexingPressureStats> {
    @Nullable
    private final Boolean enabled;
    @Nullable
    private final Boolean enforced;
    @Nonnull
    private final Map<String, ShardIndexingPressurePerShardStats> stats;
    @Nullable
    private final ShardIndexingPressureRejectionsBreakupStats totalRejectionsBreakup;
    @Nullable
    private final ShardIndexingPressureRejectionsBreakupStats totalRejectionsBreakupShadowMode;
    public static final JsonpDeserializer<ShardIndexingPressureStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ShardIndexingPressureStats::setupShardIndexingPressureStatsDeserializer);

    private ShardIndexingPressureStats(Builder builder) {
        this.enabled = builder.enabled;
        this.enforced = builder.enforced;
        this.stats = ApiTypeHelper.unmodifiable(builder.stats);
        this.totalRejectionsBreakup = builder.totalRejectionsBreakup;
        this.totalRejectionsBreakupShadowMode = builder.totalRejectionsBreakupShadowMode;
    }

    public static ShardIndexingPressureStats of(Function<Builder, ObjectBuilder<ShardIndexingPressureStats>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Boolean enabled() {
        return this.enabled;
    }

    @Nullable
    public final Boolean enforced() {
        return this.enforced;
    }

    @Nonnull
    public final Map<String, ShardIndexingPressurePerShardStats> stats() {
        return this.stats;
    }

    @Nullable
    public final ShardIndexingPressureRejectionsBreakupStats totalRejectionsBreakup() {
        return this.totalRejectionsBreakup;
    }

    @Nullable
    public final ShardIndexingPressureRejectionsBreakupStats totalRejectionsBreakupShadowMode() {
        return this.totalRejectionsBreakupShadowMode;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.enabled != null) {
            generator.writeKey("enabled");
            generator.write(this.enabled.booleanValue());
        }
        if (this.enforced != null) {
            generator.writeKey("enforced");
            generator.write(this.enforced.booleanValue());
        }
        if (ApiTypeHelper.isDefined(this.stats)) {
            generator.writeKey("stats");
            generator.writeStartObject();
            for (Map.Entry<String, ShardIndexingPressurePerShardStats> item0 : this.stats.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.totalRejectionsBreakup != null) {
            generator.writeKey("total_rejections_breakup");
            this.totalRejectionsBreakup.serialize(generator, mapper);
        }
        if (this.totalRejectionsBreakupShadowMode != null) {
            generator.writeKey("total_rejections_breakup_shadow_mode");
            this.totalRejectionsBreakupShadowMode.serialize(generator, mapper);
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupShardIndexingPressureStatsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::enabled, JsonpDeserializer.booleanDeserializer(), "enabled");
        op.add(Builder::enforced, JsonpDeserializer.booleanDeserializer(), "enforced");
        op.add(Builder::stats, JsonpDeserializer.stringMapDeserializer(ShardIndexingPressurePerShardStats._DESERIALIZER), "stats");
        op.add(Builder::totalRejectionsBreakup, ShardIndexingPressureRejectionsBreakupStats._DESERIALIZER, "total_rejections_breakup");
        op.add(Builder::totalRejectionsBreakupShadowMode, ShardIndexingPressureRejectionsBreakupStats._DESERIALIZER, "total_rejections_breakup_shadow_mode");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.enabled);
        result = 31 * result + Objects.hashCode(this.enforced);
        result = 31 * result + Objects.hashCode(this.stats);
        result = 31 * result + Objects.hashCode(this.totalRejectionsBreakup);
        result = 31 * result + Objects.hashCode(this.totalRejectionsBreakupShadowMode);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShardIndexingPressureStats other = (ShardIndexingPressureStats)o;
        return Objects.equals(this.enabled, other.enabled) && Objects.equals(this.enforced, other.enforced) && Objects.equals(this.stats, other.stats) && Objects.equals(this.totalRejectionsBreakup, other.totalRejectionsBreakup) && Objects.equals(this.totalRejectionsBreakupShadowMode, other.totalRejectionsBreakupShadowMode);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, ShardIndexingPressureStats> {
        @Nullable
        private Boolean enabled;
        @Nullable
        private Boolean enforced;
        @Nullable
        private Map<String, ShardIndexingPressurePerShardStats> stats;
        @Nullable
        private ShardIndexingPressureRejectionsBreakupStats totalRejectionsBreakup;
        @Nullable
        private ShardIndexingPressureRejectionsBreakupStats totalRejectionsBreakupShadowMode;

        public Builder() {
        }

        private Builder(ShardIndexingPressureStats o) {
            this.enabled = o.enabled;
            this.enforced = o.enforced;
            this.stats = Builder._mapCopy(o.stats);
            this.totalRejectionsBreakup = o.totalRejectionsBreakup;
            this.totalRejectionsBreakupShadowMode = o.totalRejectionsBreakupShadowMode;
        }

        private Builder(Builder o) {
            this.enabled = o.enabled;
            this.enforced = o.enforced;
            this.stats = Builder._mapCopy(o.stats);
            this.totalRejectionsBreakup = o.totalRejectionsBreakup;
            this.totalRejectionsBreakupShadowMode = o.totalRejectionsBreakupShadowMode;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder enabled(@Nullable Boolean value) {
            this.enabled = value;
            return this;
        }

        @Nonnull
        public final Builder enforced(@Nullable Boolean value) {
            this.enforced = value;
            return this;
        }

        @Nonnull
        public final Builder stats(Map<String, ShardIndexingPressurePerShardStats> map) {
            this.stats = Builder._mapPutAll(this.stats, map);
            return this;
        }

        @Nonnull
        public final Builder stats(String key, ShardIndexingPressurePerShardStats value) {
            this.stats = Builder._mapPut(this.stats, key, value);
            return this;
        }

        @Nonnull
        public final Builder stats(String key, Function<ShardIndexingPressurePerShardStats.Builder, ObjectBuilder<ShardIndexingPressurePerShardStats>> fn) {
            return this.stats(key, fn.apply(new ShardIndexingPressurePerShardStats.Builder()).build());
        }

        @Nonnull
        public final Builder totalRejectionsBreakup(@Nullable ShardIndexingPressureRejectionsBreakupStats value) {
            this.totalRejectionsBreakup = value;
            return this;
        }

        @Nonnull
        public final Builder totalRejectionsBreakup(Function<ShardIndexingPressureRejectionsBreakupStats.Builder, ObjectBuilder<ShardIndexingPressureRejectionsBreakupStats>> fn) {
            return this.totalRejectionsBreakup(fn.apply(new ShardIndexingPressureRejectionsBreakupStats.Builder()).build());
        }

        @Nonnull
        public final Builder totalRejectionsBreakupShadowMode(@Nullable ShardIndexingPressureRejectionsBreakupStats value) {
            this.totalRejectionsBreakupShadowMode = value;
            return this;
        }

        @Nonnull
        public final Builder totalRejectionsBreakupShadowMode(Function<ShardIndexingPressureRejectionsBreakupStats.Builder, ObjectBuilder<ShardIndexingPressureRejectionsBreakupStats>> fn) {
            return this.totalRejectionsBreakupShadowMode(fn.apply(new ShardIndexingPressureRejectionsBreakupStats.Builder()).build());
        }

        @Override
        @Nonnull
        public ShardIndexingPressureStats build() {
            this._checkSingleUse();
            return new ShardIndexingPressureStats(this);
        }
    }
}

