/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.nodes.info;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class NodeInfoTransport
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, NodeInfoTransport> {
    @Nonnull
    private final List<String> boundAddress;
    @Nonnull
    private final Map<String, String> profiles;
    @Nonnull
    private final String publishAddress;
    public static final JsonpDeserializer<NodeInfoTransport> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, NodeInfoTransport::setupNodeInfoTransportDeserializer);

    private NodeInfoTransport(Builder builder) {
        this.boundAddress = ApiTypeHelper.unmodifiableRequired(builder.boundAddress, (Object)this, "boundAddress");
        this.profiles = ApiTypeHelper.unmodifiableRequired(builder.profiles, (Object)this, "profiles");
        this.publishAddress = ApiTypeHelper.requireNonNull(builder.publishAddress, this, "publishAddress");
    }

    public static NodeInfoTransport of(Function<Builder, ObjectBuilder<NodeInfoTransport>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nonnull
    public final List<String> boundAddress() {
        return this.boundAddress;
    }

    @Nonnull
    public final Map<String, String> profiles() {
        return this.profiles;
    }

    @Nonnull
    public final String publishAddress() {
        return this.publishAddress;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("bound_address");
        generator.writeStartArray();
        for (String string : this.boundAddress) {
            generator.write(string);
        }
        generator.writeEnd();
        generator.writeKey("profiles");
        generator.writeStartObject();
        for (Map.Entry entry : this.profiles.entrySet()) {
            generator.writeKey((String)entry.getKey());
            generator.write((String)entry.getValue());
        }
        generator.writeEnd();
        generator.writeKey("publish_address");
        generator.write(this.publishAddress);
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupNodeInfoTransportDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::boundAddress, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "bound_address");
        op.add(Builder::profiles, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.stringDeserializer()), "profiles");
        op.add(Builder::publishAddress, JsonpDeserializer.stringDeserializer(), "publish_address");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.boundAddress.hashCode();
        result = 31 * result + this.profiles.hashCode();
        result = 31 * result + this.publishAddress.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodeInfoTransport other = (NodeInfoTransport)o;
        return this.boundAddress.equals(other.boundAddress) && this.profiles.equals(other.profiles) && this.publishAddress.equals(other.publishAddress);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, NodeInfoTransport> {
        private List<String> boundAddress;
        private Map<String, String> profiles;
        private String publishAddress;

        public Builder() {
        }

        private Builder(NodeInfoTransport o) {
            this.boundAddress = Builder._listCopy(o.boundAddress);
            this.profiles = Builder._mapCopy(o.profiles);
            this.publishAddress = o.publishAddress;
        }

        private Builder(Builder o) {
            this.boundAddress = Builder._listCopy(o.boundAddress);
            this.profiles = Builder._mapCopy(o.profiles);
            this.publishAddress = o.publishAddress;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder boundAddress(List<String> list) {
            this.boundAddress = Builder._listAddAll(this.boundAddress, list);
            return this;
        }

        @Nonnull
        public final Builder boundAddress(String value, String ... values) {
            this.boundAddress = Builder._listAdd(this.boundAddress, value, values);
            return this;
        }

        @Nonnull
        public final Builder profiles(Map<String, String> map) {
            this.profiles = Builder._mapPutAll(this.profiles, map);
            return this;
        }

        @Nonnull
        public final Builder profiles(String key, String value) {
            this.profiles = Builder._mapPut(this.profiles, key, value);
            return this;
        }

        @Nonnull
        public final Builder publishAddress(String value) {
            this.publishAddress = value;
            return this;
        }

        @Override
        @Nonnull
        public NodeInfoTransport build() {
            this._checkSingleUse();
            return new NodeInfoTransport(this);
        }
    }
}

