/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.ml;

import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.ErrorResponse;
import org.opensearch.client.opensearch._types.RequestBase;
import org.opensearch.client.opensearch.ml.UpdateMemoryResponse;
import org.opensearch.client.transport.Endpoint;
import org.opensearch.client.transport.endpoints.SimpleEndpoint;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public final class UpdateMemoryRequest
extends RequestBase
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, UpdateMemoryRequest> {
    @Nonnull
    private final String memoryId;
    @Nullable
    private final String name;
    public static final JsonpDeserializer<UpdateMemoryRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, UpdateMemoryRequest::setupUpdateMemoryRequestDeserializer);
    public static final Endpoint<UpdateMemoryRequest, UpdateMemoryResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<UpdateMemoryRequest, UpdateMemoryResponse>(request -> "PUT", request -> {
        StringBuilder buf = new StringBuilder();
        buf.append("/_plugins/_ml/memory/");
        SimpleEndpoint.pathEncode(request.memoryId, buf);
        return buf.toString();
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        request.applyQueryParameters(params);
        return params;
    }, SimpleEndpoint.emptyMap(), true, UpdateMemoryResponse._DESERIALIZER);

    private UpdateMemoryRequest(Builder builder) {
        super(builder);
        this.memoryId = ApiTypeHelper.requireNonNull(builder.memoryId, this, "memoryId");
        this.name = builder.name;
    }

    public static UpdateMemoryRequest of(Function<Builder, ObjectBuilder<UpdateMemoryRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nonnull
    public final String memoryId() {
        return this.memoryId;
    }

    @Nullable
    public final String name() {
        return this.name;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.name != null) {
            generator.writeKey("name");
            generator.write(this.name);
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupUpdateMemoryRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::name, JsonpDeserializer.stringDeserializer(), "name");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.memoryId.hashCode();
        result = 31 * result + Objects.hashCode(this.name);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpdateMemoryRequest other = (UpdateMemoryRequest)o;
        return this.memoryId.equals(other.memoryId) && Objects.equals(this.name, other.name);
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, UpdateMemoryRequest> {
        private String memoryId;
        @Nullable
        private String name;

        public Builder() {
        }

        private Builder(UpdateMemoryRequest o) {
            super(o);
            this.memoryId = o.memoryId;
            this.name = o.name;
        }

        private Builder(Builder o) {
            super(o);
            this.memoryId = o.memoryId;
            this.name = o.name;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder memoryId(String value) {
            this.memoryId = value;
            return this;
        }

        @Nonnull
        public final Builder name(@Nullable String value) {
            this.name = value;
            return this;
        }

        @Override
        @Nonnull
        public UpdateMemoryRequest build() {
            this._checkSingleUse();
            return new UpdateMemoryRequest(this);
        }
    }
}

