/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.ism;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class IsmTemplate
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, IsmTemplate> {
    @Nonnull
    private final List<String> indexPatterns;
    @Nullable
    private final Integer lastUpdatedTime;
    @Nullable
    private final Number priority;
    public static final JsonpDeserializer<IsmTemplate> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, IsmTemplate::setupIsmTemplateDeserializer);

    private IsmTemplate(Builder builder) {
        this.indexPatterns = ApiTypeHelper.unmodifiable(builder.indexPatterns);
        this.lastUpdatedTime = builder.lastUpdatedTime;
        this.priority = builder.priority;
    }

    public static IsmTemplate of(Function<Builder, ObjectBuilder<IsmTemplate>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nonnull
    public final List<String> indexPatterns() {
        return this.indexPatterns;
    }

    @Nullable
    public final Integer lastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    @Nullable
    public final Number priority() {
        return this.priority;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.indexPatterns)) {
            generator.writeKey("index_patterns");
            generator.writeStartArray();
            for (String item0 : this.indexPatterns) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (this.lastUpdatedTime != null) {
            generator.writeKey("last_updated_time");
            generator.write(this.lastUpdatedTime.intValue());
        }
        if (this.priority != null) {
            generator.writeKey("priority");
            generator.write(this.priority.doubleValue());
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupIsmTemplateDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::indexPatterns, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "index_patterns");
        op.add(Builder::lastUpdatedTime, JsonpDeserializer.integerDeserializer(), "last_updated_time");
        op.add(Builder::priority, JsonpDeserializer.numberDeserializer(), "priority");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.indexPatterns);
        result = 31 * result + Objects.hashCode(this.lastUpdatedTime);
        result = 31 * result + Objects.hashCode(this.priority);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IsmTemplate other = (IsmTemplate)o;
        return Objects.equals(this.indexPatterns, other.indexPatterns) && Objects.equals(this.lastUpdatedTime, other.lastUpdatedTime) && Objects.equals(this.priority, other.priority);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, IsmTemplate> {
        @Nullable
        private List<String> indexPatterns;
        @Nullable
        private Integer lastUpdatedTime;
        @Nullable
        private Number priority;

        public Builder() {
        }

        private Builder(IsmTemplate o) {
            this.indexPatterns = Builder._listCopy(o.indexPatterns);
            this.lastUpdatedTime = o.lastUpdatedTime;
            this.priority = o.priority;
        }

        private Builder(Builder o) {
            this.indexPatterns = Builder._listCopy(o.indexPatterns);
            this.lastUpdatedTime = o.lastUpdatedTime;
            this.priority = o.priority;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder indexPatterns(List<String> list) {
            this.indexPatterns = Builder._listAddAll(this.indexPatterns, list);
            return this;
        }

        @Nonnull
        public final Builder indexPatterns(String value, String ... values) {
            this.indexPatterns = Builder._listAdd(this.indexPatterns, value, values);
            return this;
        }

        @Nonnull
        public final Builder lastUpdatedTime(@Nullable Integer value) {
            this.lastUpdatedTime = value;
            return this;
        }

        @Nonnull
        public final Builder priority(@Nullable Number value) {
            this.priority = value;
            return this;
        }

        @Override
        @Nonnull
        public IsmTemplate build() {
            this._checkSingleUse();
            return new IsmTemplate(this);
        }
    }
}

