/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.ingest;

import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch.ingest.Processor;
import org.opensearch.client.opensearch.ingest.ProcessorBase;
import org.opensearch.client.opensearch.ingest.ProcessorVariant;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class TextEmbeddingProcessor
extends ProcessorBase
implements ProcessorVariant,
ToCopyableBuilder<Builder, TextEmbeddingProcessor> {
    @Nullable
    private final Integer batchSize;
    @Nonnull
    private final Map<String, String> fieldMap;
    @Nonnull
    private final String modelId;
    public static final JsonpDeserializer<TextEmbeddingProcessor> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, TextEmbeddingProcessor::setupTextEmbeddingProcessorDeserializer);

    private TextEmbeddingProcessor(Builder builder) {
        super(builder);
        this.batchSize = builder.batchSize;
        this.fieldMap = ApiTypeHelper.unmodifiableRequired(builder.fieldMap, (Object)this, "fieldMap");
        this.modelId = ApiTypeHelper.requireNonNull(builder.modelId, this, "modelId");
    }

    public static TextEmbeddingProcessor of(Function<Builder, ObjectBuilder<TextEmbeddingProcessor>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Processor.Kind _processorKind() {
        return Processor.Kind.TextEmbedding;
    }

    @Nullable
    public final Integer batchSize() {
        return this.batchSize;
    }

    @Nonnull
    public final Map<String, String> fieldMap() {
        return this.fieldMap;
    }

    @Nonnull
    public final String modelId() {
        return this.modelId;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.batchSize != null) {
            generator.writeKey("batch_size");
            generator.write(this.batchSize.intValue());
        }
        generator.writeKey("field_map");
        generator.writeStartObject();
        for (Map.Entry<String, String> item0 : this.fieldMap.entrySet()) {
            generator.writeKey(item0.getKey());
            generator.write(item0.getValue());
        }
        generator.writeEnd();
        generator.writeKey("model_id");
        generator.write(this.modelId);
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupTextEmbeddingProcessorDeserializer(ObjectDeserializer<Builder> op) {
        TextEmbeddingProcessor.setupProcessorBaseDeserializer(op);
        op.add(Builder::batchSize, JsonpDeserializer.integerDeserializer(), "batch_size");
        op.add(Builder::fieldMap, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.stringDeserializer()), "field_map");
        op.add(Builder::modelId, JsonpDeserializer.stringDeserializer(), "model_id");
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.batchSize);
        result = 31 * result + this.fieldMap.hashCode();
        result = 31 * result + this.modelId.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TextEmbeddingProcessor other = (TextEmbeddingProcessor)o;
        return Objects.equals(this.batchSize, other.batchSize) && this.fieldMap.equals(other.fieldMap) && this.modelId.equals(other.modelId);
    }

    public static class Builder
    extends ProcessorBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, TextEmbeddingProcessor> {
        @Nullable
        private Integer batchSize;
        private Map<String, String> fieldMap;
        private String modelId;

        public Builder() {
        }

        private Builder(TextEmbeddingProcessor o) {
            super(o);
            this.batchSize = o.batchSize;
            this.fieldMap = Builder._mapCopy(o.fieldMap);
            this.modelId = o.modelId;
        }

        private Builder(Builder o) {
            super(o);
            this.batchSize = o.batchSize;
            this.fieldMap = Builder._mapCopy(o.fieldMap);
            this.modelId = o.modelId;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder batchSize(@Nullable Integer value) {
            this.batchSize = value;
            return this;
        }

        @Nonnull
        public final Builder fieldMap(Map<String, String> map) {
            this.fieldMap = Builder._mapPutAll(this.fieldMap, map);
            return this;
        }

        @Nonnull
        public final Builder fieldMap(String key, String value) {
            this.fieldMap = Builder._mapPut(this.fieldMap, key, value);
            return this;
        }

        @Nonnull
        public final Builder modelId(String value) {
            this.modelId = value;
            return this;
        }

        @Override
        @Nonnull
        public TextEmbeddingProcessor build() {
            this._checkSingleUse();
            return new TextEmbeddingProcessor(this);
        }
    }
}

