/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.indices.analyze;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class AnalyzeToken
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, AnalyzeToken> {
    private final int endOffset;
    private final int position;
    @Nullable
    private final Integer positionLength;
    private final int startOffset;
    @Nonnull
    private final String token;
    @Nonnull
    private final String type;
    public static final JsonpDeserializer<AnalyzeToken> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, AnalyzeToken::setupAnalyzeTokenDeserializer);

    private AnalyzeToken(Builder builder) {
        this.endOffset = ApiTypeHelper.requireNonNull(builder.endOffset, this, "endOffset");
        this.position = ApiTypeHelper.requireNonNull(builder.position, this, "position");
        this.positionLength = builder.positionLength;
        this.startOffset = ApiTypeHelper.requireNonNull(builder.startOffset, this, "startOffset");
        this.token = ApiTypeHelper.requireNonNull(builder.token, this, "token");
        this.type = ApiTypeHelper.requireNonNull(builder.type, this, "type");
    }

    public static AnalyzeToken of(Function<Builder, ObjectBuilder<AnalyzeToken>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final int endOffset() {
        return this.endOffset;
    }

    public final int position() {
        return this.position;
    }

    @Nullable
    public final Integer positionLength() {
        return this.positionLength;
    }

    public final int startOffset() {
        return this.startOffset;
    }

    @Nonnull
    public final String token() {
        return this.token;
    }

    @Nonnull
    public final String type() {
        return this.type;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("end_offset");
        generator.write(this.endOffset);
        generator.writeKey("position");
        generator.write(this.position);
        if (this.positionLength != null) {
            generator.writeKey("positionLength");
            generator.write(this.positionLength.intValue());
        }
        generator.writeKey("start_offset");
        generator.write(this.startOffset);
        generator.writeKey("token");
        generator.write(this.token);
        generator.writeKey("type");
        generator.write(this.type);
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupAnalyzeTokenDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::endOffset, JsonpDeserializer.integerDeserializer(), "end_offset");
        op.add(Builder::position, JsonpDeserializer.integerDeserializer(), "position");
        op.add(Builder::positionLength, JsonpDeserializer.integerDeserializer(), "positionLength");
        op.add(Builder::startOffset, JsonpDeserializer.integerDeserializer(), "start_offset");
        op.add(Builder::token, JsonpDeserializer.stringDeserializer(), "token");
        op.add(Builder::type, JsonpDeserializer.stringDeserializer(), "type");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Integer.hashCode(this.endOffset);
        result = 31 * result + Integer.hashCode(this.position);
        result = 31 * result + Objects.hashCode(this.positionLength);
        result = 31 * result + Integer.hashCode(this.startOffset);
        result = 31 * result + this.token.hashCode();
        result = 31 * result + this.type.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AnalyzeToken other = (AnalyzeToken)o;
        return this.endOffset == other.endOffset && this.position == other.position && Objects.equals(this.positionLength, other.positionLength) && this.startOffset == other.startOffset && this.token.equals(other.token) && this.type.equals(other.type);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, AnalyzeToken> {
        private Integer endOffset;
        private Integer position;
        @Nullable
        private Integer positionLength;
        private Integer startOffset;
        private String token;
        private String type;

        public Builder() {
        }

        private Builder(AnalyzeToken o) {
            this.endOffset = o.endOffset;
            this.position = o.position;
            this.positionLength = o.positionLength;
            this.startOffset = o.startOffset;
            this.token = o.token;
            this.type = o.type;
        }

        private Builder(Builder o) {
            this.endOffset = o.endOffset;
            this.position = o.position;
            this.positionLength = o.positionLength;
            this.startOffset = o.startOffset;
            this.token = o.token;
            this.type = o.type;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder endOffset(int value) {
            this.endOffset = value;
            return this;
        }

        @Nonnull
        public final Builder position(int value) {
            this.position = value;
            return this;
        }

        @Nonnull
        public final Builder positionLength(@Nullable Integer value) {
            this.positionLength = value;
            return this;
        }

        @Nonnull
        public final Builder startOffset(int value) {
            this.startOffset = value;
            return this;
        }

        @Nonnull
        public final Builder token(String value) {
            this.token = value;
            return this;
        }

        @Nonnull
        public final Builder type(String value) {
            this.type = value;
            return this;
        }

        @Override
        @Nonnull
        public AnalyzeToken build() {
            this._checkSingleUse();
            return new AnalyzeToken(this);
        }
    }
}

